/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel;

import com.sap.dictionary.types.mdi2metamodel.R3ToMetamodelDictionaryConverterWithNestedStructures;
import com.sap.dictionary.types.mdi2metamodel.model.DictionaryElement;
import com.sap.dictionary.types.mdi2metamodel.model.NestedStructure;
import com.sap.dictionary.types.mdi2metamodel.model.SimpleType;
import com.sap.dictionary.types.mdi2metamodel.model.Structure;
import com.sap.dictionary.types.services.NamingService;
import com.sap.ide.jcb.core.service.internal.R3Service;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.WebDynproMetamodelUtil;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelClassPropertySetting;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRoleSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mdi.Rfm;
import com.sap.mdi.RfmParameter;
import com.sap.mdi.RfmParameters;
import com.sap.mw.jco.JCO;
import org.eclipse.core.runtime.IProgressMonitor;

public class DynamicRFCModelImporter {
    private WebDynproRoot mWebDynproRoot = null;
    private DtDictionaryRoot mDictionary = null;
    private ModelType mModelType = null;
    private String mLanguage = "";
    private String mPackageName = "";
    private SourcePathIdentifier mSourcePathId = null;
    private String mModelName = "";
    private Model mModel = null;
    private ObjectFactory mJCOObjectFactory = null;
    private JCO.Client mJCOConnection = null;
    private ModelClass mInputModelClass = null;
    private ModelClass mOutputModelClass = null;
    private IProgressMonitor mMonitor = null;
    private R3ToMetamodelDictionaryConverterWithNestedStructures mDictionaryConverter = null;
    private String mImportStatusTitle = null;
    private String mSubTaskStatusTitle = null;
    private ImportLog mLog = new ImportLog();
    private static final String DICTIONARY_PACKAGE = "com.sap.dictionary";
    private static final String MODELTYPE_PACKAGE = "com.sap.ide.webdynpro.modeltypes";
    private static final String MODELTYPE_NAME = "DynamicRFCAdapter";
    public static final String RFC_PART_TYPE = "rfcPartType";
    public static final String ABAP_NAME = "abapName";
    public static final String IS_EXECUTABLE = "isExecutable";
    public static final String DEFAULT_SCOPE = "defaultScope";
    public static final String IS_LCOAL = "isLocal";
    public static final String MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM = "modelInstance_defaultLogicalSystem";
    public static final String RFC_PART_TYPE_INPUT = "input";
    public static final String RFC_PART_TYPE_OUTPUT = "output";
    public static final String RFC_PART_TYPE_STRUCTURE = "structure";
    public static final String REMOTE_FUNCTION_MODULES = "Remote Function Modules";
    public static final String RESULT_STRUCTURES = "Result Structures";
    public static final String DICTIONARY_STRUCTURES = "Dictionary Structures";

    public DynamicRFCModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro) throws Exception {
        this(dictionary, webdynpro, "en");
    }

    public DynamicRFCModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webDynproRoot, String language) throws Exception {
        this.mDictionary = dictionary;
        this.mWebDynproRoot = webDynproRoot;
        this.mLanguage = language;
        this.mModelType = webDynproRoot.getModelType(MODELTYPE_PACKAGE, MODELTYPE_NAME);
        if (this.mModelType == null) {
            this.mLog.addErrorMessage("Failed to retrieve the corresponding model type!");
        }
    }

    public Model doImport(String modelPackage, String modelName, SourcePathIdentifier sourcePathId, String logicalDictionaryName, String modelLogicalSystemName, String metadataLogicalSystemName, String dictionaryTypesPackageName, String[] rfcNames, IProgressMonitor monitor) {
        this.mLog.clear();
        try {
            this.mPackageName = modelPackage;
            this.mSourcePathId = sourcePathId;
            this.mMonitor = monitor;
            if (modelPackage == null) {
                this.mLog.addErrorMessage("\"" + modelPackage + "\" is not a valid model package!");
                return null;
            }
            this.mModelName = modelName;
            if (modelName == null || modelName.length() == 0) {
                this.mLog.addErrorMessage("\"" + modelName + "\" is not a valid model name!");
                return null;
            }
            if (null == this.mImportStatusTitle) {
                this.mImportStatusTitle = "Importing model";
            }
            if (null != this.mMonitor) {
                this.mMonitor.beginTask(this.mImportStatusTitle + " <" + modelName + ">...", rfcNames.length * 100 + 40);
                this.mMonitor.worked(20);
                this.mMonitor.subTask("Initializing...");
            }
            try {
                if (!this.establishJCOConnection()) {
                    this.mLog.addErrorMessage("Error in establishing connection");
                    return null;
                }
            }
            catch (Exception e) {
                this.mLog.addErrorMessage("Error in establishing connection");
                this.mLog.addException(e);
                return null;
            }
            if (null != this.mMonitor) {
                this.mMonitor.worked(20);
            }
            try {
                this.mDictionaryConverter = new R3ToMetamodelDictionaryConverterWithNestedStructures(this.mDictionary, dictionaryTypesPackageName, logicalDictionaryName, metadataLogicalSystemName, this.mJCOConnection);
                this.createModel(this.mModelName, modelLogicalSystemName);
            }
            catch (Exception e) {
                this.mLog.addErrorMessage("Error in creating Dictionary converter");
                this.mLog.addException(e);
                return null;
            }
            int i = 0;
            while (i < rfcNames.length) {
                this.ImportRFC(rfcNames[i]);
                ++i;
            }
            String metaModelLanguage = this.mWebDynproRoot.getMetamodel().getLanguage();
            if (!metaModelLanguage.equals(this.mJCOConnection.getLanguage())) {
                this.mJCOConnection.disconnect();
            }
            if (null != this.mMonitor) {
                this.mMonitor.done();
            }
            System.out.println(this.mLog.toString());
            return this.mModel;
        }
        catch (Exception e) {
            this.mLog.addException(e);
            return null;
        }
    }

    private boolean establishJCOConnection() {
        try {
            String metaModelLanguage;
            if (null == this.mJCOConnection) {
                this.mJCOConnection = R3Service.getInstance().getConnectionManager().getJCOClient();
            }
            if (!(metaModelLanguage = this.mWebDynproRoot.getMetamodel().getLanguage()).toUpperCase().equals(this.mJCOConnection.getLanguage().toUpperCase())) {
                System.out.println("Getting the Connection with language <" + metaModelLanguage + ">...");
                String client = this.mJCOConnection.getProperties().getProperty("jco.client.client");
                String password = this.mJCOConnection.getProperties().getProperty("jco.client.passwd");
                String msHost = this.mJCOConnection.getProperties().getProperty("jco.client.mshost");
                String r3name = this.mJCOConnection.getProperties().getProperty("jco.client.r3name");
                String groupname = this.mJCOConnection.getProperties().getProperty("jco.client.group");
                JCO.Client newClient = JCO.createClient((String)client, (String)this.mJCOConnection.getUser(), (String)password, (String)metaModelLanguage, (String)msHost, (String)r3name, (String)groupname);
                try {
                    newClient.connect();
                    this.mJCOConnection = newClient;
                }
                catch (Exception e) {
                    this.mLog.addWarningMessage("Creating a connection with Metamodel language <" + metaModelLanguage + "> failed.  Continuing with language <" + this.mJCOConnection.getLanguage() + ">");
                    this.mLog.addException(e);
                }
            }
            this.mJCOObjectFactory = new ObjectFactory(this.mJCOConnection);
        }
        catch (JCO.Exception e) {
            this.mLog.addErrorMessage("Error returning JCO Connection");
            this.mLog.addException(e);
            return false;
        }
        catch (ObjectFactoryException e) {
            this.mLog.addErrorMessage("Error creating Object Factory");
            this.mLog.addException(e);
            return false;
        }
        catch (Exception e) {
            this.mLog.addErrorMessage(e.getMessage());
            this.mLog.addException(e);
            return false;
        }
        return true;
    }

    private void ImportRFC(String rfcName) {
        Rfm rfm = null;
        try {
            rfm = this.mJCOObjectFactory.getRfm(rfcName);
        }
        catch (MetaDataAccessException e) {
            this.mLog.addErrorMessage("Error in retrieving RFC: " + rfcName);
            this.mLog.addException(e);
            return;
        }
        try {
            RfmParameters allRfmParams = rfm.getRfmParameters();
            this.mInputModelClass = this.createModelClass(DynamicRFCModelImporter.getCamelizedNameForType(rfcName) + "_Input");
            this.createModelClassSetting(this.mInputModelClass, RFC_PART_TYPE_INPUT, rfcName, "true", "scope", "ModelInstanceID", "false");
            this.mInputModelClass.setStereotype(REMOTE_FUNCTION_MODULES);
            this.mOutputModelClass = this.createModelClass(DynamicRFCModelImporter.getCamelizedNameForType(rfcName) + "_Output");
            this.createModelClassSetting(this.mOutputModelClass, RFC_PART_TYPE_OUTPUT, rfcName, "false", "scope", "ModelInstanceID", "false");
            this.mOutputModelClass.setStereotype(RESULT_STRUCTURES);
            int count = allRfmParams.getSize();
            int i = 0;
            while (i < count) {
                try {
                    DictionaryElement theDictionaryElement;
                    RfmParameter rfmParameter = (RfmParameter)allRfmParams.getItem(i);
                    if (null != this.mMonitor) {
                        if (null == this.mSubTaskStatusTitle) {
                            this.mSubTaskStatusTitle = "Importing";
                        }
                        this.mMonitor.subTask(this.mSubTaskStatusTitle + " RFC: <" + rfcName + "> :: Parameter <" + rfmParameter.getName() + ">");
                    }
                    if (null == (theDictionaryElement = this.mDictionaryConverter.getDdicObject(rfmParameter))) {
                        theDictionaryElement = this.mDictionaryConverter.createDdicObject(rfmParameter);
                    }
                    if (rfmParameter.isImport()) {
                        this.importImportRFMParameter(this.mInputModelClass, theDictionaryElement, rfmParameter);
                    }
                    if (rfmParameter.isExport()) {
                        this.importExportRFMParameter(this.mOutputModelClass, theDictionaryElement, rfmParameter);
                    }
                    if (null != this.mMonitor) {
                        this.mMonitor.worked(100 / count);
                    }
                }
                catch (Exception e) {
                    this.mLog.addException(e);
                }
                ++i;
            }
            this.createRelationInputOutput();
        }
        catch (Exception e) {
            this.mLog.addException(e);
            return;
        }
    }

    private void importImportRFMParameter(ModelClass inputModelClass, DictionaryElement theDictionaryElement, RfmParameter rfmParameter) {
        this.importRFMParameter(inputModelClass, theDictionaryElement, rfmParameter);
    }

    private void importExportRFMParameter(ModelClass outputModelClass, DictionaryElement theDictionaryElement, RfmParameter rfmParameter) {
        this.importRFMParameter(outputModelClass, theDictionaryElement, rfmParameter);
    }

    private void importRFMParameter(ModelClass modelClass, DictionaryElement theDictionaryElement, RfmParameter rfmParameter) {
        if (theDictionaryElement instanceof NestedStructure) {
            this.handleNestedStructure(modelClass, (NestedStructure)theDictionaryElement);
        }
        if (theDictionaryElement instanceof Structure) {
            this.handleStructure(modelClass, (Structure)theDictionaryElement, rfmParameter.getName());
        } else if (theDictionaryElement instanceof SimpleType) {
            this.handleSimpleType(modelClass, (SimpleType)theDictionaryElement, rfmParameter.getName());
        }
    }

    private void handleNestedStructure(ModelClass modelClass, NestedStructure nestedStructure) {
        ModelClass newModelClass = this.createModelClass(nestedStructure.getStructure().getName());
        String abapName = NamingService.Structure.getABAPNameFromBackendName((String)nestedStructure.getStructure().getBackendName());
        this.createModelClassSetting(newModelClass, RFC_PART_TYPE_STRUCTURE, abapName, "false", "scope", "ModelInstanceID", "false");
        newModelClass.setStructure((DevelopmentObject)nestedStructure.getStructure());
        if (!modelClass.equals(this.mInputModelClass) && !modelClass.equals(this.mOutputModelClass)) {
            String relationName = NamingService.Field.getABAPNameFromBackendName((String)nestedStructure.getBackendName());
            this.createModelRelationForModelClass(modelClass, newModelClass, (Structure)nestedStructure, relationName);
        }
        int numberOfStructures = nestedStructure.getNestedStructures().length;
        int i = 0;
        while (i < numberOfStructures) {
            Structure newStructure = nestedStructure.getNestedStructures()[i];
            String relationName = NamingService.Field.getABAPNameFromBackendName((String)newStructure.getBackendName());
            if (newStructure instanceof NestedStructure) {
                this.handleNestedStructure(newModelClass, (NestedStructure)newStructure);
            }
            this.handleStructure(newModelClass, newStructure, relationName);
            ++i;
        }
    }

    private void handleStructure(ModelClass modelClass, Structure theStructure, String relationName) {
        String modelClassName = theStructure.getStructure().getName();
        String abapName = NamingService.Structure.getABAPNameFromBackendName((String)theStructure.getStructure().getBackendName());
        ModelClass newModelClass = this.mModel.getModelClass(modelClassName);
        if (null == newModelClass) {
            newModelClass = this.createModelClass(modelClassName);
            this.createModelClassSetting(newModelClass, RFC_PART_TYPE_STRUCTURE, abapName, "false", "scope", "ModelInstanceID", "false");
            newModelClass.setStereotype(DICTIONARY_STRUCTURES);
        }
        this.createModelRelationForModelClass(modelClass, newModelClass, theStructure, relationName);
        newModelClass.setStructure((DevelopmentObject)theStructure.getStructure());
        try {
            DtStructure structure = theStructure.getStructure();
            DtStructureElement[] fields = structure.getStructureElements();
            int i = 1;
            while (i <= fields.length) {
                String propertyName = fields[i - 1].getName();
                if (!newModelClass.hasProperty(propertyName)) {
                    String abapFieldName = NamingService.Field.getABAPNameFromBackendName((String)((DtField)fields[i - 1]).getBackendName());
                    ModelClassProperty modelClassProperty = this.createModelClassProperty(newModelClass, propertyName);
                    modelClassProperty.setStructureElement((DevelopmentObject)fields[i - 1]);
                    this.createModelClassPropertySetting(modelClassProperty, abapFieldName, "false");
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.mLog.addException(e);
        }
    }

    private void handleSimpleType(ModelClass modelClass, SimpleType theSimpleType, String newModelClassPropertyName) {
        String modelClassPropertyName = DynamicRFCModelImporter.getCamelizedNameForType(newModelClassPropertyName);
        ModelClassProperty newModelClassProperty = (ModelClassProperty)modelClass.getProperty(modelClassPropertyName);
        if (null == newModelClassProperty) {
            newModelClassProperty = this.createModelClassProperty(modelClass, modelClassPropertyName);
            this.createModelClassPropertySetting(newModelClassProperty, newModelClassPropertyName, "false");
            newModelClassProperty.setType((DevelopmentObject)theSimpleType.getSimpleType());
        }
    }

    private void createRelationInputOutput() {
        String relationName = this.mInputModelClass.getName() + ":Output:" + this.mOutputModelClass.getName();
        if (null != this.mModel.getModelRelation(relationName)) {
            return;
        }
        ModelRelation inputRelation = this.createModelRelation(this.mModel, relationName);
        this.createModelRelationRole(inputRelation, "Source", this.mInputModelClass, false, CardinalityEnum._0_1, false);
        this.createModelRelationRole(inputRelation, "Output", this.mOutputModelClass, false, CardinalityEnum._0_1, true);
    }

    private void createTableRelationsForInput(RfmParameters allRfmParams) {
        this.createTableRelations(allRfmParams, this.mInputModelClass);
    }

    private void createTableRelationsForOutput(RfmParameters allRfmParams) {
        this.createTableRelations(allRfmParams, this.mOutputModelClass);
    }

    private void createTableRelations(RfmParameters allRfmParams, ModelClass modelClass) {
        String resultTableName;
        String outputTableName;
        String inputTableName = this.getTableName(allRfmParams, "EXTENSION_IN");
        if (null != inputTableName) {
            ModelClass inputTableClass = this.getModelClassByName(inputTableName);
            String inputRelationName = modelClass.getName() + "_Extension_In";
            if (null == this.mModel.getModelRelation(inputRelationName)) {
                ModelRelation inputRelation = this.createModelRelation(this.mModel, inputRelationName);
                this.createModelRelationRole(inputRelation, "Source", modelClass, false, CardinalityEnum._0_1, false);
                this.createModelRelationRole(inputRelation, "Extension_In", inputTableClass, false, CardinalityEnum._0_N, true);
            }
        }
        if (null != (outputTableName = this.getTableName(allRfmParams, "EXTENSION_OUT"))) {
            ModelClass outputTableClass = this.getModelClassByName(outputTableName);
            String outputRelationName = modelClass.getName() + "_Extension_Out";
            if (null == this.mModel.getModelRelation(outputRelationName)) {
                ModelRelation outputRelation = this.createModelRelation(this.mModel, outputRelationName);
                this.createModelRelationRole(outputRelation, "Source", modelClass, false, CardinalityEnum._0_1, false);
                this.createModelRelationRole(outputRelation, "Extension_Out", outputTableClass, false, CardinalityEnum._0_N, true);
            }
        }
        if (null != (resultTableName = this.getTableName(allRfmParams, "RETURN"))) {
            ModelClass resultTableClass = this.getModelClassByName(resultTableName);
            String resultRelationName = modelClass.getName() + "_Return";
            if (null == this.mModel.getModelRelation(resultRelationName)) {
                ModelRelation resultRelation = this.createModelRelation(this.mModel, resultRelationName);
                this.createModelRelationRole(resultRelation, "Source", modelClass, false, CardinalityEnum._0_1, false);
                this.createModelRelationRole(resultRelation, "Return", resultTableClass, false, CardinalityEnum._0_N, true);
            }
        }
    }

    private String getTableName(RfmParameters allRfmParams, String rfmParameterName) {
        int count = allRfmParams.getSize();
        int i = 0;
        while (i < count) {
            RfmParameter rfmParameter = (RfmParameter)allRfmParams.getItem(i);
            if (rfmParameter.isTable() && rfmParameter.getName().equals(rfmParameterName)) {
                return rfmParameter.getStructureName();
            }
            ++i;
        }
        return null;
    }

    private Model createModel(String modelName, String modelInstanceLogicalSystemName) {
        try {
            this.mLog.addInfoMessage("Creating Model: " + modelName);
            this.mModel = WebDynproMetamodelUtil.getOrCreateModel(this.mWebDynproRoot, this.mPackageName, this.mModelName, this.mSourcePathId);
            if (!this.mModel.hasModelType()) {
                this.mModel.setModelType(this.mModelType);
            }
            this.mModel.setLogicalDictionary((DevelopmentObject)this.mDictionaryConverter.getLogicalDictionary());
            try {
                ModelSetting lModelSetting = null;
                if (!this.mModel.hasSetting(MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM)) {
                    lModelSetting = this.mModel.createSetting(MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM);
                    lModelSetting.setValue(modelInstanceLogicalSystemName);
                    lModelSetting.setSettingDefinition(this.mModelType.getModelSettingDefinition(MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM));
                }
            }
            catch (CreateException e) {
                this.mLog.addException(e);
                return null;
            }
        }
        catch (MetamodelException e) {
            this.mLog.addException(e);
            return null;
        }
        return this.mModel;
    }

    private ModelClass createModelClass(String modelClassName) {
        this.mLog.addInfoMessage("Creating Model Class: " + modelClassName);
        ModelClass modelClass = null;
        try {
            modelClass = WebDynproMetamodelUtil.getOrCreateModelClass(this.mModel, this.mPackageName, modelClassName, this.mSourcePathId);
        }
        catch (MetamodelException e) {
            this.mLog.addException(e);
            return null;
        }
        return modelClass;
    }

    private void createModelClassSetting(ModelClass modelClass, String rfcPartType, String abapName, String isExecutable, String scope, String modelInstanceID, String isLocal) {
        if (null == modelClass) {
            return;
        }
        ModelClassSetting modelClassSetting = null;
        try {
            modelClassSetting = modelClass.getSetting(RFC_PART_TYPE);
            if (null == modelClassSetting) {
                modelClassSetting = modelClass.createSetting(RFC_PART_TYPE);
            }
            modelClassSetting.setValue(rfcPartType);
            modelClassSetting.setSettingDefinition(this.mModelType.getModelClassSettingDefinition(RFC_PART_TYPE));
            modelClassSetting = modelClass.getSetting(ABAP_NAME);
            if (null == modelClassSetting) {
                modelClassSetting = modelClass.createSetting(ABAP_NAME);
            }
            modelClassSetting.setValue(abapName);
            modelClassSetting.setSettingDefinition(this.mModelType.getModelClassSettingDefinition(ABAP_NAME));
            modelClassSetting = modelClass.getSetting(IS_EXECUTABLE);
            if (null == modelClassSetting) {
                modelClassSetting = modelClass.createSetting(IS_EXECUTABLE);
            }
            modelClassSetting.setValue(isExecutable);
            modelClassSetting.setSettingDefinition(this.mModelType.getModelClassSettingDefinition(IS_EXECUTABLE));
        }
        catch (CreateException e) {
            this.mLog.addException(e);
            return;
        }
    }

    private ModelClassProperty createModelClassProperty(ModelClass parentModelClass, String propertyName) {
        this.mLog.addInfoMessage("Creating Model Class Property: " + propertyName);
        ModelClassProperty modelClassProperty = null;
        try {
            modelClassProperty = parentModelClass.createProperty(propertyName);
        }
        catch (CreateException e) {
            this.mLog.addException(e);
            return null;
        }
        return modelClassProperty;
    }

    private void createModelClassPropertySetting(ModelClassProperty modelClassProperty, String abapName, String isLocal) {
        if (null == modelClassProperty) {
            return;
        }
        try {
            ModelClassPropertySetting modelClassPropertySetting = null;
            modelClassPropertySetting = modelClassProperty.getSetting(ABAP_NAME);
            if (null == modelClassPropertySetting) {
                modelClassPropertySetting = modelClassProperty.createSetting(ABAP_NAME);
            }
            modelClassPropertySetting.setValue(abapName);
            modelClassPropertySetting.setSettingDefinition(this.mModelType.getModelClassPropertySettingDefinition(ABAP_NAME));
        }
        catch (CreateException e) {
            this.mLog.addException(e);
            return;
        }
    }

    private ModelRelation createModelRelation(Model model, String relationName) {
        this.mLog.addInfoMessage("Creating Model Relation: " + relationName);
        ModelRelation theRelation = null;
        try {
            theRelation = this.mModel.createModelRelation(relationName);
        }
        catch (CreateException e) {
            this.mLog.addException(e);
            return null;
        }
        return theRelation;
    }

    private ModelRelationRole createModelRelationRole(ModelRelation modelRelation, String roleName, ModelClass modelClass, boolean isAggregrated, CardinalityEnum cardinality, boolean isNavigable) {
        ModelRelationRole relationRole = modelRelation.getModelRelationRole(roleName);
        if (null == relationRole) {
            try {
                relationRole = modelRelation.createModelRelationRole(roleName);
            }
            catch (MetamodelException e) {
                this.mLog.addException(e);
                return null;
            }
        }
        relationRole.setModelClass(modelClass);
        relationRole.setAggregate(isAggregrated);
        relationRole.setCardinality(cardinality);
        relationRole.setNavigable(isNavigable);
        return relationRole;
    }

    private void createModelRelationRoleSetting(ModelRelationRole modelRelationRole, String abapName, String isLocal) {
        if (null == modelRelationRole) {
            return;
        }
        try {
            ModelRelationRoleSetting modelRelationRoleSetting = null;
            modelRelationRoleSetting = modelRelationRole.getSetting(ABAP_NAME);
            if (null == modelRelationRoleSetting) {
                modelRelationRoleSetting = modelRelationRole.createSetting(ABAP_NAME);
            }
            modelRelationRoleSetting.setValue(abapName);
            modelRelationRoleSetting.setSettingDefinition(this.mModelType.getModelRelationRoleSettingDefinition(ABAP_NAME));
        }
        catch (CreateException e) {
            this.mLog.addException(e);
            return;
        }
    }

    private ModelClass getModelClassByName(String modelClassName) {
        return this.mModel.getModelClass(modelClassName);
    }

    private static String getCamelizedNameForType(String name) {
        return NamingService.Type.getJavaNameFromBackendName((String)NamingService.Type.getBackendNameFromABAPName((String)name));
    }

    public ImportLog getImportLog() {
        return this.mLog;
    }

    private void createModelRelationForModelClass(ModelClass modelClass, ModelClass newModelClass, Structure theStructure, String relationName) {
        String newRelationName = modelClass.getName() + ":" + DynamicRFCModelImporter.getCamelizedNameForType(relationName);
        ModelRelation newRelation = null;
        if (this.mModel.hasModelRelation(newRelationName)) {
            return;
        }
        newRelation = this.createModelRelation(this.mModel, newRelationName);
        ModelRelationRole sourceModelRelationRole = this.createModelRelationRole(newRelation, "Source", modelClass, false, CardinalityEnum._0_1, false);
        this.createModelRelationRoleSetting(sourceModelRelationRole, relationName, "false");
        CardinalityEnum targetRoleCardinality = null;
        targetRoleCardinality = theStructure.getIsTable() ? CardinalityEnum._0_N : CardinalityEnum._0_1;
        ModelRelationRole targetmodelRelationRole = this.createModelRelationRole(newRelation, DynamicRFCModelImporter.getCamelizedNameForType(relationName), newModelClass, false, targetRoleCardinality, true);
        this.createModelRelationRoleSetting(targetmodelRelationRole, relationName, "false");
    }

    public void setImportStatusTitle(String importStatusTitle) {
        this.mImportStatusTitle = importStatusTitle;
    }

    public void setSubTaskStatusTitle(String subTaskStatusTitle) {
        this.mSubTaskStatusTitle = subTaskStatusTitle;
    }
}

