/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.javabean;

import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class JavaBeanResourceImporter
implements IOverwriteQuery {
    private WebDynproRoot mWebDynproRoot;
    private Shell mShell;
    private String mProjectName;
    private String mJarPath;

    public JavaBeanResourceImporter(WebDynproRoot webDynpro, String jarPath, Shell shell) {
        this.mWebDynproRoot = webDynpro;
        this.mJarPath = jarPath;
        this.mShell = shell;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.mProjectName = webDynpro.getMetamodel().getName();
    }

    public void addToRawClassPath() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mProjectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            IPath outputPath = javaProject.getOutputLocation();
            Path entryPath = new Path(this.mJarPath);
            IPath sourceLoc = null;
            IPath sourceRoot = null;
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)entryPath, sourceLoc, sourceRoot);
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
            int i = 0;
            while (i < entries.length) {
                newEntries[i] = entries[i];
                ++i;
            }
            newEntries[newEntries.length - 1] = newEntry;
            javaProject.setRawClasspath(newEntries, outputPath, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            System.out.println("Duplicate Enrry");
        }
    }

    public void addSharingReference() {
    }

    public void importResource() {
        String fileName = this.mJarPath;
        if (fileName != null) {
            File file = new File(fileName);
            FileSystemElement element = new FileSystemElement(fileName, null, false);
            ArrayList<File> fileSystemObjects = new ArrayList<File>();
            fileSystemObjects.add(file);
            IPath path = new Path(this.mProjectName + "\\lib").makeAbsolute();
            ImportOperation operation = new ImportOperation(path, (Object)new File(file.getParent()), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, fileSystemObjects);
            operation.setContext(this.mShell);
            operation.setCreateContainerStructure(false);
            operation.setOverwriteResources(false);
            this.executeImportOperation(operation);
        }
    }

    private boolean executeImportOperation(ImportOperation op) {
        ProgressMonitorDialog fRunnableContext = new ProgressMonitorDialog(this.mShell);
        try {
            fRunnableContext.run(false, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.mShell, (String)"FileImport.importProblems", null, (IStatus)status);
            return false;
        }
        MessageDialog.openInformation((Shell)this.mShell, (String)"Import JavaBean Source", (String)"The Jar is successfully imported to the lib folder of the project");
        return true;
    }

    private void displayErrorDialog(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = WorkbenchMessages.format((String)"WizardDataTransfer.exceptionMessage", (Object[])new String[]{exception.toString()});
        }
        this.displayErrorDialog(message);
    }

    private void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.mShell, (String)"Error", (String)message);
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? WorkbenchMessages.format((String)"WizardDataTransfer.existsQuestion", (Object[])new String[]{pathString}) : WorkbenchMessages.format((String)"WizardDataTransfer.overwriteNameAndPathQuestion", (Object[])new String[]{path.lastSegment(), path.removeLastSegments(1).toOSString()});
        final MessageDialog dialog = new MessageDialog(this.mShell, WorkbenchMessages.getString((String)"Question"), null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.mShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }
}

