/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.javabean;

import com.sap.ide.metamodel.importers.javabean.JavaBeanModelClass;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelProperty;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;

public class JavaBeanModelRelation {
    private String mRelationName;
    private JavaBeanModelClass mParent;
    private JavaBeanModelClass mSourceClass;
    private JavaBeanModelClass mTargetClass;
    private JavaBeanModelProperty mProperty;
    private String mSourceRole;
    private String mTargetRole;
    private String[] mModelClassNames;
    private String mTargetClassName;
    private boolean mIsNavigable;
    private CardinalityEnum mSourceCardinality;
    private CardinalityEnum mTargetCardinality;
    private boolean mSourceAggregation;
    private boolean mTargetAggregation;
    private boolean mIsSelected;
    private boolean mIsResolved;
    private boolean mIsValid;

    public JavaBeanModelRelation() {
    }

    public JavaBeanModelRelation(JavaBeanModelClass modelClass, JavaBeanModelProperty property) {
        this.mSourceClass = modelClass;
        this.mProperty = property;
        if (this.mSourceClass != null && this.mProperty != null) {
            this.mRelationName = this.mSourceClass.getName() + "." + this.toHungarianNotation(this.mProperty.getName());
            this.mSourceRole = this.mRelationName + "." + "untitled";
            this.mTargetRole = this.toHungarianNotation(this.mProperty.getName());
        }
        this.mSourceCardinality = CardinalityEnum.valueOf((String)"_0_1");
        this.mTargetCardinality = CardinalityEnum.valueOf((String)"_0_1");
        this.mSourceAggregation = false;
        this.mTargetAggregation = false;
        this.mIsSelected = true;
        this.mIsValid = true;
    }

    public void setParent(JavaBeanModelClass modelClass) {
        this.mParent = modelClass;
    }

    public JavaBeanModelClass getParent() {
        return this.mParent;
    }

    public JavaBeanModelClass getSourceClass() {
        return this.mSourceClass;
    }

    public void setSourceClass(JavaBeanModelClass modelClass) {
        this.mSourceClass = modelClass;
    }

    public JavaBeanModelClass getTargetClass() {
        return this.mTargetClass;
    }

    public void setTargetClass(JavaBeanModelClass modelClass) {
        this.mTargetClass = modelClass;
    }

    public JavaBeanModelProperty getProperty() {
        return this.mProperty;
    }

    public void setProperty(JavaBeanModelProperty property) {
        this.mProperty = property;
    }

    public String getSourceRole() {
        if (this.mSourceRole == null) {
            this.mSourceRole = this.mSourceClass.getName() + "." + this.toHungarianNotation(this.mProperty.getName());
        }
        return this.mSourceRole;
    }

    public void setSourceRole(String string) {
        this.mSourceRole = string;
    }

    public String getTargetRole() {
        if (this.mTargetRole == null) {
            this.mTargetRole = this.toHungarianNotation(this.mProperty.getName());
        }
        return this.mTargetRole;
    }

    public void setTargetRole(String string) {
        this.mTargetRole = string;
    }

    public CardinalityEnum getSourceCardinality() {
        return this.mSourceCardinality;
    }

    public void setSourceCardinality(CardinalityEnum cardinalityEnum) {
        this.mSourceCardinality = cardinalityEnum;
    }

    public CardinalityEnum getTargetCardinality() {
        return this.mTargetCardinality;
    }

    public void setTargetCardinality(CardinalityEnum cardinalityEnum) {
        this.mTargetCardinality = cardinalityEnum;
    }

    public boolean getSourceAggregation() {
        return this.mSourceAggregation;
    }

    public void setSourceAggregation(boolean aggregation) {
        this.mSourceAggregation = aggregation;
    }

    public boolean getTargetAggregation() {
        return this.mTargetAggregation;
    }

    public void setTargetAggregation(boolean aggregation) {
        this.mTargetAggregation = aggregation;
    }

    public String getRelationName() {
        if (this.mRelationName == null) {
            this.mRelationName = "";
        }
        return this.mRelationName;
    }

    public void setRelationName(String string) {
        this.mRelationName = string;
    }

    public String[] getModelClassNames() {
        if (this.mModelClassNames == null) {
            return new String[0];
        }
        return this.mModelClassNames;
    }

    public void setModelClassNames(String[] strings) {
        this.mModelClassNames = strings;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setSelected(boolean b) {
        this.mIsSelected = b;
    }

    public boolean isResolved() {
        return this.mIsResolved;
    }

    public void setResolved(boolean b) {
        this.mIsResolved = b;
        this.mIsValid = true;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public void setValid(boolean b) {
        this.mIsValid = b;
    }

    public boolean isNavigable() {
        return this.mIsNavigable;
    }

    public void setNavigable(boolean navigability) {
        this.mIsNavigable = navigability;
    }

    public String getModelClassName() {
        if (this.mTargetClassName == null && this.mModelClassNames != null && this.mModelClassNames.length > 0) {
            this.mTargetClassName = this.mModelClassNames[0];
        }
        if (this.mTargetClassName != null) {
            return this.mTargetClassName;
        }
        return "";
    }

    public int getModelClassNameIndex() {
        if (this.mTargetClassName != null && this.mModelClassNames != null && this.mModelClassNames.length > 0) {
            int i = 0;
            while (i < this.mModelClassNames.length) {
                if (this.mModelClassNames[i].equals(this.mTargetClassName)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setModelClassName(String name) {
        this.mTargetClassName = name;
    }

    public void setModelClassName(int index) {
        if (this.mModelClassNames != null && index >= 0 && index < this.mModelClassNames.length) {
            this.mTargetClassName = this.mModelClassNames[index];
        }
    }

    private String toHungarianNotation(String name) {
        if (name != null) {
            if ((name = name.trim()).length() > 1) {
                char fChar = name.charAt(0);
                fChar = Character.toUpperCase(fChar);
                name = name.substring(1);
                name = fChar + name;
            } else {
                name = name.toUpperCase();
            }
            return name;
        }
        return "";
    }
}

