/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.javabean;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelClass;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelData;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelProperty;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelRelation;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.AppClass;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaBeanModelImporter {
    private static final String DICTIONARY_PACKAGE = "com.sap.dictionary";
    private static final String MODELTYPE_PACKAGE = "com.sap.ide.webdynpro.modeltypes";
    private static final String MODELTYPE_NAME = "JavaBean";
    private WebDynproRoot mWebDynproRoot;
    private DtDictionaryRoot mDictionaryRoot;
    private String mLanguage;
    private JavaBeanModelData mJavaBeanModelData;
    private Model mModel;
    private ModelType mModelType;
    private ImportLog mImportLog;

    public JavaBeanModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro, JavaBeanModelData modelData) throws Exception {
        this(dictionary, webdynpro, modelData, "en");
    }

    public JavaBeanModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro, JavaBeanModelData modelData, String language) throws Exception {
        this.mDictionaryRoot = dictionary;
        this.mWebDynproRoot = webdynpro;
        this.mJavaBeanModelData = modelData;
        this.mLanguage = language;
        if (this.mJavaBeanModelData.getRelationsToResolve() == null || this.mJavaBeanModelData.getRelationsToResolve().length == 0) {
            this.mJavaBeanModelData.initializeRelationsToResolve();
        }
        this.mJavaBeanModelData.updateModelRelations();
        this.mImportLog = new ImportLog();
    }

    public Model doImport(String modelPackageName, String modelName, SourcePathIdentifier sourcePathIdentifier) throws Exception {
        block33: {
            try {
                boolean status = this.mJavaBeanModelData.getImportStatus();
                if (this.mImportLog == null) {
                    this.mImportLog = new ImportLog();
                }
                this.mImportLog.clear();
                if (!status) {
                    this.mImportLog.addInfoMessage("Following is the status of the model being created.");
                    this.mImportLog.addInfoMessage("    Name of the model: \"" + modelName + "\", package: " + modelPackageName);
                } else {
                    this.mModel = this.mWebDynproRoot.createModel(modelPackageName, modelName, sourcePathIdentifier);
                    this.mModelType = this.mWebDynproRoot.getModelType(MODELTYPE_PACKAGE, MODELTYPE_NAME);
                    this.mModel.setModelType(this.mModelType);
                    ModelSetting lModelSetting = this.mModel.createSetting("requiresCodeGeneration");
                    lModelSetting.setValue("false");
                    lModelSetting.setSettingDefinition(this.mModelType.getModelSettingDefinition("requiresCodeGeneration"));
                }
                JavaBeanModelClass[] javaBeanClasses = this.mJavaBeanModelData.getModelClasses();
                ModelClass[] modelClasses = null;
                Class typeClass = null;
                if (javaBeanClasses == null) break block33;
                modelClasses = new ModelClass[javaBeanClasses.length];
                int i = 0;
                while (i < javaBeanClasses.length) {
                    typeClass = javaBeanClasses[i].getTypeClass();
                    if (!status) {
                        this.mImportLog.addInfoMessage("        Adding modelclass: \"" + javaBeanClasses[i].getName() + "\", package: " + typeClass.getPackage());
                    } else {
                        modelClasses[i] = this.mModel.createModelClass(typeClass.getPackage().getName(), javaBeanClasses[i].getName(), sourcePathIdentifier);
                        if (typeClass.isInterface()) {
                            modelClasses[i].setIsAbstract(true);
                            modelClasses[i].setIsInterface(true);
                        } else if (Modifier.isAbstract(typeClass.getModifiers())) {
                            modelClasses[i].setIsAbstract(true);
                        }
                    }
                    ++i;
                }
                this.setInheritenceSettings(javaBeanClasses);
                ModelClass modelClass = null;
                JavaBeanModelClass javaBeanClass = null;
                Object fields = null;
                ModelClassProperty property = null;
                JavaBeanModelProperty[] modelProperties = null;
                JavaBeanModelProperty modelProperty = null;
                Object fieldType = null;
                String typeName = null;
                int propCount = 0;
                int i2 = 0;
                while (i2 < modelClasses.length) {
                    propCount = 0;
                    modelClass = modelClasses[i2];
                    javaBeanClass = javaBeanClasses[i2];
                    modelProperties = javaBeanClass.getProperties();
                    this.mImportLog.addInfoMessage("    Properties for the modelclass: \"" + javaBeanClass.getName() + "\"");
                    if (modelProperties != null) {
                        int j = 0;
                        while (j < modelProperties.length) {
                            if (modelProperties[j].isSelected() && !modelProperties[j].isCollection()) {
                                ++propCount;
                                if (!status) {
                                    this.mImportLog.addInfoMessage("        Adding property \"" + modelProperties[j].getName() + "\", type: " + modelProperties[j].getPropertyType().getName());
                                } else {
                                    property = modelClass.createProperty(modelProperties[j].getName());
                                    if (modelProperties[j].isReadOnly()) {
                                        property.setReadonly(true);
                                    }
                                    typeName = modelProperties[j].getPropertyClass().getName();
                                    this.setType(property, typeName);
                                }
                            } else if (!status) {
                                this.mImportLog.addWarningMessage("        Property \"" + modelProperties[j].getName() + "\", type: " + modelProperties[j].getPropertyType().getName() + ", is not selected");
                            }
                            ++j;
                        }
                        if (propCount == 0) {
                            this.mImportLog.addInfoMessage("No properties added for this class");
                        }
                    } else {
                        this.mImportLog.addInfoMessage("No properties added for this class");
                    }
                    ++i2;
                }
                if (!status) {
                    this.mImportLog.addInfoMessage("    Relations for the model: \"" + modelName + "\"");
                }
                JavaBeanModelRelation[] relations = this.mJavaBeanModelData.getRelationsToResolve();
                JavaBeanModelRelation relation = null;
                String sourceClassName = null;
                String targetClassName = null;
                ModelClass sourceClass = null;
                ModelClass targetClass = null;
                ModelClass arrayModelClass = null;
                Class<?> propClass = null;
                int warnCount = 0;
                int i3 = 0;
                while (i3 < relations.length) {
                    block36: {
                        block34: {
                            block37: {
                                block35: {
                                    relation = relations[i3];
                                    sourceClassName = relation.getSourceClass().getName();
                                    if (!status) {
                                        this.mImportLog.addInfoMessage("    Inspecting relation \"" + relation.getRelationName() + "\" for source class \"" + sourceClassName + "\"");
                                    }
                                    if (!relation.isSelected()) break block34;
                                    if (relation.getTargetClass() != null) break block35;
                                    if (status) break block36;
                                    ++warnCount;
                                    this.mImportLog.addWarningMessage("    This relation cannot be added as the TargetModelClass is not specified");
                                    break block37;
                                }
                                targetClassName = relation.getTargetClass().getName();
                                this.mImportLog.addInfoMessage("    adding relation \"" + relation.getRelationName() + "\"");
                                this.mImportLog.addInfoMessage("        Source Class: \"" + sourceClassName + "\"");
                                this.mImportLog.addInfoMessage("        Target Class: \"" + targetClassName + "\"");
                            }
                            if (status) {
                                int j = 0;
                                while (j < modelClasses.length) {
                                    if (sourceClassName.equals(modelClasses[j].getName())) {
                                        sourceClass = modelClasses[j];
                                    }
                                    if (targetClassName.equals(modelClasses[j].getName())) {
                                        targetClass = modelClasses[j];
                                    }
                                    ++j;
                                }
                                if (relation.getProperty().isArray()) {
                                    modelProperty = relation.getProperty();
                                    propClass = modelProperty.getPropertyClass().getComponentType();
                                    arrayModelClass = this.mModel.createModelClass(propClass.getPackage().getName(), targetClassName + "Array", sourcePathIdentifier);
                                    this.createArrayRelations(relation, sourceClass, targetClass, arrayModelClass);
                                    modelClasses = this.updateModelClasses(arrayModelClass, modelClasses);
                                } else {
                                    this.createRelations(relation, sourceClass, targetClass);
                                }
                            }
                            break block36;
                        }
                        if (!status) {
                            this.mImportLog.addWarningMessage("    This relation cannot be added as this is not selected");
                        }
                    }
                    ++i3;
                }
                if (warnCount > 0 && !status) {
                    this.mImportLog.addErrorMessage("There are one or more relations unresolved. Importing the model without resolvoing the relations might result in erratic output.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return this.mModel;
    }

    private void setInheritenceSettings(JavaBeanModelClass[] beanClasses) {
        if (beanClasses != null) {
            Class typeClass = null;
            Class<Object> superClass = null;
            JavaBeanModelClass beanClass = null;
            JavaBeanModelClass superBeanClass = null;
            ModelClass modelClass = null;
            ModelClass superModelClass = null;
            Class<?>[] interfaces = null;
            int i = 0;
            while (i < beanClasses.length) {
                beanClass = beanClasses[i];
                typeClass = beanClass.getTypeClass();
                modelClass = this.mModel.getModelClass(typeClass.getPackage().getName(), beanClass.getName());
                superClass = typeClass.getSuperclass();
                superBeanClass = this.mJavaBeanModelData.getModelClass(superClass);
                if (superBeanClass != null) {
                    superModelClass = this.mModel.getModelClass(superClass.getPackage().getName(), superBeanClass.getName());
                    modelClass.setSuperClass((AppClass)superModelClass);
                }
                if ((interfaces = typeClass.getInterfaces()) != null) {
                    int j = 0;
                    while (j < interfaces.length) {
                        superClass = interfaces[j];
                        superBeanClass = this.mJavaBeanModelData.getModelClass(superClass);
                        if (superBeanClass != null) {
                            superModelClass = this.mModel.getModelClass(superClass.getPackage().getName(), superBeanClass.getName());
                            modelClass.addInterface(superModelClass);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private ModelClass[] updateModelClasses(ModelClass modelClass, ModelClass[] classArray) {
        ModelClass[] modelClasses = new ModelClass[]{};
        if (modelClass != null && classArray != null) {
            modelClasses = new ModelClass[classArray.length + 1];
            int i = 0;
            while (i < classArray.length) {
                modelClasses[i] = classArray[i];
                ++i;
            }
            modelClasses[classArray.length] = modelClass;
        }
        return modelClasses;
    }

    private DevelopmentObject builtInType(String typeName) {
        if (typeName.equals("String") || typeName.equals("java.lang.String")) {
            typeName = "string";
        } else if (typeName.equals("Date") || typeName.equals("java.sql.Date")) {
            typeName = "date";
        } else if (typeName.equals("double")) {
            typeName = "double";
        } else if (typeName.equals("Double") || typeName.equals("java.lang.Double")) {
            typeName = "doubleObject";
        } else if (typeName.equals("boolean")) {
            typeName = "boolean";
        } else if (typeName.equals("Boolean") || typeName.equals("java.lang.Boolean")) {
            typeName = "booleanObject";
        } else if (typeName.equals("Time") || typeName.equals("java.sql.Time")) {
            typeName = "time";
        } else if (typeName.equals("Timestamp") || typeName.equals("java.sql.Timestamp")) {
            typeName = "timestamp";
        } else if (typeName.equals("short")) {
            typeName = "short";
        } else if (typeName.equals("Short") || typeName.equals("java.lang.Short")) {
            typeName = "shortObject";
        } else if (typeName.equals("long")) {
            typeName = "long";
        } else if (typeName.equals("Long") || typeName.equals("java.lang.Long")) {
            typeName = "longObject";
        } else if (typeName.equals("float")) {
            typeName = "float";
        } else if (typeName.equals("Float") || typeName.equals("java.lang.Float")) {
            typeName = "floatObject";
        } else if (typeName.equals("int")) {
            typeName = "integer";
        } else if (typeName.equals("Integer") || typeName.equals("java.lang.Integer")) {
            typeName = "integerObject";
        } else if (typeName.equals("BigDecimal") || typeName.equals("java.math.BigDecimal")) {
            typeName = "decimal";
        } else if (typeName.equals("byte[]")) {
            typeName = "binary";
        }
        DtSimpleType devType = null;
        try {
            devType = this.mDictionaryRoot.getSimpleType(DICTIONARY_PACKAGE, typeName);
        }
        catch (LoadException e) {
            e.printStackTrace();
        }
        return devType;
    }

    private void setType(ModelClassProperty property, String typeName) throws Exception {
        DevelopmentObject type = this.builtInType(typeName);
        if (type != null) {
            property.setType(type);
        } else if (typeName.indexOf(46) != -1) {
            String lName = typeName.substring(typeName.lastIndexOf(46) + 1);
            String lPackage = typeName.substring(0, typeName.lastIndexOf(46));
            JavaNativeType lNativeType = property.createNativeTypeAsJavaNativeType(lName);
            lNativeType.setJavaPackage(lPackage);
            property.setType((DevelopmentObject)lNativeType);
        } else {
            JavaNativeType lNativeType = property.createNativeTypeAsJavaNativeType(typeName);
            property.setType((DevelopmentObject)lNativeType);
        }
    }

    private void createRelations(JavaBeanModelRelation relation, ModelClass sourceClass, ModelClass targetClass) throws Exception {
        if (relation != null && sourceClass != null && targetClass != null) {
            try {
                JavaBeanModelProperty property = relation.getProperty();
                ModelRelation modelRelation = this.mModel.createModelRelation(relation.getRelationName());
                ModelRelationRole roleA = null;
                ModelRelationRole roleB = null;
                roleA = modelRelation.createModelRelationRole(relation.getSourceRole());
                roleA.setAggregate(relation.getSourceAggregation());
                roleA.setCardinality(relation.getSourceCardinality());
                roleA.setNavigable(relation.isNavigable());
                roleA.setModelClass(sourceClass);
                roleB = modelRelation.createModelRelationRole(relation.getTargetRole());
                roleB.setAggregate(relation.getTargetAggregation());
                roleB.setCardinality(relation.getTargetCardinality());
                roleB.setNavigable(true);
                roleB.setModelClass(targetClass);
            }
            catch (CreateException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    private void createArrayRelations(JavaBeanModelRelation relation, ModelClass sourceClass, ModelClass targetClass, ModelClass arrayClass) throws Exception {
        if (relation != null && sourceClass != null && targetClass != null && arrayClass != null) {
            try {
                JavaBeanModelProperty property = relation.getProperty();
                ModelRelation modelRelation = this.mModel.createModelRelation(arrayClass.getName());
                ModelRelationRole roleA = null;
                ModelRelationRole roleB = null;
                roleA = modelRelation.createModelRelationRole(sourceClass.getName() + "." + arrayClass.getName());
                roleA.setAggregate(false);
                roleA.setCardinality(CardinalityEnum.valueOf((String)"_0_1"));
                roleA.setNavigable(true);
                roleA.setModelClass(sourceClass);
                roleB = modelRelation.createModelRelationRole(arrayClass.getName());
                roleB.setAggregate(false);
                roleB.setCardinality(CardinalityEnum.valueOf((String)"_0_1"));
                roleB.setNavigable(true);
                roleB.setModelClass(arrayClass);
                modelRelation = this.mModel.createModelRelation(relation.getRelationName());
                roleA = modelRelation.createModelRelationRole(arrayClass.getName() + "." + this.toHungarianNotation(property.getName()));
                roleA.setAggregate(true);
                roleA.setCardinality(CardinalityEnum.valueOf((String)"_0_1"));
                roleA.setNavigable(false);
                roleA.setModelClass(arrayClass);
                roleB = modelRelation.createModelRelationRole(relation.getTargetRole());
                roleB.setAggregate(false);
                roleB.setCardinality(CardinalityEnum.valueOf((String)"_0_n"));
                roleB.setNavigable(true);
                roleB.setModelClass(targetClass);
            }
            catch (CreateException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    private String toHungarianNotation(String name) {
        if (name != null) {
            if ((name = name.trim()).length() > 1) {
                char fChar = name.charAt(0);
                fChar = Character.toUpperCase(fChar);
                name = name.substring(1);
                name = fChar + name;
            } else {
                name = name.toUpperCase();
            }
        }
        return "";
    }

    private boolean isNavigable(JavaBeanModelClass sourceClass, JavaBeanModelClass targetClass, JavaBeanModelProperty property) {
        if (sourceClass != null && targetClass != null && property != null) {
            Class sourceType = sourceClass.getTypeClass();
            Class targetType = targetClass.getTypeClass();
            String propName = sourceClass.getName();
            if (propName != null) {
                String methodName = "get" + propName;
                try {
                    Method method = targetType.getMethod(methodName, null);
                    Class<?> returnType = method.getReturnType();
                    if (method != null && returnType.toString().equals(sourceType.toString())) {
                        return true;
                    }
                }
                catch (SecurityException se) {
                    System.out.println(se.getMessage());
                }
                catch (NoSuchMethodException nsme) {
                    System.out.println(nsme.getMessage());
                }
            }
        }
        return false;
    }

    private boolean isRelationCreated(JavaBeanModelRelation relation) {
        boolean status = false;
        if (this.mModel != null && relation != null && relation.getProperty().isRelation()) {
            String sourceClassName = relation.getSourceClass().getName();
            String targetClassName = relation.getTargetClass().getName();
            String sourceRoleName = relation.getSourceRole();
            String targetRoleName = relation.getTargetRole();
            ModelRelation[] modelRelations = this.mModel.getModelRelations();
            ModelRelationRole role = null;
            if (modelRelations != null) {
                int i = 0;
                while (i < modelRelations.length) {
                    if (modelRelations[i].hasModelRelationRole(targetRoleName) && (role = modelRelations[i].getModelRelationRole(targetRoleName)).getModelClass().getName().equals(targetClassName)) {
                        role.setNavigable(true);
                        status = true;
                    }
                    ++i;
                }
            }
        }
        return status;
    }

    public boolean getImportStatus(String modelPackageName, String modelName, SourcePathIdentifier sourcePathIdentifier) {
        if (this.mImportLog == null) {
            this.mImportLog = new ImportLog();
        }
        this.mImportLog.clear();
        String error = this.checkForDuplicates();
        if (error != null && !error.equals("")) {
            this.mImportLog.addErrorMessage("Following classes already exist as ModelClasses: \n" + error);
            this.mImportLog.addErrorMessage("Remove the duplicate classes before importing the model");
            return false;
        }
        this.mImportLog.addInfoMessage("Following is the status of the model being created.");
        this.mImportLog.addInfoMessage("    Name of the model: \"" + modelName + "\", package: " + modelPackageName);
        JavaBeanModelClass[] javaBeanClasses = this.mJavaBeanModelData.getModelClasses();
        Class typeClass = null;
        JavaBeanModelClass javaBeanClass = null;
        JavaBeanModelProperty[] modelProperties = null;
        Object modelProperty = null;
        Object typeName = null;
        int propCount = 0;
        if (javaBeanClasses != null) {
            int i = 0;
            while (i < javaBeanClasses.length) {
                propCount = 0;
                javaBeanClass = javaBeanClasses[i];
                typeClass = javaBeanClass.getTypeClass();
                this.mImportLog.addInfoMessage("        Adding modelclass: \"" + javaBeanClasses[i].getName() + "\", package: " + typeClass.getPackage());
                modelProperties = javaBeanClass.getProperties();
                this.mImportLog.addInfoMessage("            Properties for the modelclass: \"" + javaBeanClass.getName() + "\"");
                if (modelProperties != null) {
                    int j = 0;
                    while (j < modelProperties.length) {
                        if (modelProperties[j].isSelected() && !modelProperties[j].isCollection()) {
                            ++propCount;
                            this.mImportLog.addInfoMessage("                Adding property \"" + modelProperties[j].getName() + "\", type: " + modelProperties[j].getPropertyType().getName());
                        }
                        ++j;
                    }
                    int j2 = 0;
                    while (j2 < modelProperties.length) {
                        if (!modelProperties[j2].isSelected()) {
                            this.mImportLog.addInfoMessage("                Property \"" + modelProperties[j2].getName() + "\", type: " + modelProperties[j2].getPropertyType().getName() + ", is not selected");
                        }
                        ++j2;
                    }
                    if (propCount == 0) {
                        this.mImportLog.addInfoMessage("No properties added for this class\n");
                    }
                } else {
                    this.mImportLog.addInfoMessage("No properties added for this class\n");
                }
                ++i;
            }
            this.mImportLog.addInfoMessage("    Relations for the model: \"" + modelName + "\"");
            JavaBeanModelRelation[] relations = this.mJavaBeanModelData.getRelationsToResolve();
            JavaBeanModelRelation relation = null;
            String sourceClassName = null;
            String targetClassName = null;
            int warnCount = 0;
            int j = 0;
            while (j < relations.length) {
                relation = relations[j];
                if (relation.isSelected()) {
                    sourceClassName = relation.getSourceClass().getName();
                    this.mImportLog.addInfoMessage("    Inspecting relation \"" + relation.getRelationName() + "\" for source class \"" + sourceClassName + "\"");
                    if (relation.getTargetClass() == null) {
                        ++warnCount;
                        this.mImportLog.addWarningMessage("    This relation cannot be added as the TargetModelClass is not specified");
                    } else {
                        targetClassName = relation.getTargetClass().getName();
                        this.mImportLog.addInfoMessage("    adding relation \"" + relation.getRelationName() + "\"");
                        this.mImportLog.addInfoMessage("        Source Class: \"" + sourceClassName + "\"");
                        this.mImportLog.addInfoMessage("        Target Class: \"" + targetClassName + "\"");
                    }
                }
                ++j;
            }
            int j3 = 0;
            while (j3 < relations.length) {
                if (!relations[j3].isSelected()) {
                    this.mImportLog.addWarningMessage("    relation \"" + relations[j3].getRelationName() + " cannot" + " be added as this is not selected");
                }
                ++j3;
            }
            if (warnCount > 0) {
                this.mImportLog.addErrorMessage("There are one or more relations unresolved. Importing the model without resolvoing the relations might result in erratic output.");
                return false;
            }
        }
        return true;
    }

    public ImportLog getImportLog() {
        return this.mImportLog;
    }

    public void setImportLog(ImportLog log) {
        this.mImportLog = log;
    }

    private String checkForDuplicates() {
        JavaBeanModelClass[] beanClasses = this.mJavaBeanModelData.getModelClasses();
        Model[] models = null;
        Class typeClass = null;
        StringBuffer buffer = new StringBuffer();
        try {
            models = this.mWebDynproRoot.getModels();
        }
        catch (LoadException e) {
            e.printStackTrace();
            return "";
        }
        if (beanClasses != null && models != null) {
            int i = 0;
            while (i < beanClasses.length) {
                typeClass = beanClasses[i].getTypeClass();
                int j = 0;
                while (j < models.length) {
                    if (models[j].hasModelClass(typeClass.getPackage().getName(), beanClasses[i].getName())) {
                        buffer.append(typeClass.getName());
                        buffer.append("\n");
                    }
                    ++j;
                }
                ++i;
            }
        }
        return buffer.toString();
    }
}

