/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.javabean;

import com.sap.ide.metamodel.importers.javabean.JavaBeanAnalyser;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelClass;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelProperty;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelRelation;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.TypeInfo;

public class JavaBeanModelData {
    public static String MODEL_STATUS = "Status";
    public static String MODEL_RELATION_NAME = "Name";
    public static String MODEL_SOURCE_ROLE = "Source Role";
    public static String MODEL_TARGET_ROLE = "Target Role";
    public static String MODEL_MODEL_CLASS = "Model Class";
    public static int GET_MODEL_RELATION_DETAILS = 0;
    public static int GET_MORE_MODEL_RELATION_DETAILS = 1;
    public static int SOURCE_JAR_FILE = 2;
    public static int SOURCE_CLASS_FINDER = 3;
    public static int SOURCE_DC_PUBLIC_PART = 4;
    public static int DESIGN_TIME_DEPENDENCY = 5;
    public static int DEPLOY_TIME_DEPENDENCY = 6;
    public static int ONLY_SOURCE_FOLDERS = 7;
    public static int ASSOCIATED_PROJECTS_ASLO = 8;
    private String mModelName;
    private ArrayList mModelClasses;
    private ArrayList mJarClasses;
    private JavaBeanModelRelation[] mRelations;
    private String mJarPath;
    private int mPageStatus = GET_MODEL_RELATION_DETAILS;
    private int mJavaBeanSource = SOURCE_CLASS_FINDER;
    private int mJARDependency = DESIGN_TIME_DEPENDENCY;
    private boolean mAddHierarchy;
    private boolean mIsDCProject;
    private String[] mUsedPublicParts;
    private Map mUsedPPMap;
    private boolean mImportStatus;
    private boolean mNotifyHierarchyStatus;
    private IJavaSearchScope mJavaBeanSearchScope;
    private int mProjectSourceOption = ONLY_SOURCE_FOLDERS;
    private TypeInfo[] mOnlyProjectTypeInfo;
    private boolean mOnlyProjectTypeInfoInitialized;
    private TypeInfo[] mCompleteProjectTypeInfo;
    private boolean mCompleteProjectTypeInfoInitialized;

    public JavaBeanModelData(String modelName) {
        this.mModelName = modelName;
        this.mModelClasses = new ArrayList();
        this.mJarClasses = new ArrayList();
        this.mUsedPublicParts = new String[0];
        this.mUsedPPMap = new HashMap();
        this.mNotifyHierarchyStatus = true;
        this.mOnlyProjectTypeInfo = new TypeInfo[0];
        this.mCompleteProjectTypeInfo = new TypeInfo[0];
    }

    public void setModelName(String mName) {
        this.mModelName = mName;
    }

    public String getModelName() {
        if (this.mModelName != null) {
            return this.mModelName;
        }
        return "";
    }

    public void setModelClasses(JavaBeanModelClass[] classes) {
        if (classes != null) {
            this.mModelClasses = new ArrayList();
            int i = 0;
            while (i < classes.length) {
                this.mModelClasses.add(classes[i]);
                ++i;
            }
        }
    }

    public JavaBeanModelClass[] getModelClasses() {
        JavaBeanModelClass[] classes = new JavaBeanModelClass[]{};
        if (this.mModelClasses.size() > 0) {
            classes = new JavaBeanModelClass[this.mModelClasses.size()];
            classes = this.mModelClasses.toArray(classes);
        }
        return classes;
    }

    public void setJarClasses(ArrayList list) {
        if (list != null) {
            this.mJarClasses = list;
        }
    }

    public JavaBeanModelClass[] getJarClasses() {
        JavaBeanModelClass[] classes = new JavaBeanModelClass[]{};
        if (this.mJarClasses.size() > 0) {
            classes = new JavaBeanModelClass[this.mJarClasses.size()];
            classes = this.mJarClasses.toArray(classes);
        }
        return classes;
    }

    public int getJavaBeanSource() {
        return this.mJavaBeanSource;
    }

    public void setJavaBeanSource(int status) {
        this.mJavaBeanSource = status;
        this.mModelClasses = new ArrayList();
        this.mJarClasses = new ArrayList();
        if (this.mJavaBeanSource != SOURCE_JAR_FILE) {
            this.mJARDependency = -1;
        }
    }

    public int getJARDependency() {
        return this.mJARDependency;
    }

    public void setJARDependency(int type) {
        this.mJARDependency = type;
    }

    public boolean getAddHierarchy() {
        return this.mAddHierarchy;
    }

    public void setAddHierarchy(boolean status) {
        this.mAddHierarchy = status;
    }

    public String canChangeAddHierarchy() {
        String status = null;
        if (this.mModelClasses != null && this.mModelClasses.size() > 0) {
            status = "Few JavaBeans are already selected. This change in setting might lead to inconsistency of model import. Would you like to continue?";
        }
        return status;
    }

    public String getJarPath() {
        return this.mJarPath;
    }

    public void setJarPath(String path) {
        this.mJarPath = path;
    }

    public boolean getImportStatus() {
        return this.mImportStatus;
    }

    public void setImportStatus(boolean b) {
        this.mImportStatus = b;
    }

    public boolean getNotifyHierarchyStatus() {
        return this.mNotifyHierarchyStatus;
    }

    public void setNotifyHierarchyStatus(boolean b) {
        this.mNotifyHierarchyStatus = b;
    }

    public int getProjectSourceOption() {
        return this.mProjectSourceOption;
    }

    public void setProjectSourceOption(int option) {
        this.mProjectSourceOption = option;
    }

    public String[] getUsedPublicParts() {
        return this.mUsedPublicParts;
    }

    public String selectUsedPublicPart(String name) {
        String path = null;
        if (name != null) {
            if (this.mUsedPPMap.containsKey(name)) {
                path = (String)this.mUsedPPMap.get(name);
            }
            if (path != null) {
                this.mJarPath = path;
            }
        }
        return path;
    }

    public boolean isDCProject() {
        return this.mIsDCProject;
    }

    public void isDCProject(boolean status) {
        this.mIsDCProject = status;
    }

    public IJavaSearchScope getProjectSearchScope(WebDynproRoot webDynproRoot) {
        IJavaSearchScope javaSearchScope = null;
        IJavaProject iProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(webDynproRoot.getMetamodel().getName()));
        IJavaElement[] elements = new IJavaElement[]{iProject};
        if (this.mProjectSourceOption == ASSOCIATED_PROJECTS_ASLO) {
            javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        } else {
            ArrayList<IPackageFragmentRoot> elementsList = new ArrayList<IPackageFragmentRoot>();
            try {
                IClasspathEntry[] classpathEntries = iProject.getRawClasspath();
                if (classpathEntries != null) {
                    int i = 0;
                    while (i < classpathEntries.length) {
                        if (classpathEntries[i].getEntryKind() == 3) {
                            elementsList.add(iProject.findPackageFragmentRoot(classpathEntries[i].getPath()));
                        }
                        ++i;
                    }
                    if (elementsList.size() > 0) {
                        elements = new IJavaElement[elementsList.size()];
                        elements = elementsList.toArray(elements);
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        }
        return javaSearchScope;
    }

    public IJavaSearchScope getProjectSearchScope(WebDynproRoot webDynproRoot, int option) {
        IJavaSearchScope javaSearchScope = null;
        IJavaProject iProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(webDynproRoot.getMetamodel().getName()));
        IJavaElement[] elements = new IJavaElement[]{iProject};
        if (option == ASSOCIATED_PROJECTS_ASLO) {
            javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        } else {
            ArrayList<IPackageFragmentRoot> elementsList = new ArrayList<IPackageFragmentRoot>();
            try {
                IClasspathEntry[] classpathEntries = iProject.getRawClasspath();
                if (classpathEntries != null) {
                    IFolder parentFolder = null;
                    int i = 0;
                    while (i < classpathEntries.length) {
                        if (classpathEntries[i].getEntryKind() == 3 && (parentFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(classpathEntries[i].getPath())) != null && parentFolder.getParent() != null && !parentFolder.getParent().isDerived()) {
                            elementsList.add(iProject.findPackageFragmentRoot(classpathEntries[i].getPath()));
                        }
                        ++i;
                    }
                    if (elementsList.size() > 0) {
                        elements = new IJavaElement[elementsList.size()];
                        elements = elementsList.toArray(elements);
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        }
        return javaSearchScope;
    }

    public void setOnlyProjectTypeInfo(TypeInfo[] typeInfo) {
        this.mOnlyProjectTypeInfo = typeInfo;
    }

    public TypeInfo[] getOnlyProjectTypeInfo() {
        return this.mOnlyProjectTypeInfo;
    }

    public void setOnlyProjectTypeInfoInitialized(boolean status) {
        this.mOnlyProjectTypeInfoInitialized = status;
    }

    public boolean isOnlyProjectTypeInfoInitialized() {
        return this.mOnlyProjectTypeInfoInitialized;
    }

    public void setCompleteProjectTypeInfo(TypeInfo[] typeInfo) {
        this.mCompleteProjectTypeInfo = typeInfo;
    }

    public TypeInfo[] getCompleteProjectTypeInfo() {
        return this.mCompleteProjectTypeInfo;
    }

    public void setCompleteProjectTypeInfoInitialized(boolean status) {
        this.mCompleteProjectTypeInfoInitialized = status;
    }

    public boolean isCompleteProjectTypeInfoInitialized() {
        return this.mCompleteProjectTypeInfoInitialized;
    }

    public void addModelClass(JavaBeanModelClass modelClass) {
        if (this.mModelClasses != null) {
            if (!this.mModelClasses.contains(modelClass) && this.getModelClass(modelClass.getName()) == null) {
                this.mModelClasses.add(modelClass);
            }
        } else {
            this.mModelClasses = new ArrayList();
            this.mModelClasses.add(modelClass);
        }
    }

    public void removeModelClass(JavaBeanModelClass modelClass) {
        if (this.mModelClasses != null) {
            ((AbstractCollection)this.mModelClasses).remove(modelClass);
        }
    }

    public void removeModelClass(Class iType) {
        if (this.mModelClasses != null) {
            Iterator it = ((AbstractList)this.mModelClasses).iterator();
            JavaBeanModelClass element = null;
            while (it.hasNext()) {
                element = (JavaBeanModelClass)it.next();
                if (!iType.equals(element.getTypeClass())) continue;
                ((AbstractCollection)this.mModelClasses).remove(element);
                break;
            }
        }
    }

    public void removeAllModelClasses() {
        this.mModelClasses = new ArrayList();
    }

    public void addJarClass(JavaBeanModelClass modelClass) {
        if (this.mJarClasses != null) {
            if (!this.mJarClasses.contains(modelClass)) {
                this.mJarClasses.add(modelClass);
            }
        } else {
            this.mJarClasses = new ArrayList();
            this.mJarClasses.add(modelClass);
        }
    }

    public void removeJarClass(JavaBeanModelClass modelClass) {
        if (this.mJarClasses != null && this.mJarClasses.contains(modelClass)) {
            ((AbstractCollection)this.mJarClasses).remove(modelClass);
        }
    }

    public void removeAllJarClasses() {
        this.mJarClasses = new ArrayList();
    }

    public JavaBeanModelClass getModelClass(String typeName) {
        if (this.mModelClasses != null && typeName != null) {
            Iterator it = ((AbstractList)this.mModelClasses).iterator();
            JavaBeanModelClass element = null;
            while (it.hasNext()) {
                element = (JavaBeanModelClass)it.next();
                if (!typeName.equals(element.getName())) continue;
                return element;
            }
        }
        return null;
    }

    public JavaBeanModelClass getJarBeanClass(Class typeClass) {
        if (this.mJarClasses != null && typeClass != null) {
            Iterator it = ((AbstractList)this.mJarClasses).iterator();
            JavaBeanModelClass element = null;
            while (it.hasNext()) {
                element = (JavaBeanModelClass)it.next();
                if (element.getTypeClass() == null || !element.getTypeClass().getName().equals(typeClass.getName())) continue;
                return element;
            }
        }
        return null;
    }

    public JavaBeanModelClass getModelClass(Class typeClass) {
        if (this.mModelClasses != null && typeClass != null) {
            Iterator it = ((AbstractList)this.mModelClasses).iterator();
            JavaBeanModelClass element = null;
            while (it.hasNext()) {
                element = (JavaBeanModelClass)it.next();
                if (element.getTypeClass() == null || !element.getTypeClass().getName().equals(typeClass.getName())) continue;
                return element;
            }
        }
        return null;
    }

    public boolean needToResolveRelations() {
        if (this.mModelClasses != null) {
            Iterator it = ((AbstractList)this.mModelClasses).iterator();
            JavaBeanModelClass element = null;
            while (it.hasNext()) {
                element = (JavaBeanModelClass)it.next();
                if (!element.needToResolveRelations()) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getModelClassNames() {
        String[] names = new String[]{};
        if (this.mModelClasses != null) {
            names = new String[this.mModelClasses.size()];
            Iterator it = ((AbstractList)this.mModelClasses).iterator();
            JavaBeanModelClass element = null;
            int count = 0;
            while (it.hasNext()) {
                element = (JavaBeanModelClass)it.next();
                names[count++] = element.getName();
            }
        }
        return names;
    }

    public String[] getTargetModelClassNames(String name) {
        String[] names = new String[]{};
        if (this.mModelClasses != null && name != null) {
            names = new String[this.mModelClasses.size() + 1];
            names[0] = "None";
            Iterator it = ((AbstractList)this.mModelClasses).iterator();
            JavaBeanModelClass element = null;
            int count = 1;
            String typeName = null;
            while (it.hasNext()) {
                element = (JavaBeanModelClass)it.next();
                typeName = element.getName();
                names[count++] = typeName;
            }
        }
        return names;
    }

    public JavaBeanModelRelation[] getRelationsToResolve() {
        if (this.mRelations != null) {
            return this.mRelations;
        }
        return new JavaBeanModelRelation[0];
    }

    public void initializeRelationsToResolve() {
        if (this.mModelClasses != null) {
            ArrayList<JavaBeanModelRelation> relationList = new ArrayList<JavaBeanModelRelation>();
            Iterator it = ((AbstractList)this.mModelClasses).iterator();
            JavaBeanModelClass modelClass = null;
            Object relation = null;
            Object fieldsToResolve = null;
            JavaBeanModelRelation[] relations = null;
            String[] names = null;
            while (it.hasNext()) {
                modelClass = (JavaBeanModelClass)it.next();
                names = this.getTargetModelClassNames(modelClass.getName());
                relations = modelClass.getRelations();
                if (relations == null) continue;
                int i = 0;
                while (i < relations.length) {
                    relations[i].setModelClassNames(names);
                    relationList.add(relations[i]);
                    ++i;
                }
            }
            if (relationList.size() > 0) {
                this.mRelations = new JavaBeanModelRelation[relationList.size()];
                this.mRelations = relationList.toArray(this.mRelations);
            } else {
                this.mRelations = new JavaBeanModelRelation[0];
            }
        }
    }

    public void updateModelRelations() {
        if (this.mRelations != null) {
            JavaBeanModelRelation relation = null;
            JavaBeanModelClass targetClass = null;
            int i = 0;
            while (i < this.mRelations.length) {
                if (this.mRelations[i].isSelected() && (targetClass = this.getModelClass((relation = this.mRelations[i]).getModelClassName())) != null) {
                    relation.setTargetClass(targetClass);
                    if (relation.getProperty() != null && relation.getProperty().isCollection()) {
                        relation.setSourceAggregation(true);
                        relation.setTargetCardinality(CardinalityEnum.valueOf((String)"_0_n"));
                    }
                }
                ++i;
            }
            this.identifiedRelationsForModel();
        }
    }

    private void identifiedRelationsForModel() {
        if (this.mRelations != null) {
            HashMap<JavaBeanModelClass, ArrayList<JavaBeanModelRelation>> sourceClassMap = new HashMap<JavaBeanModelClass, ArrayList<JavaBeanModelRelation>>();
            ArrayList<JavaBeanModelRelation> relationList = new ArrayList<JavaBeanModelRelation>();
            JavaBeanModelClass sourceClass = null;
            JavaBeanModelClass targetClass = null;
            JavaBeanModelRelation relation = null;
            Iterator<Object> it = null;
            int i = 0;
            while (i < this.mRelations.length) {
                if (this.mRelations[i].isSelected()) {
                    boolean added;
                    sourceClass = this.mRelations[i].getSourceClass();
                    targetClass = this.mRelations[i].getTargetClass();
                    if (sourceClassMap.containsKey(sourceClass)) {
                        relationList = (ArrayList<JavaBeanModelRelation>)sourceClassMap.get(sourceClass);
                        if (relationList == null) {
                            relationList = new ArrayList<JavaBeanModelRelation>();
                        }
                        added = false;
                        if (sourceClassMap.containsKey(targetClass) && (relationList = (ArrayList<JavaBeanModelRelation>)sourceClassMap.get(targetClass)) != null) {
                            it = ((AbstractList)relationList).iterator();
                            while (it.hasNext()) {
                                relation = (JavaBeanModelRelation)it.next();
                                if (!relation.getTargetClass().equals(sourceClass)) continue;
                                relation.setSourceRole(this.mRelations[i].getTargetRole());
                                relation.setNavigable(true);
                                if (this.mRelations[i].getProperty() != null && this.mRelations[i].getProperty().isCollection()) {
                                    relation.setTargetAggregation(true);
                                    relation.setSourceCardinality(CardinalityEnum.valueOf((String)"_0_n"));
                                }
                                added = true;
                                break;
                            }
                        }
                        if (!added) {
                            relationList.add(this.mRelations[i]);
                        }
                    } else if (sourceClassMap.containsKey(targetClass)) {
                        relationList = (ArrayList<JavaBeanModelRelation>)sourceClassMap.get(targetClass);
                        if (relationList == null) {
                            relationList = new ArrayList();
                            relationList.add(this.mRelations[i]);
                        } else {
                            added = false;
                            it = ((AbstractList)relationList).iterator();
                            while (it.hasNext()) {
                                relation = (JavaBeanModelRelation)it.next();
                                if (!relation.getTargetClass().equals(sourceClass)) continue;
                                relation.setSourceRole(this.mRelations[i].getTargetRole());
                                relation.setNavigable(true);
                                if (this.mRelations[i].getProperty() != null && this.mRelations[i].getProperty().isCollection()) {
                                    relation.setTargetAggregation(true);
                                    relation.setSourceCardinality(CardinalityEnum.valueOf((String)"_0_n"));
                                }
                                added = true;
                                break;
                            }
                            if (!added) {
                                relationList = new ArrayList<JavaBeanModelRelation>();
                                relationList.add(this.mRelations[i]);
                                sourceClassMap.put(sourceClass, relationList);
                            }
                        }
                    } else {
                        relationList = new ArrayList<JavaBeanModelRelation>();
                        relationList.add(this.mRelations[i]);
                        sourceClassMap.put(sourceClass, relationList);
                    }
                }
                ++i;
            }
            relationList = new ArrayList();
            Set keys = sourceClassMap.keySet();
            it = keys.iterator();
            ArrayList relList = null;
            while (it.hasNext()) {
                sourceClass = (JavaBeanModelClass)it.next();
                relList = (ArrayList)sourceClassMap.get(sourceClass);
                if (relList == null) continue;
                Iterator iter = ((AbstractList)relList).iterator();
                while (iter.hasNext()) {
                    relationList.add((JavaBeanModelRelation)iter.next());
                }
            }
            if (relationList.size() > 0) {
                this.mRelations = new JavaBeanModelRelation[relationList.size()];
                this.mRelations = relationList.toArray(this.mRelations);
            }
        }
    }

    public String[] getTableHeaders(int status) {
        if (status == GET_MODEL_RELATION_DETAILS) {
            String[] headers = new String[]{MODEL_STATUS, MODEL_RELATION_NAME, MODEL_TARGET_ROLE, MODEL_MODEL_CLASS};
            return headers;
        }
        if (status == GET_MORE_MODEL_RELATION_DETAILS) {
            String[] headers = new String[]{MODEL_STATUS, MODEL_STATUS, MODEL_RELATION_NAME, MODEL_TARGET_ROLE, MODEL_MODEL_CLASS};
            return headers;
        }
        return new String[0];
    }

    public JavaBeanModelRelation[] getRelations(JavaBeanModelClass modelClass) {
        JavaBeanModelRelation[] relations = new JavaBeanModelRelation[]{};
        if (modelClass != null && this.mRelations != null) {
            ArrayList<JavaBeanModelRelation> list = new ArrayList<JavaBeanModelRelation>();
            int i = 0;
            while (i < this.mRelations.length) {
                if (this.mRelations[i].getParent().equals(modelClass)) {
                    list.add(this.mRelations[i]);
                }
                ++i;
            }
            if (list.size() > 0) {
                relations = new JavaBeanModelRelation[list.size()];
                relations = list.toArray(relations);
            }
        }
        return relations;
    }

    public JavaBeanModelClass[] getModelClassesForRelationResolution() {
        JavaBeanModelClass[] modelClasses = new JavaBeanModelClass[]{};
        ArrayList<JavaBeanModelClass> classList = new ArrayList<JavaBeanModelClass>();
        JavaBeanModelClass[] allModelClasses = this.getModelClasses();
        if (allModelClasses != null) {
            int i = 0;
            while (i < allModelClasses.length) {
                if (allModelClasses[i].getRelations() != null && allModelClasses[i].getRelations().length > 0) {
                    classList.add(allModelClasses[i]);
                }
                ++i;
            }
        }
        if (classList.size() > 0) {
            modelClasses = new JavaBeanModelClass[classList.size()];
            modelClasses = classList.toArray(modelClasses);
        }
        return modelClasses;
    }

    public String areRelationResolutionsValid() {
        if (this.mRelations != null) {
            int i = 0;
            while (i < this.mRelations.length) {
                if (this.mRelations[i].isSelected() && !this.mRelations[i].isValid()) {
                    String errMsg = "Invalid Target Class for relation " + this.mRelations[i].getRelationName();
                    return errMsg;
                }
                ++i;
            }
        }
        return null;
    }

    public void identifyTargetClasses(JavaBeanModelClass sourceClass) {
        JavaBeanModelRelation[] relations;
        if (sourceClass != null && (relations = sourceClass.getRelations()) != null) {
            JavaBeanModelClass targetClass = null;
            JavaBeanModelProperty property = null;
            int i = 0;
            while (i < relations.length) {
                property = relations[i].getProperty();
                if (property.isRelation() && !relations[i].isResolved()) {
                    targetClass = this.getModelClass(property.getPropertyClassSimpleName());
                    relations[i].setTargetClass(targetClass);
                    if (targetClass != null) {
                        relations[i].setModelClassName(targetClass.getName());
                        relations[i].setResolved(true);
                        sourceClass.updateNeedToResolve();
                    } else {
                        relations[i].setModelClassName(null);
                        relations[i].setResolved(false);
                    }
                }
                ++i;
            }
        }
    }

    public void initializeDCPublicParts(IProject project) {
        if (project != null) {
            this.mIsDCProject = true;
            if (this.mUsedPPMap == null) {
                this.mUsedPPMap = new HashMap();
            }
            this.mUsedPPMap.clear();
            this.mUsedPublicParts = new String[0];
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                try {
                    IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
                    if (classpathEntries != null) {
                        ArrayList<String> jarList = new ArrayList<String>();
                        jarList.add("");
                        String PPname = null;
                        String PPPath = null;
                        int i = 0;
                        while (i < classpathEntries.length) {
                            if (classpathEntries[i].getEntryKind() == 1) {
                                PPname = classpathEntries[i].getPath().toFile().getName();
                                PPPath = classpathEntries[i].getPath().toOSString();
                                jarList.add(PPname);
                                this.mUsedPPMap.put(PPname, PPPath);
                            }
                            ++i;
                        }
                        this.mUsedPublicParts = new String[jarList.size()];
                        this.mUsedPublicParts = jarList.toArray(this.mUsedPublicParts);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void initializeJavaBeanSource(WebDynproRoot webDynproRoot) throws Exception {
        if (this.mJavaBeanSource == SOURCE_DC_PUBLIC_PART || this.mJavaBeanSource == SOURCE_JAR_FILE) {
            ArrayList otherClasses;
            this.mModelClasses.clear();
            this.mJarClasses.clear();
            if (this.mJarPath == null) {
                throw new Exception("Invalid Jar");
            }
            JavaBeanModelClass[] classes = JavaBeanAnalyser.initializeBeansFromJar(webDynproRoot, this.mJarPath);
            if (classes != null) {
                this.mModelClasses = new ArrayList();
                int i = 0;
                while (i < classes.length) {
                    this.mModelClasses.add(classes[i]);
                    ++i;
                }
            }
            if ((otherClasses = JavaBeanAnalyser.identifyClassesForJar(webDynproRoot, this.mJarPath)) != null) {
                classes = new JavaBeanModelClass[otherClasses.size()];
                classes = otherClasses.toArray(classes);
                this.mJarClasses = new ArrayList();
                int i = 0;
                while (i < classes.length) {
                    this.mJarClasses.add(classes[i]);
                    ++i;
                }
            }
            if (!(classes != null && classes.length != 0 || otherClasses != null && otherClasses.size() != 0)) {
                throw new Exception("Invalid Jar - No JavaBeans available for import");
            }
        }
    }
}

