/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.javabean;

import com.sap.ide.metamodel.importers.javabean.JavaBeanModelProperty;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class JavaBeanModelClass {
    private Class mTypeClass;
    private String mClassName;
    private JavaBeanModelProperty[] mProperties;
    private JavaBeanModelRelation[] mRelations;
    private boolean mNeedToResolveRelations;
    private boolean mIsExisting;

    public String getName() {
        return this.mClassName;
    }

    public void setTypeClass(Class typeClass) {
        this.mTypeClass = typeClass;
        if (this.mTypeClass != null) {
            this.mClassName = this.mTypeClass.getName();
            int index = -1;
            index = this.mClassName.lastIndexOf(46);
            if (index != -1) {
                this.mClassName = this.mClassName.substring(index + 1);
            }
            if (this.mClassName == null) {
                this.mClassName = "";
            }
        }
    }

    public Class getTypeClass() {
        return this.mTypeClass;
    }

    public void setProperties(JavaBeanModelProperty[] properties) {
        this.mProperties = properties;
    }

    public JavaBeanModelProperty[] getProperties() {
        if (this.mProperties == null) {
            return new JavaBeanModelProperty[0];
        }
        return this.mProperties;
    }

    public void setRelations(JavaBeanModelRelation[] relations) {
        this.mRelations = relations;
    }

    public JavaBeanModelRelation[] getRelations() {
        if (this.mRelations == null) {
            this.mRelations = new JavaBeanModelRelation[0];
        }
        return this.mRelations;
    }

    public boolean isModelClassExisting() {
        return this.mIsExisting;
    }

    public void setModelClassExisting(boolean exists) {
        this.mIsExisting = exists;
    }

    public boolean needToResolveRelations() {
        return this.mNeedToResolveRelations;
    }

    public void setNeedToResolveRelations(boolean status) {
        this.mNeedToResolveRelations = status;
    }

    public void addProperty(JavaBeanModelProperty property) {
        if (property == null) {
            return;
        }
        if (this.mProperties == null) {
            this.mProperties = new JavaBeanModelProperty[1];
            this.mProperties[0] = property;
        } else {
            List<JavaBeanModelProperty> list = Arrays.asList(this.mProperties);
            ArrayList<JavaBeanModelProperty> newList = new ArrayList<JavaBeanModelProperty>();
            newList.add(property);
            JavaBeanModelProperty prop = null;
            Iterator<JavaBeanModelProperty> it = list.iterator();
            while (it.hasNext()) {
                prop = it.next();
                if (prop.getName().equals(property.getName())) continue;
                newList.add(prop);
            }
            this.mProperties = new JavaBeanModelProperty[newList.size()];
            this.mProperties = newList.toArray(this.mProperties);
        }
    }

    public void removeProperty(JavaBeanModelProperty property) {
        if (this.mProperties == null || property == null) {
            return;
        }
        ArrayList<JavaBeanModelProperty> newList = new ArrayList<JavaBeanModelProperty>();
        int i = 0;
        while (i < this.mProperties.length) {
            if (!this.mProperties[i].getName().equals(property.getName())) {
                newList.add(this.mProperties[i]);
            }
            ++i;
        }
        this.mProperties = new JavaBeanModelProperty[newList.size()];
        this.mProperties = newList.toArray(this.mProperties);
    }

    public void addRelation(JavaBeanModelRelation relation) {
        if (relation == null) {
            return;
        }
        if (this.mRelations == null) {
            this.mRelations = new JavaBeanModelRelation[1];
            this.mRelations[0] = relation;
        } else {
            List<JavaBeanModelRelation> list = Arrays.asList(this.mRelations);
            ArrayList<JavaBeanModelRelation> newList = new ArrayList<JavaBeanModelRelation>();
            newList.add(relation);
            JavaBeanModelRelation reln = null;
            Iterator<JavaBeanModelRelation> it = list.iterator();
            while (it.hasNext()) {
                reln = it.next();
                if (reln.getRelationName().equals(relation.getRelationName())) continue;
                newList.add(reln);
            }
            this.mRelations = new JavaBeanModelRelation[newList.size()];
            this.mRelations = newList.toArray(this.mRelations);
        }
        this.updateNeedToResolve();
    }

    public void removeRelation(JavaBeanModelRelation relation) {
        if (this.mRelations == null || relation == null) {
            return;
        }
        ArrayList<JavaBeanModelRelation> newList = new ArrayList<JavaBeanModelRelation>();
        JavaBeanModelProperty rProperty = relation.getProperty();
        String rMethodSign = null;
        if (rProperty != null) {
            rMethodSign = rProperty.getMethodSignature();
        }
        JavaBeanModelProperty iProperty = null;
        String iMethodSign = null;
        int i = 0;
        while (i < this.mRelations.length) {
            iProperty = this.mRelations[i].getProperty();
            if (iProperty != null) {
                iMethodSign = iProperty.getMethodSignature();
            }
            if (rMethodSign == null || iMethodSign == null || !rMethodSign.equals(iMethodSign)) {
                newList.add(this.mRelations[i]);
            }
            ++i;
        }
        this.mRelations = new JavaBeanModelRelation[newList.size()];
        this.mRelations = newList.toArray(this.mRelations);
        this.updateNeedToResolve();
    }

    public void updateNeedToResolve() {
        if (this.mRelations != null) {
            this.mNeedToResolveRelations = false;
            int i = 0;
            while (i < this.mRelations.length) {
                if (this.mRelations[i].isSelected() && !this.mRelations[i].isResolved()) {
                    this.mNeedToResolveRelations = true;
                    break;
                }
                ++i;
            }
        }
    }
}

