/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.javabean;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelClass;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelProperty;
import com.sap.ide.metamodel.importers.javabean.JavaBeanModelRelation;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaBeanAnalyser {
    private static JavaBeanModelClass[] EMPTY_ARRAY = new JavaBeanModelClass[0];
    public static final String DICTIONARY_PACKAGE = "com.sap.dictionary";
    public static final String MODELTYPE_PACKAGE = "com.sap.ide.webdynpro.modeltypes";
    public static final String MODELTYPE_NAME = "JavaBean";
    public static final int READ_ONLY = 0;
    public static final int READ_WRITE = 1;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public static JavaBeanModelClass createJavaBeanModelClass(WebDynproRoot webDynproRoot, IType iType) throws Exception {
        JavaBeanModelClass modelClass = null;
        if (webDynproRoot != null && iType != null) {
            modelClass = new JavaBeanModelClass();
            Model[] models = webDynproRoot.getModels();
            int i = 0;
            while (i < models.length) {
                if (models[i].hasModelClass(iType.getPackageFragment().getElementName(), iType.getElementName())) {
                    throw new Exception("Invalid Class - " + iType.getFullyQualifiedName() + " as Model Class already exists");
                }
                ++i;
            }
            URL[] urls = null;
            URL url = null;
            IProject project = null;
            IPath outputPath = null;
            int count = -1;
            IPath fullPath = null;
            if (iType.getPath().getDevice() == null) {
                project = iType.getJavaProject().getProject();
                try {
                    outputPath = iType.getJavaProject().getOutputLocation();
                }
                catch (JavaModelException jme) {
                    System.out.println(jme.getMessage());
                    throw new Exception("Invalid Class - JavaBean not available for import");
                }
                count = outputPath.matchingFirstSegments(iType.getJavaProject().getPath());
                outputPath = outputPath.removeFirstSegments(count);
                fullPath = project.getLocation().append(outputPath);
                try {
                    url = fullPath.toFile().toURL();
                    urls = JavaBeanAnalyser.getURLs(iType.getJavaProject(), url);
                }
                catch (MalformedURLException mue) {
                    System.out.println(mue.getMessage());
                    throw new Exception("Invalid Class - JavaBean not available for import");
                }
            }
            try {
                url = new URL("file:/" + iType.getPath().toString());
                urls = JavaBeanAnalyser.getURLs(iType.getJavaProject(), url);
            }
            catch (MalformedURLException mue) {
                System.out.println(mue.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
            Class beanClass = JavaBeanAnalyser.getClass(iType.getFullyQualifiedName(), urls);
            modelClass.setTypeClass(beanClass);
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(beanClass, 3);
            }
            catch (NoClassDefFoundError error) {
                System.out.println(error.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
            catch (IntrospectionException e) {
                System.out.println(e.getMessage());
                throw new Exception("Invalid Class - JavaBean behaviour is not known");
            }
            JavaBeanAnalyser.initializeBeanInfo(webDynproRoot, modelClass, beanInfo);
        }
        return modelClass;
    }

    public static JavaBeanModelClass[] initializeJBModelClasses(WebDynproRoot webDynproRoot, IType iType) throws Exception {
        JavaBeanModelClass[] beanClasses = EMPTY_ARRAY;
        if (webDynproRoot != null && iType != null) {
            Model[] models = webDynproRoot.getModels();
            int i = 0;
            while (i < models.length) {
                if (models[i].hasModelClass(iType.getPackageFragment().getElementName(), iType.getElementName())) {
                    throw new Exception("Invalid Class - " + iType.getFullyQualifiedName() + " as Model Class already exists");
                }
                ++i;
            }
            URL[] urls = null;
            URL url = null;
            IProject project = null;
            IPath outputPath = null;
            int count = -1;
            IPath fullPath = null;
            if (iType.getPath().getDevice() == null) {
                project = iType.getJavaProject().getProject();
                try {
                    outputPath = iType.getJavaProject().getOutputLocation();
                }
                catch (JavaModelException jme) {
                    System.out.println(jme.getMessage());
                    throw new Exception("Invalid Class - JavaBean not available for import");
                }
                count = outputPath.matchingFirstSegments(iType.getJavaProject().getPath());
                outputPath = outputPath.removeFirstSegments(count);
                fullPath = project.getLocation().append(outputPath);
                try {
                    url = fullPath.toFile().toURL();
                    urls = JavaBeanAnalyser.getURLs(iType.getJavaProject(), url);
                }
                catch (MalformedURLException mue) {
                    System.out.println(mue.getMessage());
                    throw new Exception("Invalid Class - JavaBean not available for import");
                }
            }
            try {
                url = new URL("file:/" + iType.getPath().toString());
                urls = JavaBeanAnalyser.getURLs(iType.getJavaProject(), url);
            }
            catch (MalformedURLException mue) {
                System.out.println(mue.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
            Class typeClass = JavaBeanAnalyser.getClass(iType.getFullyQualifiedName(), urls);
            Class[] classHierarchy = JavaBeanAnalyser.openHierarchy(typeClass);
            Object oModelClass = null;
            beanClasses = new JavaBeanModelClass[classHierarchy.length];
            BeanInfo beanInfo = null;
            int i2 = 0;
            while (i2 < classHierarchy.length) {
                beanClasses[i2] = new JavaBeanModelClass();
                beanClasses[i2].setTypeClass(classHierarchy[i2]);
                try {
                    beanInfo = Introspector.getBeanInfo(classHierarchy[i2], 3);
                }
                catch (NoClassDefFoundError error) {
                    System.out.println(error.getMessage());
                    throw new Exception("Invalid Class - JavaBean not available for import");
                }
                catch (IntrospectionException e) {
                    System.out.println(e.getMessage());
                    throw new Exception("Invalid Class - JavaBean behaviour is not known");
                }
                JavaBeanAnalyser.initializeBeanInfo(webDynproRoot, beanClasses[i2], beanInfo);
                ++i2;
            }
            JavaBeanAnalyser.eliminateDuplicates(beanClasses);
        }
        return beanClasses;
    }

    public static JavaBeanModelClass createJavaBeanModelClass(WebDynproRoot webDynproRoot, Class beanClass) throws Exception {
        JavaBeanModelClass modelClass = null;
        if (webDynproRoot != null && beanClass != null) {
            modelClass = new JavaBeanModelClass();
            modelClass.setTypeClass(beanClass);
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(beanClass, 3);
            }
            catch (NoClassDefFoundError error) {
                System.out.println(error.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
            catch (IntrospectionException e) {
                System.out.println(e.getMessage());
                throw new Exception("Invalid Class - JavaBean behaviour is not known");
            }
            JavaBeanAnalyser.initializeBeanInfo(webDynproRoot, modelClass, beanInfo);
        }
        return modelClass;
    }

    public static JavaBeanModelClass[] initializeJBModelClasses(WebDynproRoot webDynproRoot, Class beanClass) throws Exception {
        JavaBeanModelClass[] beanClasses = EMPTY_ARRAY;
        if (webDynproRoot != null && beanClass != null) {
            Class[] classHierarchy = JavaBeanAnalyser.openHierarchy(beanClass);
            Object oModelClass = null;
            beanClasses = new JavaBeanModelClass[classHierarchy.length];
            BeanInfo beanInfo = null;
            int i = 0;
            while (i < classHierarchy.length) {
                beanClasses[i] = new JavaBeanModelClass();
                beanClasses[i].setTypeClass(classHierarchy[i]);
                try {
                    beanInfo = Introspector.getBeanInfo(classHierarchy[i], 3);
                }
                catch (NoClassDefFoundError error) {
                    System.out.println(error.getMessage());
                    throw new Exception("Invalid Class - JavaBean not available for import");
                }
                catch (IntrospectionException e) {
                    System.out.println(e.getMessage());
                    throw new Exception("Invalid Class - JavaBean behaviour is not known");
                }
                JavaBeanAnalyser.initializeBeanInfo(webDynproRoot, beanClasses[i], beanInfo);
                JavaBeanAnalyser.eliminateDuplicates(beanClasses);
                ++i;
            }
        }
        return beanClasses;
    }

    public static Class[] openHierarchy(Class typeClass) {
        Class[] hierarchyClasses = new Class[]{};
        if (typeClass != null) {
            ArrayList<Class> classList = new ArrayList<Class>();
            JavaBeanAnalyser.getClassHierarchy(typeClass, classList);
            if (classList.size() == 0) {
                classList.add(typeClass);
            }
            int size = 0;
            size = classList.size();
            if (size > 0) {
                hierarchyClasses = new Class[size];
                hierarchyClasses = classList.toArray(hierarchyClasses);
            }
        }
        return hierarchyClasses;
    }

    private static ArrayList getClassHierarchy(Class derivedClass, ArrayList list) {
        Class<?>[] interfaces;
        if (derivedClass == null) {
            return list;
        }
        if (derivedClass.getName().startsWith("java")) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<Class>();
        }
        list.add(derivedClass);
        Class superClass = derivedClass.getSuperclass();
        if (superClass != null) {
            JavaBeanAnalyser.getClassHierarchy(superClass, list);
        }
        if ((interfaces = derivedClass.getInterfaces()) != null) {
            int i = 0;
            while (i < interfaces.length) {
                JavaBeanAnalyser.getClassHierarchy(interfaces[i], list);
                ++i;
            }
        }
        return list;
    }

    private static void eliminateDuplicates(JavaBeanModelClass[] classes) {
        if (classes != null) {
            JavaBeanModelClass modelClass = null;
            Class classObj = null;
            JavaBeanModelClass modelClass1 = null;
            Class classObj1 = null;
            int i = 0;
            while (i < classes.length) {
                modelClass = classes[i];
                classObj = modelClass.getTypeClass();
                int j = 0;
                while (j < classes.length) {
                    modelClass1 = classes[j];
                    classObj1 = modelClass1.getTypeClass();
                    if (!classObj.getName().equals(classObj1.getName()) && classObj.isAssignableFrom(classObj1)) {
                        JavaBeanAnalyser.eliminateDuplicates(modelClass, modelClass1);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void eliminateDuplicates(JavaBeanModelClass superClass, JavaBeanModelClass derivedClass) {
        if (superClass != null && derivedClass != null) {
            JavaBeanModelProperty[] sProperties = superClass.getProperties();
            JavaBeanModelRelation[] sRelations = superClass.getRelations();
            if (sProperties != null) {
                int i = 0;
                while (i < sProperties.length) {
                    derivedClass.removeProperty(sProperties[i]);
                    ++i;
                }
            }
            if (sRelations != null) {
                int i = 0;
                while (i < sRelations.length) {
                    derivedClass.removeRelation(sRelations[i]);
                    ++i;
                }
            }
        }
    }

    private static URL[] getURLs(IJavaProject project, String defaultPath) {
        URL[] urls = null;
        if (project != null && defaultPath != null) {
            IClasspathEntry[] entries = null;
            try {
                entries = project.getRawClasspath();
                String path = null;
                IClasspathEntry resolvedEntry = null;
                if (entries != null) {
                    urls = new URL[entries.length + 1];
                    urls[0] = new URL("file:/" + defaultPath);
                    int i = 0;
                    while (i < entries.length) {
                        resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entries[i]);
                        path = resolvedEntry.getPath().toString();
                        urls[i + 1] = new URL("file:/" + path);
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        return urls;
    }

    private static URL[] getURLs(IJavaProject project, URL defaultURL) {
        URL[] urls = null;
        if (project != null && defaultURL != null) {
            IClasspathEntry[] entries = null;
            try {
                entries = project.getRawClasspath();
                String path = null;
                IClasspathEntry resolvedEntry = null;
                if (entries != null) {
                    urls = new URL[entries.length + 1];
                    urls[0] = defaultURL;
                    int i = 0;
                    while (i < entries.length) {
                        resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entries[i]);
                        path = resolvedEntry.getPath().toString();
                        urls[i + 1] = new URL("file:/" + path);
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        return urls;
    }

    private static Class getClass(String jarName, String className, URL url) throws Exception {
        Class<?> beanClass = null;
        if (jarName != null && className != null) {
            Object urlPath = null;
            IPluginDescriptor descriptor = ServiceModelEditorPlugin.getDefault().getDescriptor();
            ClassLoader parentLoader = descriptor.getPluginClassLoader();
            URL[] urls = new URL[]{url};
            URLClassLoader classLoader = new URLClassLoader(urls, parentLoader);
            try {
                beanClass = classLoader.loadClass(className);
            }
            catch (NoClassDefFoundError error) {
                System.out.println(error.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println(cnfe.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
        }
        return beanClass;
    }

    private static Class getClass(String className, URL[] urls) throws Exception {
        Class<?> beanClass = null;
        if (className != null && urls != null) {
            Object urlPath = null;
            IPluginDescriptor descriptor = ServiceModelEditorPlugin.getDefault().getDescriptor();
            ClassLoader parentLoader = descriptor.getPluginClassLoader();
            URLClassLoader classLoader = new URLClassLoader(urls, parentLoader);
            try {
                beanClass = classLoader.loadClass(className);
            }
            catch (NoClassDefFoundError error) {
                System.out.println(error.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println(cnfe.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
        }
        return beanClass;
    }

    private static ClassLoader getClassLoader(URL[] urls) {
        URLClassLoader classLoader = null;
        if (urls != null) {
            IPluginDescriptor descriptor = ServiceModelEditorPlugin.getDefault().getDescriptor();
            ClassLoader parentLoader = descriptor.getPluginClassLoader();
            classLoader = new URLClassLoader(urls, parentLoader);
        }
        return classLoader;
    }

    private static void initializeBeanInfo(WebDynproRoot wRoot, JavaBeanModelClass modelClass, BeanInfo beanInfo) throws Exception {
        if (wRoot != null && modelClass != null && beanInfo != null) {
            ArrayList hierarchyList = JavaBeanAnalyser.getHierarchyInformation(modelClass.getTypeClass());
            ArrayList<JavaBeanModelProperty> propList = new ArrayList<JavaBeanModelProperty>();
            ArrayList<JavaBeanModelRelation> relationList = new ArrayList<JavaBeanModelRelation>();
            JavaBeanModelProperty property = null;
            JavaBeanModelRelation relation = null;
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            String propName = null;
            String methodSignature = null;
            if (descriptors != null) {
                int i = 0;
                while (i < descriptors.length) {
                    methodSignature = JavaBeanAnalyser.getMethodSignature(descriptors[i], true);
                    if (!(hierarchyList != null && hierarchyList.contains(methodSignature) || descriptors[i].getPropertyType() == null)) {
                        propName = descriptors[i].getName();
                        property = new JavaBeanModelProperty();
                        if (propName != null) {
                            property.setName(propName);
                            property.setPropertyClass(descriptors[i].getPropertyType());
                            if (descriptors[i].getWriteMethod() == null) {
                                property.setReadOnly(true);
                            }
                            if (!descriptors[i].getPropertyType().isArray()) {
                                if (JavaBeanAnalyser.isACollection(descriptors[i].getPropertyType())) {
                                    property.setCollection(true);
                                } else if (!JavaBeanAnalyser.isAProperty(property, wRoot)) {
                                    property.setRelation(true);
                                }
                                property.setMethodSignature(JavaBeanAnalyser.getMethodSignature(descriptors[i], property.isCollection() || property.isRelation()));
                                if (property.isCollection() || property.isRelation() || property.isArray()) {
                                    if (!JavaBeanAnalyser.isJavaType(descriptors[i].getPropertyType())) {
                                        relation = new JavaBeanModelRelation(modelClass, property);
                                        relation.setParent(modelClass);
                                        relationList.add(relation);
                                        modelClass.setNeedToResolveRelations(true);
                                    }
                                } else {
                                    propList.add(property);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            JavaBeanModelProperty[] properties = new JavaBeanModelProperty[propList.size()];
            properties = propList.toArray(properties);
            modelClass.setProperties(properties);
            if (relationList.size() > 0) {
                JavaBeanModelRelation[] relations = new JavaBeanModelRelation[relationList.size()];
                relations = relationList.toArray(relations);
                modelClass.setRelations(relations);
            }
        }
    }

    private static ArrayList getHierarchyInformation(Class typeClass) throws Exception {
        Class[] hierarchy;
        ArrayList<String> propList = new ArrayList<String>();
        if (typeClass != null && (hierarchy = JavaBeanAnalyser.openHierarchy(typeClass)) != null) {
            BeanInfo beanInfo = null;
            PropertyDescriptor[] descriptors = null;
            int i = 0;
            while (i < hierarchy.length) {
                if (hierarchy[i].isInterface() && !hierarchy[i].getName().equals(typeClass.getName()) && (descriptors = (beanInfo = Introspector.getBeanInfo(hierarchy[i], 3)).getPropertyDescriptors()) != null) {
                    int j = 0;
                    while (j < descriptors.length) {
                        propList.add(JavaBeanAnalyser.getMethodSignature(descriptors[j], true));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return propList;
    }

    public static JavaBeanModelClass[] initializeBeansFromJar(WebDynproRoot wRoot, String fileName) throws Exception {
        JavaBeanModelClass[] modelClasses = new JavaBeanModelClass[]{};
        if (wRoot != null && fileName != null) {
            Map<String, Attributes> map;
            IPluginDescriptor descriptor = ServiceModelEditorPlugin.getDefault().getDescriptor();
            ClassLoader parentLoader = ClassLoader.getSystemClassLoader();
            URL fileURL = null;
            URLClassLoader classLoader = null;
            URL url = null;
            JarURLConnection uConn = null;
            JarFile jarFile = null;
            URL[] urls = null;
            try {
                IJavaProject project = ServicesEclipse.getJavaProject((String)wRoot.getMetamodel().getName());
                fileURL = new URL("file:/" + fileName);
                urls = JavaBeanAnalyser.getURLs(project, fileName);
                classLoader = new URLClassLoader(urls, parentLoader);
                url = new URL("jar", "", urls[0] + "!/");
                uConn = (JarURLConnection)url.openConnection();
                jarFile = uConn.getJarFile();
            }
            catch (MalformedURLException mue) {
                System.out.println(mue.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
            Manifest manifest = null;
            try {
                manifest = jarFile.getManifest();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
            if (manifest != null && (map = manifest.getEntries()) != null) {
                Set<String> keys = map.keySet();
                Iterator<String> it = keys.iterator();
                String entryKey = null;
                Attributes value = null;
                String isJavaBean = null;
                String beanClassName = null;
                String className = null;
                Class<?> beanClass = null;
                BeanInfo beanInfo = null;
                JavaBeanModelClass modelClass = null;
                ArrayList<JavaBeanModelClass> beanList = new ArrayList<JavaBeanModelClass>();
                while (it.hasNext()) {
                    entryKey = it.next();
                    value = map.get(entryKey);
                    if (value == null || (isJavaBean = value.getValue("Java-Bean")) == null || !isJavaBean.equalsIgnoreCase("true") || (beanClassName = entryKey.substring(0, entryKey.lastIndexOf(46))) == null) continue;
                    try {
                        beanClassName = beanClassName.replace('/', '.');
                        beanClass = classLoader.loadClass(beanClassName);
                        if (beanClassName.indexOf(46) != -1) {
                            className = beanClassName.substring(beanClassName.lastIndexOf(46) + 1);
                        }
                        if (className == null) {
                            className = beanClassName;
                        }
                        beanInfo = Introspector.getBeanInfo(beanClass, 3);
                        modelClass = new JavaBeanModelClass();
                        modelClass.setTypeClass(beanClass);
                        try {
                            JavaBeanAnalyser.hasModelClass(wRoot, beanClass.getPackage().getName(), className);
                        }
                        catch (Exception e) {
                            modelClass.setModelClassExisting(true);
                        }
                        JavaBeanAnalyser.initializeBeanInfo(wRoot, modelClass, beanInfo);
                        beanList.add(modelClass);
                    }
                    catch (NoClassDefFoundError error) {
                        System.out.println(error.getMessage());
                        throw new Exception("Invalid Class - JavaBean not available for import");
                    }
                    catch (IntrospectionException ie) {
                        System.out.println(ie.getMessage());
                        throw new Exception("Invalid Class - JavaBean behaviour is not known");
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println(cnfe.getMessage());
                        throw new Exception("Invalid Class - JavaBean not available for import");
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                    }
                }
                if (beanList.size() > 0) {
                    modelClasses = new JavaBeanModelClass[beanList.size()];
                    modelClasses = beanList.toArray(modelClasses);
                }
            }
        }
        return modelClasses;
    }

    public static ArrayList identifyClassesForJar(WebDynproRoot wRoot, String fileName) throws Exception {
        ArrayList<JavaBeanModelClass> modelClassList = new ArrayList<JavaBeanModelClass>();
        if (fileName != null) {
            Map<String, Attributes> map;
            IPluginDescriptor descriptor = ServiceModelEditorPlugin.getDefault().getDescriptor();
            ClassLoader parentLoader = ClassLoader.getSystemClassLoader();
            URL fileURL = null;
            URLClassLoader classLoader = null;
            URL url = null;
            JarURLConnection uConn = null;
            JarFile jarFile = null;
            URL[] urls = null;
            try {
                IJavaProject project = ServicesEclipse.getJavaProject((String)wRoot.getMetamodel().getName());
                fileURL = new URL("file:/" + fileName);
                urls = JavaBeanAnalyser.getURLs(project, fileName);
                classLoader = new URLClassLoader(urls, parentLoader);
                url = new URL("jar", "", urls[0] + "!/");
                uConn = (JarURLConnection)url.openConnection();
                jarFile = uConn.getJarFile();
            }
            catch (MalformedURLException mue) {
                System.out.println(mue.getMessage());
                throw new Exception("Invalid Class - JavaBean not available for import");
            }
            Manifest manifest = null;
            try {
                manifest = jarFile.getManifest();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
            String beanClassName = null;
            String className = null;
            Class<?> beanClass = null;
            BeanInfo beanInfo = null;
            JavaBeanModelClass modelClass = null;
            ArrayList<String> beanList = new ArrayList<String>();
            if (manifest != null && (map = manifest.getEntries()) != null) {
                Set<String> keys = map.keySet();
                Iterator<String> it = keys.iterator();
                String entryKey = null;
                Attributes value = null;
                String isJavaBean = null;
                while (it.hasNext()) {
                    entryKey = it.next();
                    value = map.get(entryKey);
                    if (value == null || (isJavaBean = value.getValue("Java-Bean")) == null || !isJavaBean.equalsIgnoreCase("true") || (beanClassName = entryKey.substring(0, entryKey.lastIndexOf(46))) == null) continue;
                    beanClassName = beanClassName.replace('/', '.');
                    beanList.add(beanClassName);
                }
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            JarEntry jarEntry = null;
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                beanClassName = jarEntry.getName().trim();
                if (beanClassName.indexOf(36) != -1 || beanClassName == null || !beanClassName.endsWith(".class") || (beanClassName = beanClassName.substring(0, beanClassName.lastIndexOf(46))) == null) continue;
                if ((beanClassName = beanClassName.replace('/', '.')).indexOf(46) != -1) {
                    className = beanClassName.substring(beanClassName.lastIndexOf(46) + 1);
                }
                if (className == null) {
                    className = beanClassName;
                }
                if (beanList.contains(beanClassName)) continue;
                try {
                    beanClass = classLoader.loadClass(beanClassName);
                    beanInfo = Introspector.getBeanInfo(beanClass, 3);
                    modelClass = new JavaBeanModelClass();
                    modelClass.setTypeClass(beanClass);
                    try {
                        JavaBeanAnalyser.hasModelClass(wRoot, beanClass.getPackage().getName(), className);
                    }
                    catch (Exception e) {
                        modelClass.setModelClassExisting(true);
                    }
                    JavaBeanAnalyser.initializeBeanInfo(wRoot, modelClass, beanInfo);
                    modelClassList.add(modelClass);
                }
                catch (ClassNotFoundException cnfe) {
                    System.out.println(cnfe.getMessage());
                    throw new Exception("Invalid Class - JavaBean not available for import");
                }
                catch (NoClassDefFoundError error) {
                    System.out.println(error.getMessage());
                    throw new Exception("Invalid Class - JavaBean not available for import");
                }
                catch (IntrospectionException ie) {
                    System.out.println("Invalid Class - JavaBean behaviour is not known");
                    throw new Exception("Invalid Class - JavaBean behaviour is not known");
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
        return modelClassList;
    }

    private static void hasModelClass(WebDynproRoot webDynproRoot, String packageName, String className) throws Exception {
        Model[] models;
        if (webDynproRoot != null && packageName != null && className != null && (models = webDynproRoot.getModels()) != null) {
            int i = 0;
            while (i < models.length) {
                if (models[i].hasModelClass(packageName, className)) {
                    throw new Exception("Invalid Class - " + packageName + "." + className + " already exists as a ModelClass");
                }
                ++i;
            }
        }
    }

    private static boolean isACollection(Class field) {
        return field != null && ((class$java$util$Collection == null ? (class$java$util$Collection = JavaBeanAnalyser.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(field) || (class$java$util$Map == null ? (class$java$util$Map = JavaBeanAnalyser.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(field));
    }

    private static boolean isJavaType(Class field) {
        if (field != null) {
            if ((class$java$util$Collection == null ? (class$java$util$Collection = JavaBeanAnalyser.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(field) || (class$java$util$Map == null ? (class$java$util$Map = JavaBeanAnalyser.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(field)) {
                return false;
            }
            if (field.getName().startsWith("java")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAProperty(JavaBeanModelProperty property, WebDynproRoot webDynproRoot) {
        if (property != null && webDynproRoot != null) {
            String typeName = property.getPropertyClass().getName();
            if (typeName.equals("String") || typeName.equals("java.lang.String")) {
                typeName = "string";
            } else if (typeName.equals("Date") || typeName.equals("java.sql.Date") || typeName.equals("java.util.Date")) {
                typeName = "date";
            } else if (typeName.equals("double")) {
                typeName = "double";
            } else if (typeName.equals("Double") || typeName.equals("java.lang.Double")) {
                typeName = "doubleObject";
            } else if (typeName.equals("boolean")) {
                typeName = "boolean";
            } else if (typeName.equals("Boolean") || typeName.equals("java.lang.Boolean")) {
                typeName = "booleanObject";
            } else if (typeName.equals("Time") || typeName.equals("java.sql.Time")) {
                typeName = "time";
            } else if (typeName.equals("Timestamp") || typeName.equals("java.sql.Timestamp")) {
                typeName = "timestamp";
            } else if (typeName.equals("short")) {
                typeName = "short";
            } else if (typeName.equals("Short") || typeName.equals("java.lang.Short")) {
                typeName = "shortObject";
            } else if (typeName.equals("long")) {
                typeName = "long";
            } else if (typeName.equals("Long") || typeName.equals("java.lang.Long")) {
                typeName = "longObject";
            } else if (typeName.equals("float")) {
                typeName = "float";
            } else if (typeName.equals("Float") || typeName.equals("java.lang.Float")) {
                typeName = "floatObject";
            } else if (typeName.equals("int")) {
                typeName = "integer";
            } else if (typeName.equals("Integer") || typeName.equals("java.lang.Integer")) {
                typeName = "integerObject";
            } else if (typeName.equals("BigDecimal") || typeName.equals("java.math.BigDecimal")) {
                typeName = "decimal";
            } else if (typeName.equals("byte[]")) {
                typeName = "binary";
            }
            DtSimpleType devType = null;
            try {
                DtDictionaryRoot dicRoot = MetamodelServices.getDictionaryRoot((String)webDynproRoot.getMetamodel().getName());
                devType = dicRoot.getSimpleType(DICTIONARY_PACKAGE, typeName);
                property.setPropertyType((DevelopmentObject)devType);
            }
            catch (LoadException e) {
                System.out.println(e.getMessage());
            }
            return devType != null;
        }
        return true;
    }

    private static String getMethodSignature(PropertyDescriptor descriptor, boolean isRelation) {
        StringBuffer signature = new StringBuffer();
        Method method = null;
        if (descriptor != null) {
            if (isRelation) {
                if (descriptor.getReadMethod() != null) {
                    signature.append("Relation: ");
                    method = descriptor.getReadMethod();
                    signature.append(method.getReturnType().getName() + " ");
                    signature.append(method.getName() + "()");
                } else if (descriptor.getWriteMethod() != null) {
                    signature.append("Relation: ");
                    method = descriptor.getWriteMethod();
                    signature.append(method.getReturnType().getName() + " ");
                    signature.append(method.getName() + "()");
                }
            } else if (descriptor.getWriteMethod() == null) {
                signature.append("Read-only: ");
                method = descriptor.getReadMethod();
                signature.append(method.getReturnType().getName() + " ");
                signature.append(method.getName() + "()");
            } else if (descriptor.getReadMethod() != null) {
                signature.delete(0, signature.length());
                signature.append("Read-Write: ");
                method = descriptor.getReadMethod();
                signature.append(method.getReturnType().getName() + "/void ");
                signature.append("get/set(");
                signature.append(descriptor.getDisplayName() + ")");
            }
        }
        return signature.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

