/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.cool;

import com.sap.dictionary.types.services.NamingService;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.WebDynproMetamodelUtil;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.framework.ModelClassSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.api.IValueSetDescriptor;
import java.util.HashMap;
import java.util.Map;

public class CoolModelImporter {
    private static final String DDIC_BASE_TYPES_PACKAGE = "com.sap.dictionary";
    private static final String COOL_MODEL_TYPE_PACKAGE = "com.sap.tc.col";
    private static final String COOL_MODEL_TYPE_NAME = "CoolModel";
    private static final String SETTING_COOL_PART_NAME = "coolPartName";
    private static final String SETTING_COOL_TYPE = "coolType";
    private static final String SETTING_IS_EXECUTABLE = "isExecutable";
    private static final String SETTING_REQUIRES_ACCESSOR = "requiresAccessor";
    private static final String SETTING_REQUIRES_CG = "requiresCodeGeneration";
    private boolean useSmartNames = true;
    private int namespaceRepresentation = 0;
    private boolean useNewNamingService = false;
    protected WebDynproRoot mWebdynproRoot;
    protected DtDictionaryRoot mDdicRoot;
    private SourcePathIdentifier mSourcePathIdentifier;
    protected String mLanguage;
    private String mPackageName;
    private String mModelName;
    private Model mModel;
    private ImportLog mLog = new ImportLog();
    private boolean warningHasOccurred = false;
    private boolean errorHasOccurred = false;
    private String mLogPrefix;
    private static HashMap sTypeMap = new HashMap();
    private static final int LOWER_CASE = -1;
    private static final int BOUNDARY = 0;
    private static final int UPPER_CASE = 1;
    public static final int NAMESPACE_REPRESENTATION_IGNORE = 0;
    public static final int NAMESPACE_REPRESENTATION_AS_SUBPACKAGES = 1;
    public static final int NAMESPACE_REPRESENTATION_AS_SHORT_NAME_PREFIX = 2;
    public static final int NAMESPACE_REPRESENTATION_AS_LONG_NAME_PREFIX = 3;
    public static final int NAMESPACE_REPRESENTATION_AS_USER_DEFINED_NAME_PREFIX_AND_SUFFIX = 4;
    private static final int NAMESPACE_SERVICE_MODULE = 0;
    private static final int NAMESPACE_ASPECT = 1;
    private static final int NAMESPACE_STRUCTURE = 2;
    private static final int NAMESPACE_QUERY = 3;
    private static final int NAMESPACE_ASPECT_ACTION = 4;
    private static final int NAMESPACE_VALUE_SET = 5;
    private static final String[] coolPartTypes;
    private static final String[] namespaceShortPrefixes;
    private static final String[] namespaceLongPrefixes;
    private static final String[] namespaceUserDefinedPrefixes;
    private static final String[] namespaceUserDefinedSuffixes;
    private static final String[] namespaceSubPackages;
    private static final String[] FORBIDDEN_STRUCTURE_PROPERTY_NAMES;
    private static final String[] FORBIDDEN_ASPECT_ROW_PROPERTY_NAMES;
    private Map processedClasses = new HashMap();

    public ImportLog getImportLog() {
        return this.mLog;
    }

    private void info(String msg) {
        System.out.println("[" + this.mLogPrefix + ", Info] " + msg);
        this.mLog.addInfoMessage(msg);
    }

    private void warn(String msg) {
        System.out.println("[" + this.mLogPrefix + ", Warning] " + msg);
        this.mLog.addWarningMessage(msg);
        this.warningHasOccurred = true;
    }

    private void error(String msg) {
        this.error(msg, null);
    }

    private void error(String msg, Throwable e) {
        System.out.println("[" + this.mLogPrefix + ", Error] " + msg);
        this.mLog.addErrorMessage(msg);
        if (e != null) {
            e.printStackTrace(System.out);
            this.mLog.addException(e);
        }
        this.errorHasOccurred = true;
    }

    private void errorAndAbort(String msg) {
        this.error(msg);
        throw new FatalImportException(msg);
    }

    public CoolModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro) {
        this(dictionary, webdynpro, "en");
    }

    public CoolModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro, String language) {
        this.mWebdynproRoot = webdynpro;
        this.mDdicRoot = dictionary;
        this.mLanguage = language;
        this.mLogPrefix = "CoolModelImporter@" + Integer.toHexString(System.identityHashCode(this));
        this.configure();
    }

    private void configure() {
        try {
            String nsr;
            String unns = System.getProperty("com.sap.ide.metamodel.importers.cool.useNewNamingService");
            if (unns != null) {
                this.useNewNamingService = "true".equals(unns);
            }
            if ((nsr = System.getProperty("com.sap.ide.metamodel.importers.cool.namespaceRepresentation")) != null) {
                this.namespaceRepresentation = Integer.parseInt(nsr);
            }
            int i = 0;
            while (i < namespaceUserDefinedPrefixes.length) {
                String udns;
                String udnp = System.getProperty("com.sap.ide.metamodel.importers.cool.userDefinedNamePrefix." + i);
                if (udnp != null) {
                    CoolModelImporter.namespaceUserDefinedPrefixes[i] = udnp;
                }
                if ((udns = System.getProperty("com.sap.ide.metamodel.importers.cool.userDefinedNameSuffix." + i)) != null) {
                    CoolModelImporter.namespaceUserDefinedSuffixes[i] = udns;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DevelopmentObject findTypeForCoolType(String coolType) throws LoadException {
        if (!sTypeMap.containsKey(coolType)) {
            this.error("don't know how to handle cool type '" + coolType + "'");
            coolType = "STRING";
        }
        return this.mDdicRoot.getSimpleType(DDIC_BASE_TYPES_PACKAGE, (String)sTypeMap.get(coolType));
    }

    private CardinalityEnum convertCardinality(CMICardinality coolCardinality) {
        if (coolCardinality.equals(CMICardinality.CARDINALITY_MANY)) {
            return CardinalityEnum._0_N;
        }
        if (coolCardinality.equals(CMICardinality.CARDINALITY_ONE)) {
            return CardinalityEnum._1_1;
        }
        if (coolCardinality.equals(CMICardinality.CARDINALITY_ONE_TO_MANY)) {
            return CardinalityEnum._1_N;
        }
        if (coolCardinality.equals(CMICardinality.CARDINALITY_ZERO_TO_ONE)) {
            return CardinalityEnum._0_1;
        }
        this.error("can't interpret cardinality returned by cool meta data: '" + coolCardinality + "'");
        return CardinalityEnum._0_N;
    }

    public static String toMultiWordMixedCase(String value, boolean startWithUpperCase) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuffer buf = new StringBuffer();
        int len = value.length();
        int lastCharWas = startWithUpperCase ? 0 : -1;
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            int charIs = 1;
            if (value.charAt(i) == '_') {
                charIs = 0;
            }
            if (charIs == 0) {
                buf.append(c);
            } else if (lastCharWas == 0) {
                buf.append(Character.toUpperCase(c));
            } else {
                buf.append(Character.toLowerCase(c));
            }
            lastCharWas = charIs;
            ++i;
        }
        return buf.toString();
    }

    private static String getJavaNameForABAPName(String abapName) {
        String backendName = NamingService.Field.getBackendNameFromABAPName((String)abapName);
        int p = backendName.indexOf("%36%");
        while (p >= 0) {
            backendName = backendName.substring(0, p) + "$" + backendName.substring(p + 4);
        }
        if (backendName.equalsIgnoreCase("output")) {
            return "Output";
        }
        String frontendName = NamingService.Field.getJavaNameFromBackendName((String)backendName);
        return frontendName;
    }

    public void setUseSmartNames(boolean useSmartNames) {
        this.useSmartNames = useSmartNames;
    }

    public void setNamespaceRepresentation(int namespaceRepresentation) {
        this.namespaceRepresentation = namespaceRepresentation;
    }

    public void setUseNamespacePrefix(boolean useNamespacePrefix) {
        this.setNamespaceRepresentation(useNamespacePrefix ? 2 : 0);
    }

    private String convertClassName(int nameSpace, String abapName) {
        String result = "";
        if (this.namespaceRepresentation == 2) {
            result = namespaceShortPrefixes[nameSpace];
        } else if (this.namespaceRepresentation == 3) {
            result = namespaceLongPrefixes[nameSpace];
        } else if (this.namespaceRepresentation == 4) {
            result = namespaceUserDefinedPrefixes[nameSpace];
        }
        result = !this.useSmartNames ? result + abapName : result + CoolModelImporter.toMultiWordMixedCase(this.getValidName(abapName), true);
        if (this.namespaceRepresentation == 4) {
            result = result + namespaceUserDefinedSuffixes[nameSpace];
        }
        return result;
    }

    private String convertPackageName(int nameSpace, String packageName) {
        if (this.namespaceRepresentation == 1) {
            return packageName + namespaceSubPackages[nameSpace];
        }
        return packageName;
    }

    private String convertFieldName(String abapName) {
        if (!this.useSmartNames) {
            return this.getValidMemberName(abapName);
        }
        return CoolModelImporter.toMultiWordMixedCase(this.getValidMemberName(abapName), true);
    }

    private String convertPropertyName(String abapName) {
        if (!this.useSmartNames) {
            return this.getValidMemberName(abapName);
        }
        return CoolModelImporter.toMultiWordMixedCase(this.getValidMemberName(abapName), true);
    }

    private String convertRelationRoleName(String abapName) {
        if (!this.useSmartNames) {
            return this.getValidMemberName(abapName);
        }
        return CoolModelImporter.toMultiWordMixedCase(this.getValidMemberName(abapName), true);
    }

    private String getValidMemberName(String name) {
        if (name != null) {
            if (name.compareToIgnoreCase("class") == 0) {
                return '_' + name;
            }
            return this.getValidName(name);
        }
        return name;
    }

    private String getValidName(String name) {
        if (this.useNewNamingService) {
            return CoolModelImporter.getJavaNameForABAPName(name);
        }
        StringBuffer javaName = new StringBuffer();
        if (name.length() > 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
            javaName.append(name.charAt(0));
        } else {
            javaName.append('_');
        }
        int i = 1;
        while (i < name.length()) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) {
                javaName.append(name.charAt(i));
            } else {
                javaName.append('_');
            }
            ++i;
        }
        return javaName.toString();
    }

    private boolean arrayContains(String[] array, String name) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidName(String name, int namespace) {
        if (namespace == 2) {
            return !this.arrayContains(FORBIDDEN_STRUCTURE_PROPERTY_NAMES, name);
        }
        if (namespace == 1) {
            return !this.arrayContains(FORBIDDEN_ASPECT_ROW_PROPERTY_NAMES, name);
        }
        return true;
    }

    private static String getModelClassSetting(ModelClass modelClass, String settingName) {
        ModelClassSettingDefinition settingDef;
        ModelClassSetting setting = modelClass.getSetting(settingName);
        if ((setting == null || setting.getValue() == null) && (settingDef = modelClass.getModel().getModelType().getModelClassSettingDefinition(settingName)) != null) {
            return settingDef.getDefaultValue();
        }
        return setting.getValue();
    }

    private void importRelationRole(ModelClass sourceMC, String targetRoleName, ModelClass targetMC, CMICardinality cardinality, boolean generateFlag, boolean builtInRelation) throws MetamodelException {
        ModelRelationRole targetRole;
        String targetRoleNameConv = builtInRelation ? targetRoleName : this.convertRelationRoleName(targetRoleName);
        String relationNameConv = sourceMC.getName() + ":" + targetRoleNameConv;
        ModelRelation relation = this.mModel.getModelRelation(relationNameConv);
        if (relation == null) {
            relation = this.mModel.createModelRelation(relationNameConv);
        }
        if ((targetRole = relation.getModelRelationRole(targetRoleNameConv)) == null) {
            targetRole = relation.createModelRelationRole(targetRoleNameConv);
        }
        targetRole.setModelClass(targetMC);
        targetRole.setCardinality(this.convertCardinality(cardinality));
        targetRole.setNavigable(true);
        WebDynproMetamodelUtil.setModelRelationRoleSetting(targetRole, SETTING_REQUIRES_ACCESSOR, generateFlag ? "true" : "false");
        WebDynproMetamodelUtil.setModelRelationRoleSetting(targetRole, SETTING_COOL_PART_NAME, targetRoleName);
        ModelRelationRole sourceRole = relation.getModelRelationRole("Source");
        if (sourceRole == null) {
            sourceRole = relation.createModelRelationRole("Source");
        }
        sourceRole.setModelClass(sourceMC);
        sourceRole.setAggregate(false);
        sourceRole.setCardinality(CardinalityEnum._0_1);
        sourceRole.setNavigable(false);
    }

    private void addPropertiesFromStructure(ModelClass structureMC, IStructureDescriptor structure, int namespace) throws MetamodelException {
        int i = 0;
        while (i < structure.size()) {
            String propertyName = structure.getFieldDescriptor(i).getName();
            if (this.isValidName(propertyName, namespace)) {
                String propertyNameConv = this.convertPropertyName(propertyName);
                this.info("  " + structure.getFieldDescriptor(i).getType() + " " + propertyName);
                ModelClassProperty modelClassProperty = (ModelClassProperty)structureMC.getProperty(propertyNameConv);
                if (modelClassProperty == null) {
                    modelClassProperty = structureMC.createProperty(propertyNameConv);
                }
                modelClassProperty.setType(this.findTypeForCoolType(structure.getFieldDescriptor(i).getType()));
                WebDynproMetamodelUtil.setModelClassPropertySetting(modelClassProperty, SETTING_COOL_PART_NAME, propertyName);
            } else {
                this.warn("property '" + propertyName + "'suppressed due to naming conflicts");
            }
            ++i;
        }
    }

    private ModelClass getModelClass(int nameSpace, String coolPartName) {
        String packageName = this.convertPackageName(nameSpace, this.mPackageName);
        String className = this.convertClassName(nameSpace, coolPartName);
        String qName = packageName + "." + className;
        String coolPartType = coolPartTypes[nameSpace];
        ModelClass result = (ModelClass)this.processedClasses.get(qName);
        if (result != null) {
            if (coolPartType.equals(CoolModelImporter.getModelClassSetting(result, SETTING_COOL_TYPE)) && coolPartName.equals(CoolModelImporter.getModelClassSetting(result, SETTING_COOL_PART_NAME))) {
                return result;
            }
            this.errorAndAbort("duplicate class name '" + qName + "'");
        }
        return null;
    }

    private ModelClass createModelClass(int nameSpace, String coolPartName) throws MetamodelException {
        String packageName = this.convertPackageName(nameSpace, this.mPackageName);
        String className = this.convertClassName(nameSpace, coolPartName);
        String qName = packageName + "." + className;
        String coolPartType = coolPartTypes[nameSpace];
        ModelClass result = WebDynproMetamodelUtil.getOrCreateModelClass(this.mModel, packageName, className, this.mSourcePathIdentifier);
        WebDynproMetamodelUtil.setModelClassSetting(result, SETTING_COOL_TYPE, coolPartType);
        WebDynproMetamodelUtil.setModelClassSetting(result, SETTING_COOL_PART_NAME, coolPartName);
        this.processedClasses.put(qName, result);
        return result;
    }

    private ModelClass importStructure(IStructureDescriptor structure) throws MetamodelException {
        String structureName = structure.getName();
        ModelClass structureMC = this.getModelClass(2, structureName);
        if (structureMC != null) {
            return structureMC;
        }
        this.info("import structure '" + structureName + "'");
        structureMC = this.createModelClass(2, structureName);
        this.addPropertiesFromStructure(structureMC, structure, 2);
        return structureMC;
    }

    private ModelClass importAspect(IAspectDescriptor aspect) throws MetamodelException {
        String aspectName = aspect.getName();
        ModelClass aspectMC = this.getModelClass(1, aspectName);
        if (aspectMC != null) {
            return aspectMC;
        }
        this.info("import aspect '" + aspectName + "'");
        aspectMC = this.createModelClass(1, aspectName);
        this.addPropertiesFromStructure(aspectMC, aspect.getStructure(), 1);
        int i = 0;
        while (i < aspect.getStructure().size()) {
            if (aspect.getValueSetDescriptor(aspect.getStructure().getFieldDescriptor(i).getName()) != null) {
                this.importValueSet(aspect.getValueSetDescriptor(aspect.getStructure().getFieldDescriptor(i).getName()), aspect);
            }
            ++i;
        }
        IAspectActionDescriptor[] actions = aspect.getAspectActionDescriptors();
        int i2 = 0;
        while (i2 < actions.length) {
            this.importAction(actions[i2], aspect);
            ++i2;
        }
        IRelationDescriptor[] relations = aspect.getRelationDescriptors();
        int i3 = 0;
        while (i3 < relations.length) {
            this.importRelation(relations[i3]);
            ++i3;
        }
        return aspectMC;
    }

    private ModelClass importAction(IAspectActionDescriptor action, IAspectDescriptor aspect) throws MetamodelException {
        String actionName = action.getName();
        ModelClass actionMC = this.getModelClass(4, actionName);
        if (actionMC != null) {
            return actionMC;
        }
        this.info("import aspect action '" + actionName + "'");
        actionMC = this.createModelClass(4, actionName);
        WebDynproMetamodelUtil.setModelClassSetting(actionMC, SETTING_IS_EXECUTABLE, "true");
        if (action.getInputParameters() != null) {
            ModelClass inputParametersMC = this.importStructure(action.getInputParameters());
            this.importRelationRole(actionMC, "InputParameter", inputParametersMC, CMICardinality.CARDINALITY_ZERO_TO_ONE, false, true);
        }
        return actionMC;
    }

    private ModelClass importQuery(IQueryDescriptor query) throws MetamodelException {
        String queryName = query.getName();
        ModelClass queryMC = this.getModelClass(3, queryName);
        if (queryMC != null) {
            return queryMC;
        }
        this.info("import query '" + queryName + "'");
        queryMC = this.createModelClass(3, queryName);
        WebDynproMetamodelUtil.setModelClassSetting(queryMC, SETTING_IS_EXECUTABLE, "true");
        if (query.getInputParameters() != null) {
            ModelClass inputParametersMC = this.importStructure(query.getInputParameters());
            this.importRelationRole(queryMC, "InputParameter", inputParametersMC, CMICardinality.CARDINALITY_ZERO_TO_ONE, false, true);
        }
        ModelClass resultAspectMC = this.importAspect(query.getResultAspectDescriptor());
        this.importRelationRole(queryMC, "Result", resultAspectMC, CMICardinality.CARDINALITY_MANY, false, true);
        return queryMC;
    }

    private ModelClass importValueSet(IValueSetDescriptor valueSet, IAspectDescriptor aspect) throws MetamodelException {
        String valueSetName = valueSet.getName();
        ModelClass valueSetMC = this.getModelClass(5, valueSetName);
        if (valueSetMC != null) {
            return valueSetMC;
        }
        this.info("import value set '" + valueSetName + "'");
        valueSetMC = this.createModelClass(5, valueSetName);
        WebDynproMetamodelUtil.setModelClassSetting(valueSetMC, SETTING_IS_EXECUTABLE, "true");
        if (valueSet.getInputParameters() != null) {
            ModelClass inputParametersMC = this.importStructure(valueSet.getInputParameters());
            this.importRelationRole(valueSetMC, "InputParameter", inputParametersMC, CMICardinality.CARDINALITY_ZERO_TO_ONE, false, true);
        }
        ModelClass resultStructureMC = this.importStructure(valueSet.getResultStructureDescriptor());
        this.importRelationRole(valueSetMC, "Result", resultStructureMC, CMICardinality.CARDINALITY_MANY, false, true);
        return valueSetMC;
    }

    private void importRelation(IRelationDescriptor relation) throws MetamodelException {
        String relationName = relation.getName();
        this.info("import relation '" + relationName + "'");
        if (this.isValidName(relationName, 1)) {
            ModelClass mc1 = this.importAspect(relation.getSourceAspectDescriptor());
            ModelClass mc2 = this.importAspect(relation.getTargetAspectDescriptor());
            this.importRelationRole(mc1, relationName, mc2, relation.getAttributeTargetCardinality(), true, false);
        } else {
            this.warn("relation '" + relationName + "'suppressed due to naming conflicts");
        }
    }

    private Model importServiceModule(IServiceModuleDescriptor serviceModuleDescriptor, String modelName, boolean generateModelLayer) throws MetamodelException {
        ModelType modelType = this.mWebdynproRoot.getModelType(COOL_MODEL_TYPE_PACKAGE, COOL_MODEL_TYPE_NAME);
        if (modelType == null) {
            this.error("couldn't find required model type com.sap.tc.col.CoolModel");
        }
        this.mModel = WebDynproMetamodelUtil.getOrCreateModel(this.mWebdynproRoot, this.mPackageName, modelName, this.mSourcePathIdentifier);
        this.mModel.setModelType(modelType);
        WebDynproMetamodelUtil.setModelSetting(this.mModel, SETTING_REQUIRES_CG, generateModelLayer ? "true" : "false");
        this.info("beginning import of service module '" + serviceModuleDescriptor.getName() + "'");
        this.info("  import as '" + this.mPackageName + "." + modelName + "'");
        this.info("  use smart names = " + this.useSmartNames);
        this.info("  use namespace strategy = " + this.namespaceRepresentation);
        this.info("  use new naming service = " + this.useNewNamingService);
        this.info("  requiresCodeGeneration  = " + generateModelLayer);
        IAspectDescriptor[] aspects = serviceModuleDescriptor.getAspectDescriptors();
        int i = 0;
        while (i < aspects.length) {
            this.importAspect(aspects[i]);
            ++i;
        }
        IKeyAspectDescriptor[] keys = serviceModuleDescriptor.getKeyAspectDescriptors();
        int i2 = 0;
        while (i2 < keys.length) {
            this.importAspect((IAspectDescriptor)keys[i2]);
            ++i2;
        }
        IQueryDescriptor[] queries = serviceModuleDescriptor.getQueryDescriptors();
        int i3 = 0;
        while (i3 < queries.length) {
            this.importQuery(queries[i3]);
            ++i3;
        }
        IRelationDescriptor[] relations = serviceModuleDescriptor.getRelationDescriptors();
        int i4 = 0;
        while (i4 < relations.length) {
            this.importRelation(relations[i4]);
            ++i4;
        }
        return this.mModel;
    }

    private void importModel(IServiceModuleDescriptor serviceModuleDescriptor, boolean generateModelLayer) {
        try {
            this.importServiceModule(serviceModuleDescriptor, this.mModelName, generateModelLayer);
        }
        catch (FatalImportException e) {
        }
        catch (MetamodelException e) {
            this.error("exception during import", e);
        }
        if (this.mModel == null) {
            this.error("no model has been created");
        }
    }

    public Model doImport(String packageName, String modelName, SourcePathIdentifier sourcePathIdentifier, IServiceModuleDescriptor serviceModuleDescriptor, boolean generateModelLayer) {
        this.mPackageName = packageName;
        this.mModelName = modelName;
        this.mSourcePathIdentifier = sourcePathIdentifier;
        this.warningHasOccurred = false;
        this.errorHasOccurred = false;
        this.importModel(serviceModuleDescriptor, generateModelLayer);
        if (this.errorHasOccurred) {
            this.error("import finally cancelled due to errors (message should have been provided)");
            if (this.mModel != null) {
                if (this.mModel.isNew()) {
                    try {
                        this.mModel.delete();
                        this.info("newly created model has been discarded");
                    }
                    catch (DeleteException e) {
                        this.error("failed to delete newly created model", e);
                    }
                } else {
                    this.warn("Model has been updated, but import failed. Model might be inconsistent");
                }
            }
            return null;
        }
        if (this.warningHasOccurred) {
            this.warn("import finished, but with warning(s)");
        } else {
            this.info("import finished successfully");
        }
        return this.mModel;
    }

    static {
        sTypeMap.put("STRING", "string");
        sTypeMap.put("INTEGER", "integer");
        sTypeMap.put("DATE", "date");
        sTypeMap.put("BOOLEAN", "boolean");
        sTypeMap.put("TIMESTAMP", "timestamp");
        sTypeMap.put("DECIMAL", "decimal");
        sTypeMap.put("TIME", "time");
        sTypeMap.put("DOUBLE", "double");
        sTypeMap.put("VARIANT", "string");
        sTypeMap.put("BINARY", "binary");
        coolPartTypes = new String[]{null, "AspectRow", "Structure", "Query", "Action", "ValueSet"};
        namespaceShortPrefixes = new String[]{"M", "A", "S", "Q", "E", "V"};
        namespaceLongPrefixes = new String[]{"", "$Aspect$", "$Structure$", "$Query$", "$Action$", "$ValueSet$"};
        namespaceUserDefinedPrefixes = new String[]{"", "Aspect_", "Structure_", "Query_", "Action_", "ValueSet_"};
        namespaceUserDefinedSuffixes = new String[]{"", "", "", "", "", ""};
        namespaceSubPackages = new String[]{"", ".aspects", ".structures", ".queries", ".actions", ".valuesets"};
        FORBIDDEN_STRUCTURE_PROPERTY_NAMES = new String[]{"Descriptor", "EdoStructure"};
        FORBIDDEN_ASPECT_ROW_PROPERTY_NAMES = new String[]{"Aspect", "DependantAspectCache", "Descriptor", "Index", "Key", "LockState", "KeyFields", "Messages", "Name", "RelativeKeyUrl", "State"};
    }

    private static class FatalImportException
    extends RuntimeException {
        FatalImportException(String msg) {
            super(msg);
        }
    }
}

