/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers;

import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelClassPropertySetting;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRoleSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;

public abstract class WebDynproMetamodelUtil {
    public static Model getOrCreateModel(WebDynproRoot webdynproRoot, String packageName, String modelName, SourcePathIdentifier sourcePathIdentifier) throws MetamodelException {
        Model result = webdynproRoot.getModel(packageName, modelName);
        if (result == null) {
            result = webdynproRoot.createModel(packageName, modelName, sourcePathIdentifier);
        }
        return result;
    }

    public static ModelClass getOrCreateModelClass(Model model, String packageName, String className, SourcePathIdentifier sourcePathIdentifier) throws MetamodelException {
        ModelClass result = model.getModelClass(packageName, className);
        if (result == null) {
            result = model.createModelClass(packageName, className, sourcePathIdentifier);
        }
        return result;
    }

    public static void setModelSetting(Model model, String settingName, String settingValue) throws MetamodelException {
        ModelSetting modelSetting = model.getSetting(settingName);
        if (modelSetting == null) {
            modelSetting = model.createSetting(settingName);
        }
        modelSetting.setSettingDefinition(model.getModelType().getModelSettingDefinition(settingName));
        modelSetting.setValue(settingValue);
    }

    public static void setModelClassSetting(ModelClass modelClass, String settingName, String settingValue) throws MetamodelException {
        ModelClassSetting modelClassSetting = modelClass.getSetting(settingName);
        if (modelClassSetting == null) {
            modelClassSetting = modelClass.createSetting(settingName);
        }
        modelClassSetting.setSettingDefinition(modelClass.getModel().getModelType().getModelClassSettingDefinition(settingName));
        modelClassSetting.setValue(settingValue);
    }

    public static void setModelRelationRoleSetting(ModelRelationRole modelRelationRole, String settingName, String settingValue) throws MetamodelException {
        ModelRelationRoleSetting modelRelationRoleSetting = modelRelationRole.getSetting(settingName);
        if (modelRelationRoleSetting == null) {
            modelRelationRoleSetting = modelRelationRole.createSetting(settingName);
        }
        modelRelationRoleSetting.setSettingDefinition(modelRelationRole.getModelRelation().getModel().getModelType().getModelRelationRoleSettingDefinition(settingName));
        modelRelationRoleSetting.setValue(settingValue);
    }

    public static void setModelClassPropertySetting(ModelClassProperty modelClassProperty, String settingName, String settingValue) throws MetamodelException {
        ModelClassPropertySetting modelClassPropertySetting = modelClassProperty.getSetting(settingName);
        if (modelClassPropertySetting == null) {
            modelClassPropertySetting = modelClassProperty.createSetting(settingName);
        }
        modelClassPropertySetting.setSettingDefinition(((ModelClass)modelClassProperty.getAppClass()).getModel().getModelType().getModelClassPropertySettingDefinition(settingName));
        modelClassPropertySetting.setValue(settingValue);
    }
}

