/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class XsdlTypeRestrictions
implements Serializable {
    private static final long serialVersionUID = 2009092002L;
    public static final String MIN_EXCLUSIVE = "minExclusive";
    public static final String MIN_INCLUSIVE = "minInclusive";
    public static final String MAX_EXCLUSIVE = "maxExclusive";
    public static final String MAX_INCLUSIVE = "maxInclusive";
    public static final String TOTAL_DIGITS = "totalDigits";
    public static final String FRACTIONAL_DIGITS = "fractionDigits";
    public static final String LENGTH = "length";
    public static final String MIN_LENGTH = "minLength";
    public static final String MAX_LENGTH = "maxLength";
    public static final String ENUMERATION = "enumeration";
    public static final String WHITE_SPACE = "whiteSpace";
    public static final String PATTERN = "pattern";
    private Map restrictions = new Hashtable();
    private Set enumeration = new HashSet();
    private Set pattern = new HashSet();

    public XsdlTypeRestrictions(String[][] restrictions) {
        int i = 0;
        while (i < restrictions.length) {
            String name = restrictions[i][0];
            String value = restrictions[i][1];
            this.storeRestriction(name, value);
            ++i;
        }
    }

    private void storeRestriction(String name, String value) {
        if (name.equals(ENUMERATION)) {
            this.enumeration.add(value);
        } else if (name.equals(PATTERN)) {
            this.pattern.add(value);
        } else {
            this.restrictions.put(name, value);
        }
    }

    public String getRestriction(String name) {
        return (String)this.restrictions.get(name);
    }

    public String getMinExclusive() {
        return this.getRestriction(MIN_EXCLUSIVE);
    }

    public String getMinInclusive() {
        return this.getRestriction(MIN_INCLUSIVE);
    }

    public String getMaxExclusive() {
        return this.getRestriction(MAX_EXCLUSIVE);
    }

    public String getMaxInclusive() {
        return this.getRestriction(MAX_INCLUSIVE);
    }

    public BigInteger getTotalDigits() {
        String restriction = this.getRestriction(TOTAL_DIGITS);
        return restriction == null ? null : new BigInteger(restriction);
    }

    public BigInteger getFractionDigits() {
        String restriction = this.getRestriction(FRACTIONAL_DIGITS);
        return restriction == null ? null : new BigInteger(restriction);
    }

    public BigInteger getLength() {
        String restriction = this.getRestriction(LENGTH);
        return restriction == null ? null : new BigInteger(restriction);
    }

    public BigInteger getMinLength() {
        String restriction = this.getRestriction(MIN_LENGTH);
        return restriction == null ? null : new BigInteger(restriction);
    }

    public BigInteger getMaxLength() {
        String restriction = this.getRestriction(MAX_LENGTH);
        return restriction == null ? null : new BigInteger(restriction);
    }

    public Set getEnumeration() {
        return this.enumeration;
    }

    public String getWhiteSpace() {
        return this.getRestriction(WHITE_SPACE);
    }

    public Set getPattern() {
        return this.pattern;
    }
}

