/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.Descriptor;
import com.sap.aii.proxy.framework.core.QName;
import com.sap.aii.proxy.framework.core.XsdlAttributeProperties;
import com.sap.aii.proxy.framework.core.XsdlElementProperties;
import com.sap.aii.proxy.framework.core.XsdlTypeRestrictions;
import java.util.Hashtable;

final class XmlBaseTypeDescriptor
implements BaseTypeDescriptor,
Descriptor {
    private static final long serialVersionUID = 2009092002L;
    protected Hashtable attributeIndex = new Hashtable();
    protected Hashtable elementIndex = new Hashtable();
    protected XsdlElementProperties[] elementProperties;
    protected XsdlAttributeProperties[] attributeProperties;
    protected QName wsdlName;
    protected int xsdlType;
    protected Class javaClass;
    protected String metadataXml;
    protected Hashtable javaAttributeIndex = new Hashtable();
    protected Hashtable javaElementIndex = new Hashtable();
    protected String[] xmlAttributeList;
    protected String[] xmlElementList;
    protected Hashtable elementJavaNames = new Hashtable();
    protected String[] elemJavaNames;
    protected Hashtable attributeJavaNames = new Hashtable();
    protected String[] attrJavaNames;

    public XmlBaseTypeDescriptor(int xsdlType, String namespace, String localname, int numberOfElements, int numberOfAttributes, Class javaClass, String metadataXml) {
        this.xsdlType = xsdlType;
        this.wsdlName = new QName(localname, namespace);
        this.attributeProperties = new XsdlAttributeProperties[numberOfAttributes];
        this.elementProperties = new XsdlElementProperties[numberOfElements];
        this.attrJavaNames = new String[numberOfAttributes];
        this.elemJavaNames = new String[numberOfElements];
        this.javaClass = javaClass;
        this.metadataXml = metadataXml;
    }

    public void setAttributeProperties(int i, String localName, Object defaultValue, Object fixedValue, String form, String xmlType, String namespace, String use, String javaName, Class javaType, BaseTypeDescriptor attributeDescriptor, String[][] restrictions) {
        this.attributeProperties[i] = new XsdlAttributeProperties(localName, defaultValue, fixedValue, form, xmlType, namespace, javaName, javaType, attributeDescriptor, new XsdlTypeRestrictions(restrictions), use);
        String name = localName;
        if (name != null) {
            this.attributeIndex.put(name, new Integer(i));
            if (javaName != null) {
                this.attrJavaNames[i] = name;
                this.attributeJavaNames.put(name, javaName);
                this.javaAttributeIndex.put(javaName, new Integer(i));
            }
        }
    }

    public void setElementProperties(int i, String localName, Object defaultValue, Object fixedValue, String form, String xmlType, String namespace, boolean isAbstract, int minOccurs, int maxOccurs, boolean isNillable, String substitutionGroup, String javaName, Class javaType, BaseTypeDescriptor elementDescriptor, String[][] restrictions) {
        this.elementProperties[i] = new XsdlElementProperties(localName, defaultValue, fixedValue, form, xmlType, namespace, javaName, javaType, elementDescriptor, new XsdlTypeRestrictions(restrictions), isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, null);
        String name = localName;
        if (name != null) {
            this.elementIndex.put(name, new Integer(i));
            if (javaName != null) {
                this.elemJavaNames[i] = name;
                this.elementJavaNames.put(name, javaName);
                this.javaElementIndex.put(javaName, new Integer(i));
            }
        }
    }

    public void setElementProperties(int i, String localName, Object defaultValue, Object fixedValue, String form, String xmlType, String namespace, boolean isAbstract, int minOccurs, int maxOccurs, boolean isNillable, String substitutionGroup, String javaName, Class javaType, BaseTypeDescriptor elementDescriptor, String[][] restrictions, String metadataXml) {
        this.elementProperties[i] = new XsdlElementProperties(localName, defaultValue, fixedValue, form, xmlType, namespace, javaName, javaType, elementDescriptor, new XsdlTypeRestrictions(restrictions), isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, metadataXml);
        String name = localName;
        if (name != null) {
            this.elementIndex.put(name, new Integer(i));
            if (javaName != null) {
                this.elemJavaNames[i] = name;
                this.elementJavaNames.put(name, javaName);
                this.javaElementIndex.put(javaName, new Integer(i));
            }
        }
    }

    public final int getAttributeCount() {
        return this.attributeProperties.length;
    }

    public final int getAttributeIndex(String name) {
        Object value = this.attributeIndex.get(name);
        return value == null ? -1 : (Integer)value;
    }

    public final XsdlAttributeProperties getAttributeProperties(int i) {
        return this.attributeProperties[i];
    }

    public final XsdlAttributeProperties getAttributeProperties(String attributeName) {
        int index = this.getAttributeIndex(attributeName);
        return index < 0 ? null : this.attributeProperties[index];
    }

    public final int getElementCount() {
        return this.elementProperties.length;
    }

    public final int getElementIndex(String name) {
        Object value = this.elementIndex.get(name);
        return value == null ? -1 : (Integer)value;
    }

    public final XsdlElementProperties getElementProperties(int i) {
        return this.elementProperties[i];
    }

    public final XsdlElementProperties getElementProperties(String elementName) {
        int index = this.getElementIndex(elementName);
        return index < 0 ? null : this.elementProperties[index];
    }

    final String getMetadataXml() {
        return this.metadataXml;
    }

    public final QName getWsdlName() {
        return this.wsdlName;
    }

    public final Class getJavaClass() {
        return this.javaClass;
    }

    public int getXsdlType() {
        return this.xsdlType;
    }

    public final String[] getElementList() {
        return this.xmlElementList;
    }

    public final String[] getAttributeList() {
        return this.xmlAttributeList;
    }

    public final String getJavaNameOfElement(int i, String namespace) {
        return XmlBaseTypeDescriptor.getFieldName(this.elemJavaNames, i, namespace);
    }

    public final String getJavaNameOfElement(String elementName, String namespace) {
        return XmlBaseTypeDescriptor.getFieldName(this.elementJavaNames, elementName, namespace);
    }

    public final String getJavaNameOfAttribute(int i, String namespace) {
        return XmlBaseTypeDescriptor.getFieldName(this.attrJavaNames, i, namespace);
    }

    public final String getJavaNameOfAttribute(String attributeName, String namespace) {
        return XmlBaseTypeDescriptor.getFieldName(this.attributeJavaNames, attributeName, namespace);
    }

    public final boolean isElement(String elementName, String namespace) {
        return this.elementJavaNames.containsKey(XmlBaseTypeDescriptor.getQName(elementName, namespace));
    }

    public final boolean isAttribute(String attributeName, String namespace) {
        return this.attributeJavaNames.containsKey(XmlBaseTypeDescriptor.getQName(attributeName, namespace));
    }

    private static String getQName(String localName, String namespace) {
        if (localName == null) {
            return null;
        }
        StringBuffer qName = new StringBuffer();
        if (namespace != null && namespace.length() > 0) {
            qName.append(namespace);
            qName.append(":");
        }
        qName.append(localName);
        return qName.toString();
    }

    private static String getFieldName(String[] table, int i, String namespace) {
        String fieldName = XmlBaseTypeDescriptor.getQName(table[i], namespace);
        return fieldName;
    }

    private static String getFieldName(Hashtable table, String localName, String namespace) {
        Object field = table.get(XmlBaseTypeDescriptor.getQName(localName, namespace));
        if (field != null || (field = table.get(localName)) == null) {
            // empty if block
        }
        return (String)field;
    }
}

