/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.BaseProxyDescriptor;
import java.util.Hashtable;

final class XmlBaseProxyDescriptor
implements BaseProxyDescriptor {
    private static final long serialVersionUID = 2009092002L;
    protected String name = null;
    protected Hashtable wsdlMethodNames = null;
    protected Hashtable argClassNames = null;
    protected Hashtable resultClassNames = null;
    protected Hashtable resultTypeNames = null;
    protected Hashtable resultTypeClasses = null;
    protected Hashtable faultTypeClasses = null;

    public XmlBaseProxyDescriptor() {
    }

    public XmlBaseProxyDescriptor(String name, Object[][][] methodsAndTypes) {
        this.name = name;
        this.wsdlMethodNames = new Hashtable();
        this.argClassNames = new Hashtable();
        this.resultClassNames = new Hashtable();
        this.resultTypeNames = new Hashtable();
        this.resultTypeClasses = new Hashtable();
        this.faultTypeClasses = new Hashtable();
        int i = 0;
        while (i < methodsAndTypes.length) {
            Object[][] methods = methodsAndTypes[i];
            String methodName = null;
            int j = 0;
            while (j < methods.length) {
                Object[] namePair = methods[j];
                if (j == 0) {
                    this.wsdlMethodNames.put(namePair[1], namePair[0]);
                    methodName = (String)namePair[0];
                } else if (j == 1) {
                    this.argClassNames.put(methodName, namePair[1]);
                } else if (namePair[1] instanceof Class) {
                    if (j == 2) {
                        this.resultClassNames.put(methodName, ((Class)namePair[1]).getName());
                    }
                    this.resultTypeNames.put(namePair[0], ((Class)namePair[1]).getName());
                    this.resultTypeClasses.put(namePair[0], namePair[1]);
                    if (j > 2) {
                        this.faultTypeClasses.put(namePair[0], namePair[2]);
                    }
                } else {
                    if (j == 2) {
                        this.resultClassNames.put(methodName, namePair[1]);
                    }
                    try {
                        this.resultTypeNames.put(namePair[0], namePair[1]);
                        this.resultTypeClasses.put(namePair[0], Class.forName((String)namePair[1]));
                        if (j > 2) {
                            this.faultTypeClasses.put(namePair[0], Class.forName((String)namePair[2]));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public XmlBaseProxyDescriptor(Hashtable wsdlMethodNames, Hashtable resultTypeNames) {
        this.wsdlMethodNames = wsdlMethodNames;
        this.resultTypeNames = resultTypeNames;
    }

    public final String getWsdlName(String methodName) {
        return (String)this.wsdlMethodNames.get(methodName);
    }

    public final String getArgumentClassName(String methodName) {
        return (String)this.argClassNames.get(methodName);
    }

    public final String getResultClassName(String methodName) {
        return (String)this.resultClassNames.get(methodName);
    }

    final Hashtable getResultTypeList() {
        return this.resultTypeNames;
    }

    Class getResultTypeClass(String methodName) {
        return (Class)this.resultTypeClasses.get(methodName);
    }

    Class getFaultTypeClass(String methodName) {
        return (Class)this.faultTypeClasses.get(methodName);
    }

    String getResultTypeName(String methodName) {
        return (String)this.resultTypeNames.get(methodName);
    }

    public boolean isXml() {
        return true;
    }

    public boolean isJco() {
        return false;
    }
}

