/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractProxy;
import com.sap.aii.proxy.framework.core.BaseProxyException;
import com.sap.aii.proxy.framework.core.JcoProxy;
import com.sap.aii.proxy.framework.core.JcoProxyException;
import com.sap.aii.proxy.framework.core.JcoRuntimeMetaData;
import com.sap.aii.proxy.framework.core.SystemFaultException;
import java.math.BigDecimal;
import java.math.BigInteger;

class JcoRuntimeMetaDataImpl
implements JcoRuntimeMetaData {
    private AbstractProxy proxy = null;

    protected JcoRuntimeMetaDataImpl(AbstractProxy proxy) {
        this.proxy = proxy;
    }

    public BigDecimal adjustCurrencyAmount(BigDecimal amount, String currencyCode) throws SystemFaultException {
        if (amount == null) {
            throw new IllegalArgumentException("No amount");
        }
        BigInteger decimals = this.getCurrencyDecimals(currencyCode);
        if (decimals == null) {
            return null;
        }
        return this._adjustCurrencyAmount(amount, decimals.intValue());
    }

    private BigDecimal _adjustCurrencyAmount(BigDecimal amount, int decimals) {
        if (decimals < 2) {
            return amount.movePointRight(2 - decimals);
        }
        if (decimals > 2) {
            return amount.movePointLeft(decimals - 2);
        }
        return amount;
    }

    public BigInteger getCurrencyDecimals(String currencyCode) throws SystemFaultException {
        try {
            return JcoProxy.getCurrencyDecimals(this.proxy, currencyCode);
        }
        catch (JcoProxyException e) {
            throw new BaseProxyException(e.getMessage(), (Throwable)((Object)e));
        }
    }
}

