/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractProxy;
import com.sap.aii.proxy.framework.core.ApplicationFaultException;
import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.JcoBaseProxyDescriptor;
import com.sap.aii.proxy.framework.core.JcoMarshaler;
import com.sap.aii.proxy.framework.core.JcoProxyException;
import com.sap.mdi.Currency;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mw.jco.JCO;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Hashtable;

abstract class JcoProxy
implements Serializable {
    private static final long serialVersionUID = 2009092002L;
    private static ObjectFactory of = null;
    private static Hashtable ofs = new Hashtable();

    JcoProxy() {
    }

    static final BaseType send(AbstractProxy proxy, BaseType requestType, String namespace, String interfaceName, String methodName, BaseType responseType) throws JcoProxyException, ApplicationFaultException {
        int encoding = 0;
        JCO.Client jcoClient = null;
        BaseTypeDescriptor faultMessageDesc = null;
        jcoClient = proxy.messageSpecifier.getJcoClient();
        if (jcoClient == null) {
            throw new JcoProxyException(JcoProxyException.createMsg_NO_JCO_CLIENT());
        }
        if (!jcoClient.isAlive()) {
            throw new JcoProxyException(JcoProxyException.createMsg_JCO_CLIENT_NOT_ALIVE());
        }
        encoding = jcoClient.getAttributes().getPartnerCodepage().indexOf("41") == 0 ? 2 : 1;
        faultMessageDesc = ((JcoBaseProxyDescriptor)proxy.baseProxyDescriptor).getFaultMessageDescriptor(methodName);
        try {
            String abapFunctionName = ((JcoBaseProxyDescriptor)proxy.baseProxyDescriptor).getAbapFunctionName(methodName);
            JCO.Request jcoRequest = JcoMarshaler.marshalRequest(abapFunctionName, requestType, responseType, faultMessageDesc, encoding);
            JCO.Response jcoResponse = jcoClient.execute(jcoRequest);
            responseType = JcoMarshaler.unmarshalRecord(responseType, (JCO.Record)jcoResponse);
        }
        catch (JCO.Exception e) {
            JcoMarshaler.unmarshalException(e, proxy.baseProxyDescriptor, faultMessageDesc);
        }
        return responseType;
    }

    static final BigInteger getCurrencyDecimals(AbstractProxy proxy, String currencyCode) throws JcoProxyException {
        if (proxy == null) {
            throw new IllegalArgumentException("No proxy");
        }
        if (currencyCode == null) {
            throw new JcoProxyException(JcoProxyException.createMsg_NO_CURRENCY_CODE());
        }
        JCO.Client jcoClient = proxy.messageSpecifier.getJcoClient();
        if (jcoClient == null) {
            throw new JcoProxyException(JcoProxyException.createMsg_NO_JCO_CLIENT());
        }
        if (!jcoClient.isAlive()) {
            throw new JcoProxyException(JcoProxyException.createMsg_JCO_CLIENT_NOT_ALIVE());
        }
        int cdecs = 0;
        try {
            boolean isNew = false;
            JCO.Attributes attrs = jcoClient.getAttributes();
            String key = attrs == null ? "<null>" : attrs.getPartnerHost() + "-" + attrs.getSystemNumber() + "-" + attrs.getSystemID() + "-" + attrs.getClient();
            of = (ObjectFactory)ofs.get(key);
            if (of == null) {
                of = new ObjectFactory(jcoClient);
                ofs.put(key, of);
                isNew = true;
            }
            Currency currency = null;
            if (of.isSupported("CURRENCY_DIRECT")) {
                currency = of.getCurrency(currencyCode);
            }
            if (currency == null) {
                currency = of.getSapData().getCurrencies().getCurrency(currencyCode);
            }
            if (currency == null) {
                return null;
            }
            cdecs = currency.getDecimals();
        }
        catch (ObjectFactoryException e) {
            throw new JcoProxyException(JcoProxyException.createMsg_CURRENCY_ERROR(currencyCode, e.getMessage()));
        }
        return new BigInteger(String.valueOf(cdecs));
    }
}

