/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractList;
import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.BaseTypeData;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.DataAccessException;
import com.sap.aii.proxy.framework.core.DataSet;
import com.sap.aii.proxy.framework.core.DateTimeAccessException;
import com.sap.aii.proxy.framework.core.JcoBaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.JcoMarshaler;
import com.sap.aii.proxy.framework.core.XsdlElementProperties;
import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.JCO;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class JcoBaseTypeData
implements BaseTypeData,
DataSet {
    private JCO.Record jcoRecord;
    private JcoBaseTypeDescriptor descriptor;
    private Object[] complexTypes;
    private BigDecimal[] decimalTypes;
    private boolean isRecordInitial;
    static /* synthetic */ Class class$java$math$BigDecimal;

    private JcoBaseTypeData() {
    }

    JcoBaseTypeData(BaseTypeDescriptor descriptor) {
        this.init(descriptor, null);
    }

    JcoBaseTypeData(BaseTypeDescriptor descriptor, JCO.Record record) {
        this.init(descriptor, record);
    }

    private void init(BaseTypeDescriptor descriptor, JCO.Record record) {
        if (record == null) {
            this.jcoRecord = JcoMarshaler.newRecord((JcoBaseTypeDescriptor)descriptor);
            this.isRecordInitial = true;
        } else {
            this.jcoRecord = record;
            this.isRecordInitial = false;
        }
        this.descriptor = (JcoBaseTypeDescriptor)descriptor;
        if (this.descriptor.isNested()) {
            this.complexTypes = new Object[descriptor.getElementCount()];
            Arrays.fill(this.complexTypes, null);
        }
        if (this.descriptor.hasDecimals()) {
            this.decimalTypes = new BigDecimal[descriptor.getElementCount()];
            Arrays.fill(this.decimalTypes, null);
        }
    }

    private void throwElementIndexOutOfBoundException(int idx) {
        throw new IndexOutOfBoundsException("Element index " + idx + " Size: " + this.getElementCount());
    }

    private void throwAttributeIndexOutOfBoundException(int idx) {
        throw new IndexOutOfBoundsException("Attribute index " + idx + " Size: " + this.getAttributeCount());
    }

    private void propagateJcoException(JCO.Exception e, int idx) {
        try {
            if (e.getGroup() == 122) {
                if (this.jcoRecord.getType(idx) == 1 || this.jcoRecord.getType(idx) == 3) {
                    throw new DateTimeAccessException("Type conversion error, field " + this.descriptor.getElementProperties(idx).getName() + ", complex type " + this.descriptor.getJavaClass().toString(), (Throwable)e, this.jcoRecord.getString(idx));
                }
                throw new DataAccessException("Type conversion error, field " + this.descriptor.getElementProperties(idx).getName() + ", complex type " + this.descriptor.getJavaClass().toString(), (Throwable)e);
            }
            if (e.getGroup() != 127) {
                throw new DataAccessException("Data access error, field " + this.descriptor.getElementProperties(idx).getName() + ", complex type " + this.descriptor.getJavaClass().toString(), (Throwable)e);
            }
            this.throwElementIndexOutOfBoundException(idx);
        }
        catch (JCO.Exception ex) {
            throw new DataAccessException("Data access error, field idx " + idx + ", complex type " + this.descriptor.getJavaClass().toString());
        }
    }

    JCO.Record marshal(int encoding) {
        if (this.descriptor.getJcoMetaData(encoding).getTabLength() != this.jcoRecord.getTabLength()) {
            JCO.Record newRecord = JcoMarshaler.newRecord(this.descriptor, encoding);
            newRecord.copyFrom(this.jcoRecord);
            this.jcoRecord = newRecord;
        }
        if (this.descriptor.isNested() || this.descriptor.hasDecimals()) {
            IMetaData jcoMetaData = this.descriptor.getJcoMetaData();
            int i = 0;
            while (i < jcoMetaData.getFieldCount()) {
                if (this.complexTypes != null && this.complexTypes[i] != null) {
                    JCO.Structure nestedStruct;
                    XsdlElementProperties elProperties = this.descriptor.getElementProperties(i);
                    if (jcoMetaData.getType(i) == 99) {
                        JCO.Table nestedTable = null;
                        if (!(this.complexTypes[i] instanceof AbstractList)) {
                            throw new DataAccessException("Data conversion error: field " + elProperties.getName() + " of complex type " + this.descriptor.getJavaClass().toString() + " has wrong type, expected list type");
                        }
                        nestedTable = JcoMarshaler.marshalList(elProperties, (AbstractList)this.complexTypes[i], encoding);
                        this.jcoRecord.setValue(nestedTable, i);
                    } else if (jcoMetaData.getType(i) == 17 && (nestedStruct = (JCO.Structure)JcoMarshaler.marshalRecord(elProperties.getDescriptor(), (BaseType)this.complexTypes[i], encoding)) != null) {
                        this.jcoRecord.setValue(nestedStruct, i);
                    }
                } else if (this.decimalTypes != null && this.decimalTypes[i] != null) {
                    this.jcoRecord.setValue((Object)this.decimalTypes[i], i);
                }
                ++i;
            }
        }
        return this.jcoRecord;
    }

    public int getAttributeCount() {
        return 0;
    }

    public boolean hasAttributeValue(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return false;
    }

    public void deleteAttributeValue(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public boolean isAttributeDefaulted(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return false;
    }

    public boolean isAttributeFixed(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return false;
    }

    public Object getAttributeValue(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return null;
    }

    public int getAttributeValueAsInt(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return 0;
    }

    public long getAttributeValueAsLong(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return 0L;
    }

    public short getAttributeValueAsShort(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return 0;
    }

    public byte getAttributeValueAsByte(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return 0;
    }

    public byte[] getAttributeValueAsByteArray(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return null;
    }

    public float getAttributeValueAsFloat(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return 0.0f;
    }

    public double getAttributeValueAsDouble(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return 0.0;
    }

    public boolean getAttributeValueAsBoolean(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return false;
    }

    public BigInteger getAttributeValueAsBigInteger(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return null;
    }

    public BigDecimal getAttributeValueAsBigDecimal(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return null;
    }

    public String getAttributeValueAsString(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return null;
    }

    public String[] getAttributeValueAsStringArray(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return null;
    }

    public Date getAttributeValueAsDate(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return null;
    }

    public Time getAttributeValueAsTime(int i) {
        this.throwAttributeIndexOutOfBoundException(i);
        return null;
    }

    public void setAttributeValue(int i, Object value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public void setAttributeValue(int i, int value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public void setAttributeValue(int i, long value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public void setAttributeValue(int i, short value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public void setAttributeValue(int i, byte value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public void setAttributeValue(int i, byte[] value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public void setAttributeValue(int i, float value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public void setAttributeValue(int i, double value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public void setAttributeValue(int i, boolean value) {
        this.throwAttributeIndexOutOfBoundException(i);
    }

    public int getElementCount() {
        return this.descriptor.getElementCount();
    }

    public boolean hasElementValue(int i) {
        boolean ret = false;
        try {
            if (this.isRecordInitial) {
                if (this.jcoRecord.isInitialized(i) || this.complexTypes != null && this.complexTypes[i] != null || this.decimalTypes != null && this.decimalTypes[i] != null) {
                    ret = true;
                }
            } else {
                ret = true;
            }
        }
        catch (JCO.Exception ex) {
            this.throwElementIndexOutOfBoundException(i);
        }
        return ret;
    }

    public void deleteElementValue(int i) {
        this.jcoRecord.setValue((Object)null, i);
    }

    public boolean isElementDefaulted(int i) {
        return false;
    }

    public boolean isElementFixed(int i) {
        return this.descriptor.getElementProperties(i).getFixedValue() != null;
    }

    public Object getElementValue(int i) {
        try {
            if (this.jcoRecord.getType(i) == 99 || this.jcoRecord.getType(i) == 17) {
                if (this.complexTypes[i] == null && !this.isRecordInitial) {
                    this.complexTypes[i] = this.jcoRecord.getType(i) == 99 ? JcoMarshaler.unmarshalList(this.descriptor.getElementProperties(i), this.jcoRecord.getTable(i)) : JcoMarshaler.unmarshalRecord(this.descriptor.getElementProperties(i).getDescriptor(), (JCO.Record)this.jcoRecord.getStructure(i));
                }
                return this.complexTypes[i];
            }
            if (this.isRecordInitial && this.descriptor.getElementProperties(i).getDefaultValue() == null && !this.jcoRecord.isInitialized(i)) {
                return null;
            }
            if (this.jcoRecord.getType(i) == 2) {
                if (this.decimalTypes[i] == null && !this.isRecordInitial) {
                    this.decimalTypes[i] = this.jcoRecord.getBigDecimal(i);
                }
                return this.decimalTypes[i];
            }
            return JcoMarshaler.getElementValueFromJco(this.jcoRecord, i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
        catch (Exception e) {
            if (this.jcoRecord.getType(i) == 1 || this.jcoRecord.getType(i) == 3) {
                throw new DateTimeAccessException("Type conversion error, field " + this.descriptor.getElementProperties(i).getName() + ", complex type " + this.descriptor.getJavaClass().toString(), (Throwable)e, this.jcoRecord.getString(i));
            }
            throw new DataAccessException("Type conversion error, field " + this.descriptor.getElementProperties(i).getName() + ", complex type " + this.descriptor.getJavaClass().toString(), (Throwable)e);
        }
        return null;
    }

    public int getElementValueAsInt(int i) {
        try {
            return this.jcoRecord.getInt(i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return 0;
        }
    }

    public long getElementValueAsLong(int i) {
        try {
            return this.jcoRecord.getBigDecimal(i).longValue();
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return 0L;
        }
    }

    public short getElementValueAsShort(int i) {
        try {
            return (short)this.jcoRecord.getInt(i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return 0;
        }
    }

    public byte getElementValueAsByte(int i) {
        try {
            return (byte)this.jcoRecord.getInt(i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return 0;
        }
    }

    public byte[] getElementValueAsByteArray(int i) {
        try {
            if (this.isRecordInitial && this.descriptor.getElementProperties(i).getDefaultValue() == null && !this.jcoRecord.isInitialized(i)) {
                return null;
            }
            return this.jcoRecord.getByteArray(i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return null;
        }
    }

    public float getElementValueAsFloat(int i) {
        try {
            return (float)this.jcoRecord.getDouble(i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return 0.0f;
        }
    }

    public double getElementValueAsDouble(int i) {
        try {
            return this.jcoRecord.getDouble(i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return 0.0;
        }
    }

    public boolean getElementValueAsBoolean(int i) {
        try {
            return this.jcoRecord.getInt(i) != 0;
        }
        catch (JCO.ConversionException cex) {
            try {
                String value = this.jcoRecord.getString(i);
                return value.length() != 0 && !value.equalsIgnoreCase("false");
            }
            catch (JCO.Exception e) {
                this.propagateJcoException(e, i);
            }
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
        return false;
    }

    public BigInteger getElementValueAsBigInteger(int i) {
        try {
            if (this.isRecordInitial && this.descriptor.getElementProperties(i).getDefaultValue() == null && !this.jcoRecord.isInitialized(i)) {
                return null;
            }
            return new BigInteger(this.jcoRecord.getString(i));
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return null;
        }
    }

    public BigDecimal getElementValueAsBigDecimal(int i) {
        try {
            if (this.isRecordInitial && this.descriptor.getElementProperties(i).getDefaultValue() == null && !this.jcoRecord.isInitialized(i)) {
                return null;
            }
            if (this.decimalTypes[i] == null) {
                this.decimalTypes[i] = this.jcoRecord.getBigDecimal(i);
            }
            return this.decimalTypes[i];
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return null;
        }
    }

    public String getElementValueAsString(int i) {
        try {
            if (this.isRecordInitial && this.descriptor.getElementProperties(i).getDefaultValue() == null && !this.jcoRecord.isInitialized(i)) {
                return null;
            }
            return this.jcoRecord.getString(i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return null;
        }
    }

    public String[] getElementValueAsStringArray(int i) {
        return null;
    }

    public Date getElementValueAsDate(int i) {
        try {
            if (this.isRecordInitial && this.descriptor.getElementProperties(i).getDefaultValue() == null && !this.jcoRecord.isInitialized(i)) {
                return null;
            }
            java.util.Date date = this.jcoRecord.getDate(i);
            return date == null ? null : new Date(date.getTime());
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
            return null;
        }
    }

    public Time getElementValueAsTime(int i) {
        try {
            if (this.isRecordInitial && this.descriptor.getElementProperties(i).getDefaultValue() == null && !this.jcoRecord.isInitialized(i)) {
                return null;
            }
            return Time.valueOf(this.jcoRecord.getString(i));
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
        catch (Exception e) {
            throw new DateTimeAccessException("Type conversion error, field " + this.descriptor.getElementProperties(i).getName() + ", complex type " + this.descriptor.getJavaClass().toString(), (Throwable)e, this.jcoRecord.getString(i));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElementValue(int i, Object value) {
        try {
            if (this.jcoRecord.getType(i) == 99 || this.jcoRecord.getType(i) == 17) {
                if (!this.descriptor.getElementProperties(i).getJavaClass().isInstance(value)) throw new DataAccessException("Type conversion error, field " + this.descriptor.getElementProperties(i).getName() + ", complex type " + this.descriptor.getJavaClass().toString());
                this.complexTypes[i] = value;
                this.jcoRecord.setValue((Object)null, i);
                return;
            } else if (this.descriptor.getElementProperties(i).getJavaClass() == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JcoBaseTypeData.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                this.decimalTypes[i] = (BigDecimal)value;
                this.jcoRecord.setValue((Object)null, i);
                return;
            } else {
                this.jcoRecord.setValue(value, i);
            }
            return;
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public void setElementValue(int i, int value) {
        try {
            this.jcoRecord.setValue(value, i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public void setElementValue(int i, long value) {
        try {
            this.jcoRecord.setValue(value, i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public void setElementValue(int i, short value) {
        try {
            this.jcoRecord.setValue(value, i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public void setElementValue(int i, byte value) {
        try {
            this.jcoRecord.setValue(value, i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public void setElementValue(int i, byte[] value) {
        try {
            this.jcoRecord.setValue(value, i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public void setElementValue(int i, float value) {
        try {
            this.jcoRecord.setValue((double)value, i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public void setElementValue(int i, double value) {
        try {
            this.jcoRecord.setValue(value, i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public void setElementValue(int i, boolean value) {
        try {
            if (this.jcoRecord.getType(i) != 0 || this.jcoRecord.getLength(i) != 1) {
                throw new DataAccessException("Type conversion error, field idx " + i + ", complex type " + this.descriptor.getJavaClass().toString() + ", expected type of field " + this.descriptor.getElementProperties(i).getJavaClass().toString());
            }
            this.jcoRecord.setValue(value ? (char)'X' : ' ', i);
        }
        catch (JCO.Exception e) {
            this.propagateJcoException(e, i);
        }
    }

    public Iterator getAttributeIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getElementIterator() {
        return new ElementIterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ElementIterator
    implements Iterator {
        int cursor = 0;

        private ElementIterator() {
        }

        public boolean hasNext() {
            return this.cursor != JcoBaseTypeData.this.getElementCount();
        }

        public Object next() {
            try {
                Object next = JcoBaseTypeData.this.getElementValue(this.cursor++);
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException("removing elements from a record not supported");
        }
    }
}

