/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractType;
import com.sap.aii.proxy.framework.core.BaseList;
import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.DataAccessException;
import com.sap.aii.proxy.framework.core.JcoBaseTypeData;
import com.sap.aii.proxy.framework.core.JcoBaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.JcoMarshaler;
import com.sap.aii.proxy.framework.core.JcoSimpleListElementProperties;
import com.sap.aii.proxy.framework.core.JcoStructure;
import com.sap.aii.proxy.framework.core.JcoTable;
import com.sap.aii.proxy.framework.core.XsdlElementProperties;
import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.JCO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class JcoBaseList
extends BaseList
implements Serializable {
    private static final long serialVersionUID = 2009092002L;
    private List list;
    private JCO.Table jcoTable;
    private int rowsCopied;

    JcoBaseList(XsdlElementProperties properties) {
        super(properties);
        this.list = new ArrayList();
    }

    JcoBaseList(XsdlElementProperties properties, JCO.Table jcoTable) {
        super(properties);
        this.jcoTable = jcoTable;
        this.list = new ArrayList(jcoTable.getNumRows());
        this.list = new ArrayList<Object>(Collections.nCopies(jcoTable.getNumRows(), null));
    }

    private Object createElementFromRecord(int index) {
        if (this.jcoTable != null) {
            this.jcoTable.setRow(index);
            BaseTypeDescriptor descriptor = this.properties.getDescriptor();
            try {
                if (descriptor != null) {
                    JcoStructure struct = new JcoStructure(this.jcoTable);
                    JcoBaseTypeData baseTypeDataObj = new JcoBaseTypeData(descriptor, (JCO.Record)struct);
                    AbstractType el = (AbstractType)this.itemClass.newInstance();
                    el.baseTypeData(baseTypeDataObj);
                    ++this.rowsCopied;
                    if (this.rowsCopied == this.jcoTable.getNumRows()) {
                        this.jcoTable = null;
                    }
                    return el;
                }
                ++this.rowsCopied;
                Object obj = JcoMarshaler.getElementValueFromJco((JCO.Record)this.jcoTable, 0);
                if (this.rowsCopied == this.jcoTable.getNumRows()) {
                    this.jcoTable = null;
                }
                return obj;
            }
            catch (Exception e) {
                throw new DataAccessException("Failed to create record of type: " + this.properties.getJavaClass().toString() + ", index: " + index, (Throwable)e);
            }
        }
        throw new DataAccessException("JCo data source missing for type: " + this.properties.getJavaClass().toString());
    }

    private void addElementsFromTable() {
        int i = 0;
        while (this.jcoTable != null && i < this.jcoTable.getNumRows()) {
            Object element = this.list.get(i);
            if (element == null) {
                this.list.set(i, this.createElementFromRecord(i));
            }
            ++i;
        }
    }

    protected final void removeRange(int fromIndex, int toIndex) {
        this.addElementsFromTable();
        this.list.subList(fromIndex, toIndex).clear();
    }

    JCO.Table marshal(int encoding) {
        JcoTable retTable = null;
        IMetaData jcoMetaData = null;
        JcoBaseTypeDescriptor itemDesc = (JcoBaseTypeDescriptor)this.properties.getDescriptor();
        jcoMetaData = itemDesc != null ? itemDesc.getJcoMetaData(encoding) : ((JcoSimpleListElementProperties)this.properties).getJcoMetaData(encoding);
        if (this.jcoTable != null) {
            if (this.rowsCopied == 0) {
                if (jcoMetaData.getTabLength() != this.jcoTable.getTabLength()) {
                    retTable = new JcoTable(jcoMetaData);
                    this.jcoTable.setRow(0);
                    retTable.copyFrom((JCO.Record)this.jcoTable);
                } else if (this.jcoTable.getNumRows() != 0 || this.list == null || this.list.isEmpty()) {
                    retTable = this.jcoTable;
                }
            } else {
                this.addElementsFromTable();
            }
        }
        if (retTable == null) {
            JcoBaseTypeDescriptor elDesc = (JcoBaseTypeDescriptor)this.properties.getDescriptor();
            JcoTable newTable = new JcoTable(jcoMetaData);
            newTable.appendRows(this.list.size());
            if (elDesc != null) {
                int i = 0;
                while (i < this.list.size()) {
                    AbstractType el = (AbstractType)this.list.get(i);
                    newTable.setRow(i);
                    if (el != null) {
                        JCO.Record jcoRecord = JcoMarshaler.marshalRecord(elDesc, (BaseType)el, encoding);
                        newTable.copyRawData(jcoRecord);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.list.size()) {
                    Object el = this.list.get(i);
                    newTable.setRow(i);
                    if (el != null) {
                        newTable.setValue(el, 0);
                    }
                    ++i;
                }
            }
            retTable = newTable;
        }
        return retTable;
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.jcoTable = null;
        this.list.clear();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.indexOf(it.next()) != -1) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object o) {
        if (!this.itemClass.isInstance(o)) {
            return -1;
        }
        return super.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        if (!this.itemClass.isInstance(o)) {
            return -1;
        }
        return super.lastIndexOf(o);
    }

    public Object[] toArray() {
        this.addElementsFromTable();
        return this.list.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.addElementsFromTable();
        return this.list.toArray(a);
    }

    public boolean remove(Object o) {
        if (!this.itemClass.isInstance(o)) {
            return false;
        }
        ++this.modCount;
        this.addElementsFromTable();
        return this.list.remove(o);
    }

    public Object remove(int index) {
        this.addElementsFromTable();
        ++this.modCount;
        return this.list.remove(index);
    }

    public boolean removeAll(Collection c) {
        this.addElementsFromTable();
        ++this.modCount;
        return this.list.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.addElementsFromTable();
        ++this.modCount;
        return this.list.retainAll(c);
    }

    public int hashCode() {
        this.addElementsFromTable();
        return this.list.hashCode();
    }

    public Object get(int index) {
        Object element = this.list.get(index);
        if (element == null) {
            element = this.createElementFromRecord(index);
            this.list.set(index, element);
        }
        return element;
    }

    public Object set(int index, Object element) {
        this.checkType(element);
        this.addElementsFromTable();
        return this.list.set(index, element);
    }

    public boolean add(Object element) {
        this.checkType(element);
        this.addElementsFromTable();
        ++this.modCount;
        return this.list.add(element);
    }

    public void add(int index, Object element) {
        this.checkType(element);
        this.addElementsFromTable();
        ++this.modCount;
        this.list.add(index, element);
    }

    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.checkType(it.next());
        }
        this.addElementsFromTable();
        ++this.modCount;
        return this.list.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        if (index > this.list.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.list.size());
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.checkType(it.next());
        }
        this.addElementsFromTable();
        ++this.modCount;
        return this.list.addAll(index, c);
    }
}

