/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.svgexport;

import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class Utils {
    public static String getHrefForElement(Element element, String string) {
        return Utils.getHrefForElement(element, string, ", ");
    }

    public static String getHrefForElement(Element element, String string, String string2) {
        if (Utils.isSourceCodeMetaclass(element.getPropertyValue("$metaclass"))) {
            return Utils.getHrefForSourceCodeElement(element, string, string2);
        }
        return Utils.getHrefForDesignElement(element, string);
    }

    public static String getHrefForSourceCodeElement(Element element, String string, String string2) {
        Entity entity;
        Entity entity2 = entity = element instanceof Reference ? ((Reference)element).getEntity() : (Entity)element;
        if (entity.hasProperty("$referenced")) {
            return null;
        }
        String string3 = Utils.getPackageFullNameForEntity(entity);
        if (string3.length() > 0) {
            string3 = string3.replace('.', '/') + "/";
        }
        String string4 = string + string3;
        String string5 = entity.getPropertyValue("$metaclass");
        if ("Package".equals(string5)) {
            return string4 + "package-summary.html";
        }
        if ("Class".equals(string5)) {
            boolean bl = "Class".equals(entity.getParent().getPropertyValue("$metaclass"));
            if (bl) {
                return string4 + entity.getParent().getPropertyValue("$name") + "." + entity.getPropertyValue("$name") + ".html";
            }
            return string4 + entity.getPropertyValue("$name") + ".html";
        }
        Entity entity3 = entity.getParent();
        return Utils.getHrefForSourceCodeElement((Element)entity3, string, string2) + Utils.getAnchorForClassMember(entity, string2);
    }

    public static String getAnchorForClassMember(Entity entity, String string) {
        String string2 = entity.getPropertyValue("$metaclass");
        String string3 = entity.getPropertyValue("$name");
        if ("Attribute".equals(string2)) {
            return "#" + string3;
        }
        String string4 = Utils.getParameters(entity, string);
        return "#" + string3 + "(" + string4 + ")";
    }

    public static String getParameters(Entity entity, String string) {
        String string2 = "";
        PropertyEnumeration propertyEnumeration = entity.properties("$parameter");
        boolean bl = true;
        while (propertyEnumeration.hasMoreElements()) {
            String string3;
            Property property = propertyEnumeration.next();
            PropertyMap propertyMap = property.getSubproperties();
            String string4 = propertyMap.getPropertyValue("$typeReferencedElement");
            UniqueName uniqueName = ModelAccess.createUniqueName((String)string4);
            if (uniqueName == null) continue;
            Entity entity2 = entity.getModel().findEntity(uniqueName);
            if (entity2 != null) {
                string4 = entity2.getPropertyValue("$fullName");
            }
            if (!bl) {
                string2 = string2 + string;
            }
            if ((string3 = propertyMap.getPropertyValue("$type")).endsWith("[]")) {
                string4 = string4 + "[]";
            }
            string2 = string2 + string4;
            bl = false;
        }
        return string2;
    }

    public static String getHrefForDesignElement(Element element, String string) {
        ReferenceCollection referenceCollection = null;
        String string2 = element.getPropertyValue("$metaclass");
        referenceCollection = string2.toLowerCase().endsWith("diagram") ? (element instanceof ReferenceCollection ? (ReferenceCollection)element : (ReferenceCollection)((Reference)element).getEntity()) : Utils.findDiagramNode(element);
        if (referenceCollection == null) {
            return null;
        }
        String string3 = Utils.getDisplayDiagramName(referenceCollection);
        String string4 = null;
        if ("WebContentDiagram".equals(referenceCollection.getPropertyValue("$metaclass"))) {
            string4 = Utils.getPathForWebContentFolder(referenceCollection.getParent()) + "/";
        } else if ("WDWindowDiagram".equals(referenceCollection.getPropertyValue("$metaclass"))) {
            string4 = "WDWebDynpro/";
        } else {
            string4 = Utils.getPackageFullNameForEntity((Entity)referenceCollection);
            if (string4.length() > 0) {
                string4 = string4.replace('.', '/') + "/";
            }
        }
        String string5 = "";
        if (!(element instanceof ReferenceCollection || "Package".equals(string2) || string2.toLowerCase().endsWith("diagram"))) {
            UniqueName uniqueName = element instanceof Reference ? ((Reference)element).getEntity().getUniqueName() : element.getUniqueName();
            string5 = "#" + Utils.replaceSemicolons(uniqueName.toString());
        }
        return string + string4 + string3 + ".html" + string5;
    }

    public static String getPathForWebContentFolder(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = entity.getPropertyValue("$name");
        Entity entity2 = entity.getParent();
        if ("com.tssap.j2ee.core.web.WebContent".equals(entity2.getPropertyValue("$metaclass"))) {
            stringBuffer.append(Utils.getPathForWebContentFolder(entity2));
            stringBuffer.append("/");
        }
        stringBuffer.append(string);
        System.out.println("full name: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public static String getDisplayDiagramName(ReferenceCollection referenceCollection) {
        String string = referenceCollection.getPropertyValue("$name");
        String string2 = referenceCollection.getPropertyValue("$metaclass");
        if ("EjbJarDiagram".equals(string2) || "EARDiagram".equals(string2) || "WebAppDiagram".equals(string2)) {
            if (string.endsWith(".xml")) {
                string = string.substring(0, string.length() - ".xml".length());
            }
            if (string.startsWith("META-INF")) {
                return string.substring(9);
            }
            if (string.startsWith("WEB-INF")) {
                return string.substring(8);
            }
        }
        return string;
    }

    public static String getPackageFullNameForEntity(Entity entity) {
        String string;
        if ("Package".equals(entity.getPropertyValue("$metaclass"))) {
            return entity.getPropertyValue("$fullName");
        }
        Entity entity2 = entity.getParent();
        while (entity2 != null) {
            string = entity2.getPropertyValue("$metaclass");
            if ("Package".equals(string)) break;
            entity2 = entity2.getParent();
        }
        if (entity2 == null) {
            return "";
        }
        string = entity2.getPropertyValue("$fullName");
        if (string != null) {
            return string;
        }
        return Utils.getDesignPackageFullName(entity2, entity2.getPropertyValue("$name"));
    }

    public static ReferenceCollection findDiagramNode(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ReferenceCollection) {
            return (ReferenceCollection)element;
        }
        if (element instanceof Reference) {
            return (ReferenceCollection)element.getParent();
        }
        return Utils.getDefaultDiagram((Entity)element, true);
    }

    public static ReferenceCollection getDefaultDiagram(Entity entity) {
        return Utils.getDefaultDiagram(entity, false);
    }

    public static ReferenceCollection getDefaultDiagram(Entity entity, boolean bl) {
        if (entity == null) {
            return null;
        }
        String string = entity.getPropertyValue("DiagramUIN");
        UniqueName uniqueName = ModelAccess.createUniqueName((String)string);
        if (uniqueName == null) {
            return bl ? Utils.getDefaultDiagram(entity.getParent(), true) : null;
        }
        return entity.getModel().findReferenceCollection(uniqueName);
    }

    public static boolean isSourceCodeMetaclass(String string) {
        return "Package".equals(string) || "Class".equals(string) || "Attribute".equals(string) || "Operation".equals(string);
    }

    public static String replaceSemicolons(String string) {
        return string.replace(';', '&');
    }

    private static String getDesignPackageFullName(Entity entity, String string) {
        Entity entity2 = entity.getParent();
        if ("Package".equals(entity2.getPropertyValue("$metaclass"))) {
            String string2 = entity2.getPropertyValue("$name");
            return Utils.getDesignPackageFullName(entity2, string2) + "/" + string;
        }
        IProject iProject = ModelUinSupport.getProject((UniqueName)entity.getModel().getUniqueName());
        IPath iPath = DesignRootAccess.getInstance((IProject)iProject).getRootPath();
        return iPath.toString() + "/" + string;
    }
}

