/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.svgexport;

import com.togethersoft.selena.gde.graphics.D2dToSvgGraphics;
import com.togethersoft.selena.gde.svgexport.HyperLinkGenerator;
import com.togethersoft.selena.gde.svgexport.HyperLinkManager;
import com.togethersoft.selena.gde.svgexport.SvgExportPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.parts.GraphicalRootEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SVGExporter {
    private IPath myPath;
    private String myPathToRoot;
    private String myFileName;
    private GC myGC;
    private D2dToSvgGraphics svgSaver;
    private static final String thisClassName = "SVGExporter";
    private static final String allCases = "*";
    private String traceFilter = Platform.getDebugOption((String)"com.togethersoft.selena.gde.svgexport/debug/filter");

    public SVGExporter(IPath iPath, String string, String string2) {
        this.myPath = iPath;
        this.myPathToRoot = string;
        this.myFileName = string2;
        Shell shell = new Shell(8);
        shell.setLayout((Layout)new FillLayout());
        this.myGC = new GC((Drawable)shell.getDisplay());
        this.myGC.setClipping(0, 0, 10000, 10000);
        this.svgSaver = new D2dToSvgGraphics(this.myGC, new Dimension(0, 0), iPath);
    }

    public Dimension generate(GraphicalRootEditPart graphicalRootEditPart, boolean bl) {
        this.trace("exporting PRIMARY_LAYER");
        EditPart editPart = graphicalRootEditPart.getContents();
        List list = null;
        IFigure iFigure = graphicalRootEditPart.getLayer((Object)"Connection Layer");
        IFigure iFigure2 = graphicalRootEditPart.getLayer((Object)"Primary Layer");
        Dimension dimension = iFigure2.getPreferredSize();
        this.trace("Primary layer bounds:" + iFigure2.getBounds() + ", preferedSize:" + iFigure2.getPreferredSize());
        this.svgSaver.setBackgroundColor(ColorConstants.white);
        this.svgSaver.fillRectangle(0, 0, dimension.width, dimension.height);
        Color color = this.svgSaver.getForegroundColor();
        this.svgSaver.setForegroundColor(ColorConstants.blue);
        this.svgSaver.drawRectangle(0, 0, dimension.width - 1, dimension.height - 1);
        this.svgSaver.setForegroundColor(color);
        if (editPart instanceof GraphicalEditPart) {
            list = ((GraphicalEditPart)editPart).getChildren();
            Iterator iterator = list.iterator();
            ArrayList<GraphicalEditPart> arrayList = new ArrayList<GraphicalEditPart>();
            while (iterator.hasNext()) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)iterator.next();
                if (arrayList.contains(graphicalEditPart)) continue;
                HyperLinkManager hyperLinkManager = null;
                if (bl) {
                    hyperLinkManager = HyperLinkGenerator.generateHyperlinks(this.myPath, this.myPathToRoot, graphicalEditPart);
                }
                IFigure iFigure3 = graphicalEditPart.getFigure();
                this.generate(iFigure3, dimension, hyperLinkManager);
                arrayList.add(graphicalEditPart);
            }
        }
        this.trace("exporting CONNECTION_LAYER");
        iFigure.setVisible(true);
        iFigure2.setVisible(false);
        this.trace("Connection layer bounds:" + iFigure.getBounds() + ", preferedSize:" + iFigure.getPreferredSize());
        iFigure.setOpaque(false);
        this.generate(iFigure, dimension, null);
        iFigure2.setVisible(true);
        this.svgSaver.dispose();
        return dimension;
    }

    public void generate(IFigure iFigure, Dimension dimension, HyperLinkManager hyperLinkManager) {
        SvgExportPlugin.info("Export min size=" + iFigure.getMinimumSize());
        SvgExportPlugin.info("Export size=" + iFigure.getSize());
        SvgExportPlugin.debug("ExportAction - 0  gc.getClipping()=" + this.myGC.getClipping());
        this.trace("ExportAction - 0  gc.getClipping()=" + this.myGC.getClipping());
        if (dimension == null) {
            this.svgSaver.setDimension(iFigure.getPreferredSize());
        } else {
            this.svgSaver.setDimension(dimension);
        }
        if (hyperLinkManager != null) {
            this.svgSaver.setHyperlinkManager(hyperLinkManager);
        }
        iFigure.paint((Graphics)this.svgSaver);
    }

    public void saveSVG() {
        this.myGC.dispose();
        this.svgSaver.save(this.myFileName);
    }

    private void trace(String string) {
        if (this.traceFilter != null && (this.traceFilter.equals(allCases) || this.traceFilter.equals(thisClassName))) {
            System.out.println("[SVGExporter] - " + string);
        }
    }
}

