/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.svgexport;

import com.togethersoft.selena.gde.svgexport.ExportDialog$1;
import com.togethersoft.selena.gde.svgexport.ExportDialog$2;
import com.togethersoft.selena.gde.svgexport.Messages;
import com.togethersoft.selena.gde.svgexport.SvgExportPlugin;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class ExportDialog
extends Dialog {
    private static final int SAVE_ID = 1025;
    private static final String HISTORY_LIST = "historyList";
    private static final int MAX_HISTORY_SIZE = 10;
    private static final String OPEN_IN_BROWSER = "";
    private IDialogSettings settings = SvgExportPlugin.getDefault().getDialogSettings();
    private String defaultFileName;
    private String currentFile;
    private boolean openInBrowser = false;
    private CCombo dest;
    private Button browse;
    private CCombo format;
    private Button openImage;

    public ExportDialog(Shell shell, String string) {
        super(shell);
        this.defaultFileName = string;
    }

    public IPath getPath() {
        return new Path(this.getCurrentPath());
    }

    public String getFileName() {
        return this.getCurrentFileName();
    }

    public boolean isOpenInBrowser() {
        return this.openInBrowser;
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            IPath iPath = this.getPath();
            String string = this.getFileName();
            IPath iPath2 = iPath.addTrailingSeparator().append(string);
            if (iPath2.toFile().exists()) {
                String string2 = Messages.getString("ExportDialog.File__1") + iPath2.toOSString() + Messages.getString("ExportDialog._already_exists._nDo_you_want_to_overwrite_it__2");
                MessageDialog messageDialog = new MessageDialog(this.getShell(), Messages.getString("ExportDialog.File_Exists_3"), Dialog.getImage((String)"dialog_question_image"), string2, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                if (messageDialog.open() == 1) {
                    return;
                }
            }
            this.openInBrowser = this.openImage.getSelection();
            this.saveSettings();
            this.setReturnCode(0);
            this.close();
        }
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ExportDialog.Export_Diagram_to_Image_4"));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, Messages.getString("ExportDialog.Save_5"), true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite composite) {
        String[] stringArray;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 11;
        gridLayout.marginWidth = 11;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("ExportDialog.Destination_file__6"));
        GridData gridData = new GridData(4);
        label.setLayoutData((Object)gridData);
        this.dest = new CCombo(composite2, 2048);
        this.dest.addModifyListener((ModifyListener)new ExportDialog$1(this));
        if (this.settings != null && (stringArray = this.settings.getArray(HISTORY_LIST)) != null) {
            this.dest.setItems(stringArray);
        }
        if (this.defaultFileName != null) {
            if (this.dest.getItemCount() == 0 || !this.dest.getItem(0).equals(this.defaultFileName)) {
                this.dest.add(this.defaultFileName, 0);
            }
            this.dest.setText(this.defaultFileName);
        }
        gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        this.dest.setLayoutData((Object)gridData);
        this.dest.setFocus();
        this.browse = new Button(composite2, 8);
        this.browse.setText(Messages.getString("ExportDialog.Browse..._7"));
        this.browse.addSelectionListener((SelectionListener)new ExportDialog$2(this));
        label = new Label(composite2, 0);
        label.setText(Messages.getString("ExportDialog.Image_format__10"));
        gridData = new GridData(4);
        label.setLayoutData((Object)gridData);
        this.format = new CCombo(composite2, 2056);
        this.format.setItems(new String[]{".svg"});
        this.format.select(0);
        gridData = new GridData(32);
        gridData.widthHint = 40;
        gridData.horizontalSpan = 2;
        this.format.setLayoutData((Object)gridData);
        this.openImage = new Button(composite2, 32);
        this.openImage.setText(Messages.getString("ExportDialog.Open_generated_image_in_browser_12"));
        if (this.settings != null) {
            this.openImage.setSelection(this.settings.getBoolean(OPEN_IN_BROWSER));
        }
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.openImage.setLayoutData((Object)gridData);
        return composite2;
    }

    private void updateButton() {
        Button button = this.getButton(1025);
        if (button != null) {
            button.setEnabled(this.canSave());
        }
    }

    private boolean canSave() {
        File file = this.getPath().toFile();
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        return this.getFileName().length() != 0;
    }

    private void saveSettings() {
        if (this.settings != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < this.dest.getItemCount() && n < 9) {
                arrayList.add(this.dest.getItem(n));
                ++n;
            }
            if (!arrayList.contains(this.currentFile)) {
                arrayList.add(0, this.currentFile);
            }
            this.settings.put(HISTORY_LIST, arrayList.toArray(new String[0]));
            this.settings.put(OPEN_IN_BROWSER, this.openImage.getSelection());
        }
    }

    private File getNearestExistingParent(File file) {
        if (file == null) {
            return null;
        }
        if (file.exists()) {
            return file;
        }
        return this.getNearestExistingParent(file.getParentFile());
    }

    private String getCurrentPath() {
        int n = this.getLastSeparatorIndex(this.currentFile);
        if (n == -1) {
            return OPEN_IN_BROWSER;
        }
        return this.currentFile.substring(0, n);
    }

    private String getCurrentFileName() {
        int n = this.getLastSeparatorIndex(this.currentFile);
        if (n == -1) {
            return this.currentFile;
        }
        if (n == this.currentFile.length() - 1) {
            return OPEN_IN_BROWSER;
        }
        return this.currentFile.substring(n + 1);
    }

    private int getLastSeparatorIndex(String string) {
        return Math.max(string.lastIndexOf("\\"), string.lastIndexOf("/"));
    }

    static String access$002(ExportDialog exportDialog, String string) {
        exportDialog.currentFile = string;
        return exportDialog.currentFile;
    }

    static CCombo access$100(ExportDialog exportDialog) {
        return exportDialog.dest;
    }

    static void access$200(ExportDialog exportDialog) {
        exportDialog.updateButton();
    }

    static String access$300(ExportDialog exportDialog) {
        return exportDialog.getCurrentFileName();
    }

    static String access$400(ExportDialog exportDialog) {
        return exportDialog.getCurrentPath();
    }

    static File access$500(ExportDialog exportDialog, File file) {
        return exportDialog.getNearestExistingParent(file);
    }
}

