/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class GraphicsConverter {
    private static HashMap myFontsMap = new HashMap();

    public static BufferedImage convertImage(Image image) {
        ImageData imageData = image.getImageData();
        org.eclipse.swt.graphics.Rectangle rectangle = image.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        RGB[] rGBArray = imageData.getRGBs();
        if (rGBArray == null) {
            PaletteData paletteData = imageData.palette;
            ImageData imageData2 = imageData.getTransparencyMask();
            int n = 0;
            while (n < rectangle.height) {
                int n2 = 0;
                while (n2 < rectangle.width) {
                    int n3 = imageData.getPixel(n2, n);
                    if (n3 != 0) {
                        int n4 = n3 & paletteData.redMask;
                        n4 = paletteData.redShift < 0 ? n4 >>> -paletteData.redShift : n4 << paletteData.redShift;
                        int n5 = n3 & paletteData.greenMask;
                        n5 = paletteData.greenShift < 0 ? n5 >>> -paletteData.greenShift : n5 << paletteData.greenShift;
                        int n6 = n3 & paletteData.blueMask;
                        n6 = paletteData.blueShift < 0 ? n6 >>> -paletteData.blueShift : n6 << paletteData.blueShift;
                        n3 = new Color(n4, n5, n6).getRGB();
                        bufferedImage.setRGB(n2, n, n3);
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < rectangle.width) {
                int n7 = 0;
                while (n7 < rectangle.height) {
                    int n8 = imageData.getPixel(n, n7);
                    RGB rGB = rGBArray[n8];
                    bufferedImage.setRGB(n, n7, new Color(rGB.red, rGB.green, rGB.blue).getRGB());
                    ++n7;
                }
                ++n;
            }
        }
        return bufferedImage;
    }

    public static Font convertFont(org.eclipse.swt.graphics.Font font) {
        FontData fontData = font.getFontData()[0];
        Font font2 = (Font)myFontsMap.get(fontData);
        if (font2 == null) {
            int n = 0;
            if ((fontData.getStyle() & 1) != 0) {
                n |= 1;
            }
            if ((fontData.getStyle() & 2) != 0) {
                n |= 2;
            }
            int n2 = fontData.getHeight() + 3;
            font2 = new Font(fontData.getName(), n, n2);
            myFontsMap.put(fontData, font2);
        }
        return font2;
    }

    public static void clearFonts() {
        myFontsMap.clear();
    }

    private org.eclipse.swt.graphics.Rectangle convertRectangle(Rectangle rectangle) {
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Rectangle convertRectangle(org.eclipse.swt.graphics.Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

