/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.gde.graphics;

import com.togethersoft.selena.gde.graphics.GraphicsConverter;
import com.togethersoft.selena.gde.svgexport.HyperLinkManager;
import com.togethersoft.selena.gde.svgexport.SvgExportPlugin;
import com.tssap.selena.gde.internal.GdePlugin;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.CachedImageHandlerPNGEncoder;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class D2dToSvgGraphics
extends SWTGraphics {
    private static final String[] VISIBILITY_PREFIXES = new String[]{"+", "-", "#"};
    private SVGGraphics2D mySvgGraphics;
    private GenericImageHandler image_Handler;
    private static final Rectangle DUMMY_RECTANGLE = new Rectangle();
    private static final BasicStroke SOLID_STROKE = new BasicStroke();
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{18.0f, 6.0f}, 0.0f);
    private int myMaxX;
    private int myMaxY;
    private org.eclipse.draw2d.geometry.Dimension myCanvasSize;
    private IPath fOutputPath;
    private final String IMAGE_PATH = "images";
    private HyperLinkManager links;
    private static final String thisClassName = "D2dToSvgGraphics";
    private static final String allCases = "*";
    private String traceFilter = Platform.getDebugOption((String)"com.togethersoft.selena.gde.svgexport/debug/filter");
    private SVGGeneratorContext ctx;
    private Document myFactory;
    private int translateX = 0;
    private int translateY = 0;

    public D2dToSvgGraphics(GC gC, org.eclipse.draw2d.geometry.Dimension dimension, IPath iPath) {
        super(gC);
        Object object;
        this.trace("Canvas size:" + dimension);
        this.myCanvasSize = dimension;
        this.fOutputPath = iPath == null ? Platform.getPluginStateLocation((Plugin)GdePlugin.getDefault()) : iPath;
        try {
            object = this.fOutputPath.append("images");
            if (!object.toFile().exists()) {
                object.toFile().mkdirs();
            }
            this.trace("Pic path: " + object.toOSString());
            this.image_Handler = new CachedImageHandlerPNGEncoder(object.toOSString(), "images");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = GenericDOMImplementation.getDOMImplementation();
        this.myFactory = object.createDocument(null, "svg", null);
        this.ctx = SVGGeneratorContext.createDefault((Document)this.myFactory);
        this.ctx.setGenericImageHandler(this.image_Handler);
        this.ctx.setComment("Generated by Together using Batik");
        this.mySvgGraphics = new SVGGraphics2D(this.ctx, false);
        this.setClipAbsolute(0, 0, 12000, 12000);
        super.setClip(new Rectangle(0, 0, 12000, 12000));
    }

    public void dispose() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mySvgGraphics.dispose();
        GraphicsConverter.clearFonts();
    }

    public void drawImage(org.eclipse.swt.graphics.Image image, int n, int n2) {
        this.mySvgGraphics.drawImage((Image)GraphicsConverter.convertImage(image), n, n2, null);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.setAWTColor(this.getForegroundColor());
        this.mySvgGraphics.drawLine(n, n2, n3, n4);
    }

    public void drawLine(Point point, Point point2) {
        this.mySvgGraphics.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public void drawOval(Rectangle rectangle) {
        this.setAWTColor(this.getForegroundColor());
        this.mySvgGraphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawPolygon(PointList pointList) {
        SvgExportPlugin.debug("DRAWPolygon");
        this.trace("DRAWPolygon");
        int n = pointList.size();
        Polygon polygon = new Polygon();
        int n2 = 0;
        while (n2 < n) {
            Point point = pointList.getPoint(n2);
            polygon.addPoint(point.x, point.y);
            ++n2;
        }
        this.setAWTColor(this.getForegroundColor());
        this.mySvgGraphics.drawPolygon(polygon);
    }

    public void drawPolyline(PointList pointList) {
        SvgExportPlugin.debug("DRAWPolyline");
        int n = pointList.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Point point = pointList.getPoint(n2);
            nArray[n2] = point.x;
            nArray2[n2] = point.y;
            this.trace("DRAWPolyline from " + nArray[n2] + ", to:" + nArray2[n2] + ", count:" + n2);
            ++n2;
        }
        this.setAWTColor(this.getForegroundColor());
        this.mySvgGraphics.drawPolyline(nArray, nArray2, n);
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        this.setAWTColor(this.getForegroundColor());
        this.mySvgGraphics.drawRect(n, n2, n3, n4);
    }

    public void drawRoundRectangle(Rectangle rectangle, int n, int n2) {
        this.setAWTColor(this.getForegroundColor());
        this.mySvgGraphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n2);
    }

    public void drawString(String string, int n, int n2, Graphics.TransparencyFlag transparencyFlag) {
        this.drawString(string, n, n2);
    }

    public void drawString(String string, int n, int n2) {
        this.setAWTColor(this.getForegroundColor());
        int n3 = n2 + this.mySvgGraphics.getFontMetrics().getAscent();
        this.mySvgGraphics.drawString(string, (float)n * 1.0f, (float)n3 * 1.0f);
    }

    public void drawText(String string, int n, int n2, Graphics.TransparencyFlag transparencyFlag) {
        this.drawText(string, n, n2);
    }

    public void drawText(String string, int n, int n2) {
        int n3 = string.indexOf("\n");
        if (n3 > -1 && n3 < string.length() - 1) {
            this.drawText(string.substring(0, n3), n, n2);
            int n4 = n2 + this.mySvgGraphics.getFontMetrics().getHeight();
            this.drawText(string.substring(n3 + 1, string.length()), n, n4);
            return;
        }
        if (this.getHyperlinkManager() != null) {
            String string2 = this.getHyperlinkManager().getHyperlink(this.removeVisibilityPrefix(string.trim()));
            if (string2 == null) {
                this.drawString(string, n, n2);
                return;
            }
            Element element = this.mySvgGraphics.getTopLevelGroup();
            Element element2 = this.mySvgGraphics.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "a");
            this.drawString(string, n, n2);
            Element element3 = this.mySvgGraphics.getTopLevelGroup();
            NodeList nodeList = element3.getChildNodes();
            while (nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                if (node instanceof Element) {
                    Element element4 = (Element)node;
                    element4.setAttributeNS(null, "onclick", "onclick=navigateTo('" + string2 + "')");
                }
                element2.appendChild(node);
            }
            element.appendChild(element2);
            this.mySvgGraphics.setTopLevelGroup(element);
        } else {
            this.drawString(string, n, n2);
        }
    }

    public void fillOval(Rectangle rectangle) {
        this.setAWTColor(this.getBackgroundColor());
        this.mySvgGraphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillPolygon(PointList pointList) {
        int n = pointList.size();
        Polygon polygon = new Polygon();
        int n2 = 0;
        while (n2 < n) {
            Point point = pointList.getPoint(n2);
            polygon.addPoint(point.x, point.y);
            ++n2;
        }
        this.setAWTColor(this.getBackgroundColor());
        this.mySvgGraphics.fillPolygon(polygon);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        this.setAWTColor(this.getBackgroundColor());
        this.mySvgGraphics.fillRect(n, n2, n3, n4);
    }

    public void fillRoundRectangle(Rectangle rectangle, int n, int n2) {
        this.setAWTColor(this.getBackgroundColor());
        this.mySvgGraphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n2);
    }

    protected void restoreState(SWTGraphics.State state) {
        super.restoreState(state);
        this.mySvgGraphics.translate(state.dx - this.translateX, state.dy - this.translateY);
        this.translateX = state.dx;
        this.translateY = state.dy;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.mySvgGraphics.setFont(GraphicsConverter.convertFont(font));
    }

    public void setLineStyle(int n) {
        SvgExportPlugin.debug("setLineStyle *! style=" + n);
        this.trace("setLineStyle *! style =" + n);
        super.setLineStyle(n);
        if (n == 1) {
            this.mySvgGraphics.setStroke((Stroke)SOLID_STROKE);
        } else if (n == 2) {
            this.mySvgGraphics.setStroke((Stroke)DASHED_STROKE);
        } else {
            this.mySvgGraphics.setStroke((Stroke)SOLID_STROKE);
        }
    }

    public void setXORMode(boolean bl) {
        SvgExportPlugin.debug("setXORMode flag=" + bl);
        this.trace("setXORMode flag=" + bl);
        super.setXORMode(bl);
        if (bl) {
            Color color = ColorConstants.red;
            this.mySvgGraphics.setXORMode(new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue()));
        } else {
            this.mySvgGraphics.setPaintMode();
        }
    }

    public void translate(int n, int n2) {
        SvgExportPlugin.debug("translate=");
        this.trace("translate=");
        super.translate(n, n2);
        this.mySvgGraphics.translate(n, n2);
    }

    protected void setTranslation(int n, int n2) {
        this.translateX = n;
        this.translateY = n2;
        super.setTranslation(n, n2);
    }

    public void save(String string) {
        if (string == null) {
            string = "out.svg";
        }
        this.trace("saving to file:" + this.fOutputPath.addTrailingSeparator().append(string));
        this.mySvgGraphics.setSVGCanvasSize(new Dimension(this.myCanvasSize.width, this.myCanvasSize.height));
        try {
            boolean bl = true;
            this.fOutputPath.toFile().mkdirs();
            File file = this.fOutputPath.addTrailingSeparator().append(string).toFile();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            this.mySvgGraphics.stream((Writer)outputStreamWriter, bl);
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDimension(org.eclipse.draw2d.geometry.Dimension dimension) {
        this.trace("Set Dimension to:" + dimension);
        this.myCanvasSize = dimension;
    }

    public void setHyperlinkManager(HyperLinkManager hyperLinkManager) {
        this.links = hyperLinkManager;
    }

    public HyperLinkManager getHyperlinkManager() {
        return this.links;
    }

    public void clipRect(Rectangle rectangle) {
        super.clipRect(rectangle);
        this.mySvgGraphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void setClipAbsolute(int n, int n2, int n3, int n4) {
        super.setClipAbsolute(n, n2, n3, n4);
        this.mySvgGraphics.setClip((Shape)new java.awt.Rectangle(n + this.translateX, n2 + this.translateY, n3, n4));
    }

    private void setAWTColor(Color color) {
        this.mySvgGraphics.setColor(new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue()));
    }

    private void trace(String string) {
        if (this.traceFilter != null && (this.traceFilter.equals(allCases) || this.traceFilter.equals(thisClassName))) {
            System.out.println("[D2dToSvgGraphics] - " + string);
        }
    }

    private String removeVisibilityPrefix(String string) {
        int n = 0;
        while (n < VISIBILITY_PREFIXES.length) {
            if (string.startsWith(VISIBILITY_PREFIXES[n])) {
                return string.substring(VISIBILITY_PREFIXES[n].length());
            }
            ++n;
        }
        return string;
    }
}

