/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.ui.view;

import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.ModelUtilPlugin;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.FilterManager;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IFilterManager;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.selena.model.extension.ui.view.SimpleSelectionConverter;
import com.tssap.util.UtilPlugin;
import com.tssap.util.action.path.ContextDependentPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class DataModelView
extends ViewPart {
    protected static String FILTER_NAME_ALL = "All";
    protected static String FILTER_NAME_NOTHING = "Nothing";
    private GenericDataModelFilteredTreeViewer treeViewer;
    private IFilterManager filterManager;

    public DataModelView() {
        this.initFilterManager();
    }

    protected void initFilterManager() {
        this.filterManager = new FilterManager();
        IFilter yesFilter = FilterFactory.createDefaultYesManFilter();
        yesFilter.setName(FILTER_NAME_ALL);
        this.filterManager.addFilter(yesFilter);
        IFilter noFilter = FilterFactory.createDefaultNoManFilter();
        noFilter.setName(FILTER_NAME_NOTHING);
        this.filterManager.addFilter(noFilter);
    }

    public void createPartControl(Composite parent) {
        GenericDataModelFilteredTreeViewer viewer = GenericDataModelFilteredTreeViewer.createFilteredTreeViewer(parent);
        viewer.setDissolveReferences(true);
        this.setTreeViewer(viewer);
        SimpleSelectionConverter converter = new SimpleSelectionConverter((ISelectionProvider)viewer.getTreeViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)converter);
        this.createFilterMenu();
        this.createToolBar();
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new ContextDependentPathProvider(false));
        DynamicContextMenu contextMenu = new DynamicContextMenu((IMenuFactory)menuFactory);
        this.getTreeViewer().setContextMenu((IContextMenu)contextMenu);
    }

    public void setFocus() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setFocus();
        }
    }

    protected GenericDataModelFilteredTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void setTreeViewer(GenericDataModelFilteredTreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    protected IFilterManager getFilterManager() {
        return this.filterManager;
    }

    private void createToolBar() {
        final IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = new Action(){

            public void run() {
                DataModelView.this.getTreeViewer().refresh();
            }
        };
        refreshAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_REFRESH));
        refreshAction.setToolTipText("Refresh");
        toolBarManager.add((IAction)refreshAction);
        Action setNodesAsRootsAction = new Action(){

            public void run() {
                PropertyMap[] roots = ModelUtilPlugin.computeModels();
                DataModelView.this.getTreeViewer().setRoots(roots);
            }
        };
        setNodesAsRootsAction.setToolTipText("Set All Models As Roots");
        setNodesAsRootsAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_DISPLAY_TREE));
        toolBarManager.add((IAction)setNodesAsRootsAction);
        Action setModelsAsRootsAction = new Action(){

            public void run() {
                TreeItem[] selectedItems = DataModelView.this.getTreeViewer().getTree().getSelection();
                Vector<Object> newRootVec = new Vector<Object>();
                int i = 0;
                while (i < selectedItems.length) {
                    TreeItem treeItem = selectedItems[i];
                    Object treeItemData = treeItem.getData();
                    if (treeItemData instanceof PropertyMap) {
                        newRootVec.add(treeItemData);
                    }
                    ++i;
                }
                if (newRootVec.size() > 0) {
                    DataModelView.this.getTreeViewer().setRoots(newRootVec.toArray(new PropertyMap[newRootVec.size()]));
                }
            }
        };
        setModelsAsRootsAction.setToolTipText("Set Selected Node As Root");
        setModelsAsRootsAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_DBOM_SUB_ITEM));
        toolBarManager.add((IAction)setModelsAsRootsAction);
        Action toggleOptimisticChildrenCheckAction = new Action(){

            public void run() {
                boolean currentValue = DataModelView.this.getTreeViewer().isOptimisticChildrenCheck();
                DataModelView.this.getTreeViewer().setOptimisticChildrenCheck(!currentValue);
                this.setChecked(currentValue);
                toolBarManager.update(true);
            }

            public boolean isChecked() {
                boolean ret = DataModelView.this.getTreeViewer().isOptimisticChildrenCheck();
                return ret;
            }

            public int getStyle() {
                return 2;
            }

            public String getToolTipText() {
                String ret = "able Optimistic Children Check";
                ret = this.isChecked() ? "Dis" + ret : "En" + ret;
                return ret;
            }
        };
        toggleOptimisticChildrenCheckAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_POSITIVE));
        toolBarManager.add((IAction)toggleOptimisticChildrenCheckAction);
        Action toggleExpandSingleChildAutomaticallyAction = new Action(){

            public void run() {
                boolean currentValue = DataModelView.this.getTreeViewer().isExpandSingleChildAutomatically();
                DataModelView.this.getTreeViewer().setExpandSingleChildAutomatically(!currentValue);
                this.setChecked(currentValue);
                toolBarManager.update(true);
            }

            public boolean isChecked() {
                boolean ret = DataModelView.this.getTreeViewer().isExpandSingleChildAutomatically();
                return ret;
            }

            public int getStyle() {
                return 2;
            }

            public String getToolTipText() {
                String ret = "able Automatic Single Child Expand";
                ret = this.isChecked() ? "Dis" + ret : "En" + ret;
                return ret;
            }
        };
        toggleExpandSingleChildAutomaticallyAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_NEXT_NODE));
        toolBarManager.add((IAction)toggleExpandSingleChildAutomaticallyAction);
        Action toggleDissolveReferencesAction = new Action(){

            public void run() {
                boolean currentValue = DataModelView.this.getTreeViewer().isDissolveReferences();
                DataModelView.this.getTreeViewer().setDissolveReferences(!currentValue);
                this.setChecked(currentValue);
                toolBarManager.update(true);
            }

            public boolean isChecked() {
                boolean ret = DataModelView.this.getTreeViewer().isDissolveReferences();
                return ret;
            }

            public int getStyle() {
                return 2;
            }

            public String getToolTipText() {
                String ret = "able Reference Dissolving";
                ret = this.isChecked() ? "Dis" + ret : "En" + ret;
                return ret;
            }
        };
        toggleDissolveReferencesAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_NEXT_STEP));
        toolBarManager.add((IAction)toggleDissolveReferencesAction);
        Action toggleSkipReferenceCollectionsAction = new Action(){

            public void run() {
                boolean currentValue = DataModelView.this.getTreeViewer().isSkipReferenceCollections();
                DataModelView.this.getTreeViewer().setSkipReferenceCollections(!currentValue);
                this.setChecked(currentValue);
                toolBarManager.update(true);
            }

            public boolean isChecked() {
                boolean ret = DataModelView.this.getTreeViewer().isSkipReferenceCollections();
                return ret;
            }

            public int getStyle() {
                return 2;
            }

            public String getToolTipText() {
                String ret = "able Skipping Reference Collections";
                ret = this.isChecked() ? "Dis" + ret : "En" + ret;
                return ret;
            }
        };
        toggleSkipReferenceCollectionsAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_REFERENCE_LIST));
        toolBarManager.add((IAction)toggleSkipReferenceCollectionsAction);
        Action toggleSkipReferencesAction = new Action(){

            public void run() {
                boolean currentValue = DataModelView.this.getTreeViewer().isSkipReferences();
                DataModelView.this.getTreeViewer().setSkipReferences(!currentValue);
                this.setChecked(currentValue);
                toolBarManager.update(true);
            }

            public boolean isChecked() {
                boolean ret = DataModelView.this.getTreeViewer().isSkipReferences();
                return ret;
            }

            public int getStyle() {
                return 2;
            }

            public String getToolTipText() {
                String ret = "able Skipping References";
                ret = this.isChecked() ? "Dis" + ret : "En" + ret;
                return ret;
            }
        };
        toggleSkipReferencesAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_ARROW_RIGHT));
        toolBarManager.add((IAction)toggleSkipReferencesAction);
        Action collapseAllAction = new Action(){

            public void run() {
                DataModelView.this.getTreeViewer().getTreeViewer().collapseAll();
            }
        };
        collapseAllAction.setImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((String)UtilPlugin.getPluginId(), (String)"collapseall.gif"));
        collapseAllAction.setToolTipText("Collapse All");
        toolBarManager.add((IAction)collapseAllAction);
    }

    private void createFilterMenu() {
        final IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        IFilter[] filters = this.getFilterManager().getFilters();
        int i = 0;
        while (i < filters.length) {
            final IFilter iFilter = filters[i];
            String iFilterName = iFilter.getName();
            Action iFilterAction = new Action(iFilterName){

                public void run() {
                    DataModelView.this.getTreeViewer().setFilter(iFilter);
                    menuManager.markDirty();
                    menuManager.update();
                }

                public boolean isChecked() {
                    boolean ret = DataModelView.this.getTreeViewer().getFilter().equals(iFilter);
                    return ret;
                }
            };
            if (i == 0) {
                iFilterAction.setChecked(true);
            } else {
                iFilterAction.setChecked(false);
            }
            menuManager.add((IAction)iFilterAction);
            ++i;
        }
        menuManager.add((IContributionItem)new Separator());
    }
}

