/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.ui.treeviewer;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.ModelUtilPlugin;
import com.tssap.selena.model.extension.ui.treeviewer.DataModelTreeContentProvider;
import com.tssap.selena.model.extension.ui.treeviewer.DataModelTreeLabelProvider;
import com.tssap.selena.model.extension.ui.treeviewer.DataModelTreeViewerUpdater;
import com.tssap.selena.model.extension.ui.treeviewer.IDataModelTreeViewer;
import com.tssap.util.ui.viewer.sorter.NameSorter;
import com.tssap.util.ui.viewer.tree.SapAbstractTreeViewer;
import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class GenericDataModelTreeViewer
extends SapAbstractTreeViewer
implements IDataModelTreeViewer {
    private boolean updateOnWholeModel = true;
    static final boolean ANALYTIC = false;
    private DataModelTreeViewerUpdater myModelUpdater;
    private DisposeListener disposeListener;

    protected GenericDataModelTreeViewer(Composite parent, PropertyMap[] roots, boolean dissolveReferences, boolean singleSelection) {
        this(parent, singleSelection);
        this.init(roots);
        this.setDissolveReferences(dissolveReferences);
        this.getTreeViewer().setInput((Object)roots);
    }

    protected GenericDataModelTreeViewer(Composite parent, PropertyMap[] roots, boolean dissolveReferences) {
        this(parent);
        this.init(roots);
        this.setDissolveReferences(dissolveReferences);
        this.getTreeViewer().setInput((Object)roots);
    }

    protected GenericDataModelTreeViewer(Composite parent, PropertyMap[] roots) {
        this(parent);
        this.init(roots);
        this.getTreeViewer().setInput((Object)roots);
    }

    protected GenericDataModelTreeViewer(Composite parent) {
        super(parent);
        this.getTreeViewer().setSorter((ViewerSorter)new NameSorter());
    }

    protected GenericDataModelTreeViewer(Composite parent, boolean singleSelection) {
        super(parent, singleSelection);
        this.getTreeViewer().setSorter((ViewerSorter)new NameSorter());
    }

    protected void init(PropertyMap[] roots) {
        this.getTreeViewer().setContentProvider((IContentProvider)new DataModelTreeContentProvider(roots));
        this.registerForChangeEventsOnRootModels(roots);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new DataModelTreeLabelProvider());
    }

    public static GenericDataModelTreeViewer createTreeViewer(Composite parent) {
        GenericDataModelTreeViewer ret = GenericDataModelTreeViewer.createTreeViewer(parent, ModelUtilPlugin.computeModels());
        return ret;
    }

    public static GenericDataModelTreeViewer createTreeViewer(Composite parent, PropertyMap[] roots) {
        GenericDataModelTreeViewer ret = new GenericDataModelTreeViewer(parent, roots);
        return ret;
    }

    public void setRoots(PropertyMap[] roots, boolean refresh) {
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            dataModelTreeContentProvider.setRoots(roots);
            if (refresh) {
                this.refresh();
            }
        } else {
            this.getTreeViewer().setContentProvider((IContentProvider)new DataModelTreeContentProvider(roots));
        }
    }

    public void setRoots(PropertyMap[] roots) {
        this.setRoots(roots, true);
    }

    public PropertyMap[] getRoots() {
        PropertyMap[] ret = new PropertyMap[]{};
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            ret = dataModelTreeContentProvider.getRoots();
        }
        return ret;
    }

    public void addRoot(PropertyMap root) {
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            dataModelTreeContentProvider.addRoot(root);
            this.refresh();
        }
    }

    public void removeRoot(PropertyMap root) {
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            dataModelTreeContentProvider.removeRoot(root);
            this.refresh();
        }
    }

    private void registerForChangeEventsOnRootModels(PropertyMap[] roots) {
        Vector<Model> modelsVec = new Vector<Model>();
        int i = 0;
        while (i < roots.length) {
            Element element;
            Model model;
            PropertyMap propertyMap = roots[i];
            if (propertyMap instanceof Element && !modelsVec.contains(model = (element = (Element)propertyMap).getModel())) {
                modelsVec.add(model);
            }
            ++i;
        }
        Model[] models = new Model[]{};
        models = modelsVec.toArray(models);
        if (this.myModelUpdater != null) {
            this.myModelUpdater.unregister();
        }
        this.myModelUpdater = new DataModelTreeViewerUpdater(this, models, this.updateOnWholeModel);
        this.getTree().addDisposeListener(this.getDisposeListener());
    }

    public boolean isDissolveReferences() {
        boolean ret = false;
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            ret = dataModelTreeContentProvider.isDissolveReferences();
        }
        return ret;
    }

    public void setDissolveReferences(boolean dissolveReferences, boolean refresh) {
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            boolean oldValue = this.isDissolveReferences();
            if (oldValue != dissolveReferences) {
                dataModelTreeContentProvider.setDissolveReferences(dissolveReferences);
                if (refresh) {
                    this.refresh();
                }
            }
        }
    }

    public void setDissolveReferences(boolean dissolveReferences) {
        this.setDissolveReferences(dissolveReferences, true);
    }

    public boolean isSkipReferences() {
        boolean ret = false;
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            ret = dataModelTreeContentProvider.isSkipReferences();
        }
        return ret;
    }

    public void setSkipReferences(boolean skipReferences, boolean refresh) {
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            boolean oldValue = this.isSkipReferences();
            if (oldValue != skipReferences) {
                dataModelTreeContentProvider.setSkipReferences(skipReferences);
                if (refresh) {
                    this.refresh();
                }
            }
        }
    }

    public void setSkipReferences(boolean skipReferences) {
        this.setSkipReferences(skipReferences, true);
    }

    public boolean isSkipReferenceCollections() {
        boolean ret = false;
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            ret = dataModelTreeContentProvider.isSkipReferenceCollections();
        }
        return ret;
    }

    public void setSkipReferenceCollections(boolean skipReferenceCollections, boolean refresh) {
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            boolean oldValue = this.isSkipReferenceCollections();
            if (oldValue != skipReferenceCollections) {
                dataModelTreeContentProvider.setSkipReferenceCollections(skipReferenceCollections);
                if (refresh) {
                    this.refresh();
                }
            }
        }
    }

    public void setSkipReferenceCollections(boolean skipReferenceCollections) {
        this.setSkipReferenceCollections(skipReferenceCollections, true);
    }

    public boolean isOptimisticChildrenCheck() {
        boolean ret = false;
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            ret = dataModelTreeContentProvider.isOptimisticChildrenCheck();
        }
        return ret;
    }

    public void setOptimisticChildrenCheck(boolean optimisticChildrenCheck, boolean refresh) {
        IContentProvider contentProvider = this.getTreeViewer().getContentProvider();
        if (contentProvider instanceof DataModelTreeContentProvider) {
            DataModelTreeContentProvider dataModelTreeContentProvider = (DataModelTreeContentProvider)contentProvider;
            boolean oldValue = this.isOptimisticChildrenCheck();
            if (oldValue != optimisticChildrenCheck) {
                dataModelTreeContentProvider.setOptimisticChildrenCheck(optimisticChildrenCheck);
                if (!optimisticChildrenCheck && refresh) {
                    this.refresh();
                }
            }
        }
    }

    public void setOptimisticChildrenCheck(boolean optimisticChildrenCheck) {
        this.setOptimisticChildrenCheck(optimisticChildrenCheck, true);
    }

    private DisposeListener getDisposeListener() {
        if (this.disposeListener == null) {
            this.disposeListener = new MyDisposeListener();
        }
        return this.disposeListener;
    }

    public boolean isUpdateOnWholeModel() {
        return this.updateOnWholeModel;
    }

    public void setUpdateOnWholeModel(boolean b) {
        this.updateOnWholeModel = b;
        if (this.myModelUpdater != null) {
            this.myModelUpdater.setRefreshOnWholeModel(b);
        }
    }

    private class MyDisposeListener
    implements DisposeListener {
        private MyDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            GenericDataModelTreeViewer.this.myModelUpdater.unregister();
        }
    }
}

