/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.ui.treeviewer;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.ui.treeviewer.IDataModelTreeViewer;
import com.tssap.util.UtilPlugin;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DataModelTreeViewerUpdater
implements ModelAccessListener,
ModelChangeListener,
Listener {
    private static final TracerI T = TracingManager.getTracer((Class)(class$com$tssap$selena$model$extension$ui$treeviewer$DataModelTreeViewerUpdater == null ? (class$com$tssap$selena$model$extension$ui$treeviewer$DataModelTreeViewerUpdater = DataModelTreeViewerUpdater.class$("com.tssap.selena.model.extension.ui.treeviewer.DataModelTreeViewerUpdater")) : class$com$tssap$selena$model$extension$ui$treeviewer$DataModelTreeViewerUpdater));
    private boolean needUpdate = false;
    private boolean updateModels = true;
    private boolean updateModelContent = true;
    private boolean refreshOnWholeModel = true;
    private IDataModelTreeViewer treeViewer;
    private ArrayList myKnownModels = new ArrayList();
    static /* synthetic */ Class class$com$tssap$selena$model$extension$ui$treeviewer$DataModelTreeViewerUpdater;

    public DataModelTreeViewerUpdater(IDataModelTreeViewer treeViewer, Model[] models) {
        this.myKnownModels.addAll(Arrays.asList(models));
        this.setTreeViewer(treeViewer);
        int i = 0;
        while (i < models.length) {
            Model model = models[i];
            model.addModelDeltaListener((ModelChangeListener)this);
            ++i;
        }
        ModelAccess.addModelAccessListener((ModelAccessListener)this);
        treeViewer.getTree().addListener(9, (Listener)this);
    }

    public DataModelTreeViewerUpdater(IDataModelTreeViewer treeViewer, Model[] models, boolean refreshOnWholeModel) {
        this(treeViewer, models);
        this.refreshOnWholeModel = refreshOnWholeModel;
    }

    public void unregister() {
        Model[] models = this.myKnownModels.toArray(new Model[this.myKnownModels.size()]);
        int i = 0;
        while (i < models.length) {
            Model model = models[i];
            model.removeModelDeltaListener((ModelChangeListener)this);
            ++i;
        }
        ModelAccess.removeModelAccessListener((ModelAccessListener)this);
    }

    public void modelCreated(ModelAccessEvent event) {
        final Model model = event.getModel();
        if (this.isUpdateModels()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DataModelTreeViewerUpdater.this.getTreeViewer().addRoot((PropertyMap)model);
                }
            });
        }
        model.addModelDeltaListener((ModelChangeListener)this);
        this.myKnownModels.add(model);
    }

    public void modelRemoved(ModelAccessEvent event) {
        final Model model = event.getModel();
        if (this.isUpdateModels()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DataModelTreeViewerUpdater.this.getTreeViewer().removeRoot((PropertyMap)model);
                }
            });
        }
        model.removeModelDeltaListener((ModelChangeListener)this);
        ((AbstractCollection)this.myKnownModels).remove(model);
    }

    public void modelChanged(ModelChangeEvent changeEvent) {
        if (this.getTreeViewer().getTree().isVisible()) {
            if (this.isUpdateModelContent()) {
                boolean totallyChanged = changeEvent.getRootDelta().isTotallyChanged();
                Runnable worker = null;
                worker = totallyChanged ? new RefreshTreeStructureWorker() : new RefreshTreeStructureAndLabelsWorker(changeEvent);
                try {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)worker);
                }
                catch (RuntimeException e) {
                    T.warning("modelChanged(final ModelChangeEvent changeEvent)", "Exception ignored to secure the model changed propagation to ALL listeners.", (Throwable)e);
                }
            }
        } else {
            this.needUpdate = true;
        }
    }

    public IDataModelTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void setTreeViewer(IDataModelTreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public boolean isUpdateModelContent() {
        return this.updateModelContent;
    }

    public boolean isUpdateModels() {
        return this.updateModels;
    }

    public void setUpdateModelContent(boolean updateModelContent) {
        this.updateModelContent = updateModelContent;
    }

    public void setUpdateModels(boolean updateModels) {
        this.updateModels = updateModels;
    }

    boolean isRefreshOnWholeModel() {
        return this.refreshOnWholeModel;
    }

    void setRefreshOnWholeModel(boolean b) {
        this.refreshOnWholeModel = b;
    }

    public void handleEvent(Event event) {
        if (event.type == 9 && this.getTreeViewer().getTree().isVisible() && this.needUpdate) {
            try {
                RefreshTreeStructureWorker worker = new RefreshTreeStructureWorker();
                this.needUpdate = false;
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)worker);
            }
            catch (Throwable th) {
                UtilPlugin.getTracer().warning(this.getClass(), "handleEvent(Event event)", "Exception during tree refresh", th);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RefreshTreeStructureAndLabelsWorker
    implements Runnable {
        private ModelChangeEvent changeEvent;

        public RefreshTreeStructureAndLabelsWorker(ModelChangeEvent changeEvent) {
            this.changeEvent = changeEvent;
        }

        public void run() {
            TreeViewer treeViewer = DataModelTreeViewerUpdater.this.getTreeViewer().getTreeViewer();
            if (treeViewer != null) {
                if (DataModelTreeViewerUpdater.this.refreshOnWholeModel) {
                    Model model = this.changeEvent.getModel();
                    treeViewer.refresh((Object)model, true);
                } else {
                    Enumeration children = this.changeEvent.getRootDelta().changedChildren();
                    while (children.hasMoreElements()) {
                        ModelDeltaNode modelDeltaNode = (ModelDeltaNode)children.nextElement();
                        Element element = modelDeltaNode.getElement();
                        if (element == null) continue;
                        if (modelDeltaNode.isTotallyChanged()) {
                            treeViewer.refresh((Object)element, true);
                            continue;
                        }
                        if (modelDeltaNode.isChanged()) {
                            treeViewer.update((Object)element, null);
                            continue;
                        }
                        if (modelDeltaNode.isDeleted() || modelDeltaNode.isNew()) {
                            treeViewer.refresh((Object)element.getParent(), true);
                            continue;
                        }
                        treeViewer.refresh((Object)element, true);
                    }
                }
            }
        }
    }

    public class RefreshTreeStructureWorker
    implements Runnable {
        public void run() {
            TreeViewer treeViewer = DataModelTreeViewerUpdater.this.getTreeViewer().getTreeViewer();
            if (treeViewer != null) {
                treeViewer.refresh(true);
            }
        }
    }
}

