/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.ui.treeviewer;

import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.extension.filter.elements.FilterUtil;
import com.tssap.selena.model.extension.ui.treeviewer.DataModelTCPHelper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class DataModelTreeContentProvider
implements ITreeContentProvider {
    private static final TracerI T = TracingManager.getTracer((Class)(class$com$tssap$selena$model$extension$ui$treeviewer$DataModelTreeContentProvider == null ? (class$com$tssap$selena$model$extension$ui$treeviewer$DataModelTreeContentProvider = DataModelTreeContentProvider.class$("com.tssap.selena.model.extension.ui.treeviewer.DataModelTreeContentProvider")) : class$com$tssap$selena$model$extension$ui$treeviewer$DataModelTreeContentProvider));
    static final boolean DEFAULT_IS_DISSOLVE_REFERENCES = false;
    static final boolean DEFAULT_IS_SKIP_REFERENCE_COLLECTIONS = false;
    static final boolean DEFAULT_IS_SKIP_REFERENCES = false;
    static final boolean DEFAULT_OPTIMISTIC_CHILDREN_CHECK = false;
    private Vector rootsVector = new Vector();
    private boolean dissolveReferences = false;
    private boolean skipReferenceCollections = false;
    private boolean skipReferences = false;
    private boolean optimisticChildrenCheck = false;
    boolean hasGetChildrenWorker = false;
    boolean hasHasChildrenWorker = false;
    static /* synthetic */ Class class$com$tssap$selena$model$extension$ui$treeviewer$DataModelTreeContentProvider;

    public DataModelTreeContentProvider(PropertyMap[] roots) {
        if (roots != null) {
            this.setRoots(roots);
        }
    }

    public Object getParent(Object child) {
        long enter = 0L;
        if (T.path()) {
            T.path("Object getParent(Object child)", "enter (child = " + child.toString() + ")");
            enter = System.currentTimeMillis();
        }
        Element ret = null;
        if (child instanceof Element) {
            Element childElement;
            Element parent = childElement = (Element)child;
            do {
                parent = parent.getParent();
                Object[] parentsChildren = this.getChildren(parent);
                int i = 0;
                while (ret == null && i < parentsChildren.length) {
                    Element parentsChildElement;
                    if (parentsChildren[i] instanceof Element && (parentsChildElement = (Element)parentsChildren[i]).equals(child)) {
                        ret = parent;
                    }
                    ++i;
                }
            } while (ret == null && parent != null && parent.getParent() != null);
        }
        if (T.path()) {
            T.path("Object getParent(Object child)", "leave(whole method took " + (System.currentTimeMillis() - enter) + " ms)");
        }
        return ret;
    }

    public boolean hasChildren(Object parentObject) {
        long enter = 0L;
        if (T.path()) {
            T.path("boolean hasChildren(Object parentObject)", "enter (parentObject = " + parentObject.toString() + ")");
            enter = System.currentTimeMillis();
        }
        boolean ret = true;
        if (DataModelTCPHelper.canHandleHasChildren(parentObject)) {
            ret = DataModelTCPHelper.hasChildren(parentObject);
        } else if (!this.isOptimisticChildrenCheck()) {
            if (!this.hasGetChildrenWorker) {
                this.hasGetChildrenWorker = true;
                HasChildrenWorker worker = new HasChildrenWorker(parentObject);
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)worker);
                ret = worker.result != null;
                this.hasGetChildrenWorker = false;
            } else {
                ret = this.hasChildrenInternal(parentObject);
            }
        }
        if (T.path()) {
            T.path("boolean hasChildren(Object parentObject)", "leave(whole method took " + (System.currentTimeMillis() - enter) + " ms)");
        }
        return ret;
    }

    private boolean hasChildrenInternal(Object parentObject) {
        boolean ret;
        block13: {
            block11: {
                block12: {
                    ret = false;
                    if (!this.isDissolveReferences()) break block11;
                    if (!(parentObject instanceof Reference)) break block12;
                    Reference parentReference = (Reference)parentObject;
                    Entity childEntity = FilterUtil.getEntity(parentReference);
                    if (this.isEntity(parentReference, childEntity) && (this.isSkipEntity(parentReference, childEntity) ? this.hasChildren(childEntity) : childEntity != null)) {
                        return true;
                    }
                    break block13;
                }
                if (!(parentObject instanceof Container)) break block13;
                Container parentContainer = (Container)parentObject;
                Entity[] childEntityArray = FilterUtil.getChildEntities(parentContainer);
                int i = 0;
                while (i < childEntityArray.length) {
                    Entity childEntity = childEntityArray[i];
                    if (this.isChildEntity(parentContainer, childEntity) && (this.isSkipChildEntity(parentContainer, childEntity) ? this.hasChildren(childEntity) : childEntity != null)) {
                        return true;
                    }
                    ++i;
                }
                ReferenceCollection[] childReferenceCollectionArray = FilterUtil.getChildReferenceCollections(parentContainer);
                int i2 = 0;
                while (i2 < childReferenceCollectionArray.length) {
                    ReferenceCollection childReferenceCollection = childReferenceCollectionArray[i2];
                    if (this.isChildReferenceCollection(parentContainer, childReferenceCollection) && (this.isSkipChildReferenceCollection(parentContainer, childReferenceCollection) ? this.hasChildren(childReferenceCollection) : childReferenceCollection != null)) {
                        return true;
                    }
                    ++i2;
                }
                if (parentContainer instanceof ReferenceCollection) {
                    ReferenceCollection parentReferenceCollection = (ReferenceCollection)parentContainer;
                    Reference[] childrenReferenceArray = FilterUtil.getReferences(parentReferenceCollection);
                    int i3 = 0;
                    while (i3 < childrenReferenceArray.length) {
                        Reference childrenReference = childrenReferenceArray[i3];
                        if (this.isReference(parentReferenceCollection, childrenReference) && (this.isSkipReference(parentReferenceCollection, childrenReference) ? this.hasChildren(childrenReference) : childrenReference != null)) {
                            return true;
                        }
                        ++i3;
                    }
                }
                break block13;
            }
            if (parentObject instanceof Container) {
                Container parentContainer = (Container)parentObject;
                Entity[] childrenArray = FilterUtil.getChildEntities(parentContainer);
                int i = 0;
                while (i < childrenArray.length) {
                    Entity childEntity = childrenArray[i];
                    if (this.isChildEntity(parentContainer, childEntity) && childEntity != null) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return ret;
    }

    public Object[] getChildren(Object parentObject) {
        long enter = 0L;
        if (T.path()) {
            T.path("Object[] getChildren(Object parentObject)", "enter (parentObject = " + parentObject.toString() + ")");
            enter = System.currentTimeMillis();
        }
        Object[] ret = new Object[]{};
        if (!this.hasGetChildrenWorker) {
            this.hasGetChildrenWorker = true;
            GetChildrenWorker worker = new GetChildrenWorker(parentObject);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)worker);
            ret = worker.result;
            this.hasGetChildrenWorker = false;
        } else {
            ret = this.getChildrenInternal(parentObject);
        }
        if (T.debug()) {
            T.debug("Object[] getChildren(Object parentObject)", ret.length + " children found:");
            int i = 0;
            while (i < ret.length) {
                Object child = ret[i];
                T.debug("Object[] getChildren(Object parentObject)", child.toString());
                ++i;
            }
        }
        if (T.path()) {
            T.path("Object[] getChildren(Object parentObject)", "leave");
        }
        return ret;
    }

    private Object[] getChildrenInternal(Object parentObject) {
        if (T.path()) {
            T.path("Object[] getChildrenInternal(Object parentObject)", "enter");
        }
        Object[] ret = new Object[]{};
        Vector<Object> childVector = new Vector<Object>();
        if (this.isDissolveReferences()) {
            if (parentObject instanceof Reference) {
                Reference parentReference = (Reference)parentObject;
                Entity childEntity = FilterUtil.getEntity(parentReference);
                if (this.isEntity(parentReference, childEntity)) {
                    if (this.isSkipEntity(parentReference, childEntity)) {
                        Object[] children = this.getChildren(childEntity);
                        childVector.addAll(Arrays.asList(children));
                    } else {
                        childVector.add(childEntity);
                    }
                }
            } else if (parentObject instanceof Container) {
                Container parentContainer = (Container)parentObject;
                Entity[] childEntityArray = FilterUtil.getChildEntities(parentContainer);
                int i = 0;
                while (i < childEntityArray.length) {
                    Entity childEntity = childEntityArray[i];
                    if (this.isChildEntity(parentContainer, childEntity)) {
                        if (this.isSkipChildEntity(parentContainer, childEntity)) {
                            Object[] children = this.getChildren(childEntity);
                            childVector.addAll(Arrays.asList(children));
                        } else {
                            childVector.add(childEntity);
                        }
                    }
                    ++i;
                }
                ReferenceCollection[] childReferenceCollectionArray = FilterUtil.getChildReferenceCollections(parentContainer);
                int i2 = 0;
                while (i2 < childReferenceCollectionArray.length) {
                    ReferenceCollection childReferenceCollection = childReferenceCollectionArray[i2];
                    if (this.isChildReferenceCollection(parentContainer, childReferenceCollection)) {
                        if (this.isSkipChildReferenceCollection(parentContainer, childReferenceCollection)) {
                            Object[] children = this.getChildren(childReferenceCollection);
                            childVector.addAll(Arrays.asList(children));
                        } else {
                            childVector.add(childReferenceCollection);
                        }
                    }
                    ++i2;
                }
                if (parentContainer instanceof ReferenceCollection) {
                    ReferenceCollection parentReferenceCollection = (ReferenceCollection)parentContainer;
                    Reference[] childrenReferenceArray = FilterUtil.getReferences(parentReferenceCollection);
                    int i3 = 0;
                    while (i3 < childrenReferenceArray.length) {
                        Reference childrenReference = childrenReferenceArray[i3];
                        if (this.isReference(parentReferenceCollection, childrenReference)) {
                            if (this.isSkipReference(parentReferenceCollection, childrenReference)) {
                                Object[] children = this.getChildren(childrenReference);
                                childVector.addAll(Arrays.asList(children));
                            } else {
                                childVector.add(childrenReference);
                            }
                        }
                        ++i3;
                    }
                }
            }
        } else if (parentObject instanceof Container) {
            Container parentContainer = (Container)parentObject;
            Entity[] childrenArray = FilterUtil.getChildEntities(parentContainer);
            int i = 0;
            while (i < childrenArray.length) {
                Entity childEntity = childrenArray[i];
                if (this.isChildEntity(parentContainer, childEntity)) {
                    childVector.add(childEntity);
                }
                ++i;
            }
        }
        ret = childVector.toArray(ret);
        if (T.path()) {
            T.path("Object[] getChildrenInternal(Object parentObject)", "leave");
        }
        return ret;
    }

    protected boolean isChildEntity(Container parentContainer, Entity childEntity) {
        return true;
    }

    protected boolean isSkipChildEntity(Container parentContainer, Entity childEntity) {
        return childEntity instanceof ReferenceCollection && this.isSkipReferenceCollections();
    }

    protected boolean isChildReferenceCollection(Container parentContainer, ReferenceCollection childReferenceCollection) {
        return true;
    }

    protected boolean isSkipChildReferenceCollection(Container parentContainer, ReferenceCollection childReferenceCollection) {
        return this.isSkipReferenceCollections();
    }

    protected boolean isReference(ReferenceCollection parentReferenceCollection, Reference childReference) {
        return true;
    }

    protected boolean isSkipReference(ReferenceCollection parentReferenceCollection, Reference childReference) {
        return this.isSkipReferences();
    }

    protected boolean isEntity(Reference parentReference, Entity childEntity) {
        return true;
    }

    protected boolean isSkipEntity(Reference parentReference, Entity childEntity) {
        boolean ret = false;
        if (childEntity instanceof ReferenceCollection && this.isSkipReferenceCollections()) {
            ret = true;
        }
        return ret;
    }

    public Object[] getElements(Object inputElement) {
        return this.getRoots();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected PropertyMap[] getRoots() {
        PropertyMap[] ret = new PropertyMap[]{};
        ret = this.rootsVector.toArray(ret);
        return ret;
    }

    protected void setRoots(PropertyMap[] roots) {
        this.rootsVector.clear();
        int i = 0;
        while (i < roots.length) {
            this.addRoot(roots[i]);
            ++i;
        }
    }

    protected void addRoot(PropertyMap root) {
        if (!this.rootsVector.contains(root)) {
            this.rootsVector.add(root);
        }
    }

    protected void removeRoot(PropertyMap root) {
        this.rootsVector.remove(root);
    }

    public boolean isDissolveReferences() {
        return this.dissolveReferences;
    }

    public void setDissolveReferences(boolean dissolveReferences) {
        this.dissolveReferences = dissolveReferences;
    }

    public boolean isSkipReferenceCollections() {
        return this.skipReferenceCollections;
    }

    public boolean isSkipReferences() {
        return this.skipReferences;
    }

    public void setSkipReferenceCollections(boolean skipReferenceCollections) {
        this.skipReferenceCollections = skipReferenceCollections;
    }

    public void setSkipReferences(boolean skipReferences) {
        this.skipReferences = skipReferences;
    }

    public boolean isOptimisticChildrenCheck() {
        return this.optimisticChildrenCheck;
    }

    public void setOptimisticChildrenCheck(boolean optimisticChildrenCheck) {
        this.optimisticChildrenCheck = optimisticChildrenCheck;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HasChildrenWorker
    extends BusyWorker {
        public HasChildrenWorker(Object parent) {
            super(parent);
        }

        public void run() {
            this.result = DataModelTreeContentProvider.this.hasChildrenInternal(super.getParent()) ? new Object[]{} : null;
        }
    }

    private class GetChildrenWorker
    extends BusyWorker {
        public GetChildrenWorker(Object parent) {
            super(parent);
        }

        public void run() {
            this.result = DataModelTreeContentProvider.this.getChildrenInternal(super.getParent());
        }
    }

    private abstract class BusyWorker
    implements Runnable {
        private Object parent;
        protected Object[] result;

        public BusyWorker(Object parent) {
            this.setParent(parent);
        }

        public abstract void run();

        public Object getParent() {
            return this.parent;
        }

        public Object[] getResult() {
            return this.result;
        }

        private void setParent(Object parent) {
            this.parent = parent;
        }

        private void setResult(Object[] result) {
            this.result = result;
        }
    }
}

