/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.ui.treeviewer;

import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.elements.FilterUtil;
import com.tssap.selena.model.extension.ui.treeviewer.DataModelFilteredTreeContentProvider;
import java.util.Arrays;
import java.util.Vector;

class DataModelReplacementFilteredTreeContentProvider
extends DataModelFilteredTreeContentProvider {
    public static int REPLACEMENT_DEPTH_MIN = 0;
    public static int REPLACEMENT_DEPTH_DEFAULT = 1;
    private IFilter replacementFilter;
    private int replacementDepth = REPLACEMENT_DEPTH_DEFAULT;

    public DataModelReplacementFilteredTreeContentProvider(PropertyMap[] roots, IFilter filter) {
        super(roots, filter);
    }

    public DataModelReplacementFilteredTreeContentProvider(PropertyMap[] roots, IFilter filter, IFilter replacementFilter) {
        this(roots, filter);
        this.setReplacementFilter(replacementFilter);
    }

    public DataModelReplacementFilteredTreeContentProvider(PropertyMap[] roots) {
        super(roots);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Element) {
            Element element = (Element)parentElement;
            String string = element.getUniqueName().toString();
        }
        Object[] ret = new Object[]{};
        ret = this.getChildrenInternal(parentElement, this.getReplacementDepth());
        return ret;
    }

    private Object[] getChildrenInternal(Object parentElement, int depth) {
        if (parentElement instanceof Element) {
            Element element = (Element)parentElement;
            String uNameText = element.getUniqueName().toString();
        }
        Object[] ret = new Object[]{};
        if (depth > 0) {
            Object[] objs = super.getChildren(parentElement);
            ret = this.getReplaceChildren(parentElement, objs, depth);
        }
        return ret;
    }

    private Object[] getReplaceChildren(Object rootNode, Object[] subNodes, int depth) {
        Object[] ret = new Object[]{};
        Vector<Object> childVector = new Vector<Object>();
        int s = 0;
        while (s < subNodes.length) {
            Container parentContainer;
            Object subNode = subNodes[s];
            if (this.isDissolveReferences()) {
                Object[] children;
                Entity childEntity;
                if (rootNode instanceof Reference) {
                    Reference parentReference = (Reference)rootNode;
                    if (subNode instanceof Entity && this.isEntity(parentReference, childEntity = (Entity)subNode)) {
                        if (depth > 0 && this.isSkipEntity(parentReference, childEntity)) {
                            children = this.getChildrenInternal(childEntity, depth - 1);
                            childVector.addAll(Arrays.asList(children));
                        } else {
                            childVector.add(childEntity);
                        }
                    }
                } else if (rootNode instanceof Container) {
                    parentContainer = (Container)rootNode;
                    if (subNode instanceof ReferenceCollection) {
                        ReferenceCollection childReferenceCollection = (ReferenceCollection)subNode;
                        if (this.isChildReferenceCollection(parentContainer, childReferenceCollection)) {
                            if (depth > 1 && this.isSkipChildReferenceCollection(parentContainer, childReferenceCollection)) {
                                children = this.getChildrenInternal(childReferenceCollection, depth - 1);
                                childVector.addAll(Arrays.asList(children));
                            } else {
                                childVector.add(childReferenceCollection);
                            }
                        }
                    } else if (subNode instanceof Entity && this.isChildEntity(parentContainer, childEntity = (Entity)subNode)) {
                        if (depth > 1 && this.isSkipChildEntity(parentContainer, childEntity)) {
                            children = this.getChildrenInternal(childEntity, depth - 1);
                            childVector.addAll(Arrays.asList(children));
                        } else {
                            childVector.add(childEntity);
                        }
                    }
                    if (parentContainer instanceof ReferenceCollection) {
                        Reference childrenReference;
                        ReferenceCollection parentReferenceCollection = (ReferenceCollection)parentContainer;
                        if (subNode instanceof Reference && this.isReference(parentReferenceCollection, childrenReference = (Reference)subNode)) {
                            if (depth > 1 && this.isSkipReference(parentReferenceCollection, childrenReference)) {
                                Object[] children2 = this.getChildrenInternal(childrenReference, depth - 1);
                                childVector.addAll(Arrays.asList(children2));
                            } else {
                                childVector.add(childrenReference);
                            }
                        }
                    }
                }
            } else if (rootNode instanceof Container) {
                Entity childEntity;
                parentContainer = (Container)rootNode;
                Entity[] childrenArray = FilterUtil.getChildEntities(parentContainer);
                if (subNode instanceof Entity && this.isChildEntity(parentContainer, childEntity = (Entity)subNode)) {
                    childVector.add(childEntity);
                }
            }
            ++s;
        }
        ret = childVector.toArray(ret);
        return ret;
    }

    public Object[] getElements(Object inputElement) {
        Object[] ret = new Object[]{};
        ret = this.getElementsInternal(inputElement, this.getReplacementDepth());
        return ret;
    }

    public Object[] getElementsInternal(Object inputElement, int depth) {
        Object[] ret = new Object[]{};
        Object[] objs = super.getElements(inputElement);
        ret = this.getReplaceElements(objs, depth);
        return ret;
    }

    private Object[] getReplaceElements(Object[] objs, int depth) {
        Object[] ret = new Object[]{};
        Vector<Object> vec = new Vector<Object>();
        int i = 0;
        while (i < objs.length) {
            boolean isAvailable;
            Object object = objs[i];
            boolean bl = isAvailable = object instanceof PropertyMap && this.getReplacementFilter().isAvailable((PropertyMap)object);
            if (isAvailable) {
                vec.add((PropertyMap)object);
            } else if (depth >= 1) {
                Object[] children = this.getChildrenInternal(object, depth);
                int j = 0;
                while (j < children.length) {
                    vec.add(children[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (vec.size() > 0) {
            ret = vec.toArray(ret);
        }
        return ret;
    }

    public IFilter getReplacementFilter() {
        if (this.replacementFilter == null) {
            this.replacementFilter = FilterFactory.createDefaultYesManFilter();
        }
        return this.replacementFilter;
    }

    public void setReplacementFilter(IFilter replacementFilter) {
        this.replacementFilter = replacementFilter;
    }

    public int getReplacementDepth() {
        return this.replacementDepth;
    }

    public void setReplacementDepth(int replacementDepth) {
        this.replacementDepth = replacementDepth;
    }

    protected boolean isSkipChildEntity(Container parentContainer, Entity childEntity) {
        boolean ret = super.isSkipChildEntity(parentContainer, childEntity);
        return ret || !FilterUtil.isChildEntity(parentContainer, childEntity, this.getReplacementFilter());
    }

    protected boolean isSkipChildReferenceCollection(Container parentContainer, ReferenceCollection childReferenceCollection) {
        boolean ret = super.isSkipChildReferenceCollection(parentContainer, childReferenceCollection);
        return ret || !FilterUtil.isChildReferenceCollection(parentContainer, childReferenceCollection, this.getReplacementFilter());
    }

    protected boolean isSkipEntity(Reference parentReference, Entity childEntity) {
        boolean ret = super.isSkipEntity(parentReference, childEntity);
        return ret || !FilterUtil.isEntity(parentReference, childEntity, this.getReplacementFilter());
    }

    protected boolean isSkipReference(ReferenceCollection parentReferenceCollection, Reference childReference) {
        boolean ret = super.isSkipReference(parentReferenceCollection, childReference);
        return ret || !FilterUtil.isReference(parentReferenceCollection, childReference, this.getReplacementFilter());
    }
}

