/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filter.persistable;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.YesManFilter;
import com.tssap.selena.model.extension.filter.persistable.IPersistableFilter;
import com.tssap.selena.model.extension.filter.persistable.StringMatcher;
import org.eclipse.ui.IMemento;

public class UniPFilter
extends YesManFilter
implements IPersistableFilter {
    public static final String TYPE = "NamePFilter";
    private String[] equalNames;
    private String[] patternNames;
    private StringMatcher[] patternMatcher;
    private boolean inverted;

    private UniPFilter() {
    }

    public UniPFilter(String[] equalNames, String[] patternNames, boolean inverted) {
        this.equalNames = equalNames;
        this.patternNames = patternNames;
        this.createPatternMatcher();
        this.inverted = inverted;
    }

    private void createPatternMatcher() {
        this.patternMatcher = new StringMatcher[this.patternNames.length];
        int i = 0;
        while (i < this.patternNames.length) {
            this.patternMatcher[i] = new StringMatcher(this.patternNames[i], true, false);
            ++i;
        }
    }

    public boolean isAvailable(PropertyMap propertyMap) {
        boolean ret = false;
        if (propertyMap instanceof Element) {
            ret = this.isMatchUni(((Element)propertyMap).getUniqueName());
        }
        return ret ^ this.inverted;
    }

    private boolean isMatchUni(UniqueName uni) {
        boolean ret = false;
        String name = uni.getName();
        int i = 0;
        while (i < this.equalNames.length && !ret) {
            ret = name.equals(this.equalNames[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.patternMatcher.length && !ret) {
            ret = this.patternMatcher[i2].match(uni.getName());
            ++i2;
        }
        return ret;
    }

    public static IPersistableFilter createFilter(IMemento memento) {
        UniPFilter ret = null;
        if (UniPFilter.checkMemento(memento)) {
            ret = new UniPFilter();
            ret.restoreState(memento);
        }
        return ret;
    }

    private static boolean checkMemento(IMemento memento) {
        return true;
    }

    public String getType() {
        return TYPE;
    }

    public String getFactoryId() {
        return null;
    }

    public void saveState(IMemento memento) {
        memento.putString("type", this.getType());
        memento.putInteger("inverted", this.inverted ? 1 : 0);
        if (this.getName() != null) {
            memento.putString("name", this.getName());
        }
        int i = 0;
        while (i < this.equalNames.length) {
            IMemento namePatMem = memento.createChild("equalname");
            namePatMem.putString("UNIName", this.equalNames[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.patternNames.length) {
            IMemento namePatMem = memento.createChild("namePattern");
            namePatMem.putString("UNINamePattern", this.patternNames[i2]);
            ++i2;
        }
    }

    public void restoreState(IMemento memento) {
        this.setName(memento.getString("name"));
        this.inverted = memento.getInteger("inverted") == 1;
        IMemento[] namePatMems = memento.getChildren("equalname");
        this.equalNames = new String[namePatMems.length];
        int i = 0;
        while (i < namePatMems.length) {
            this.equalNames[i] = namePatMems[i].getString("UNIName");
            ++i;
        }
        namePatMems = memento.getChildren("namePattern");
        this.patternNames = new String[namePatMems.length];
        int i2 = 0;
        while (i2 < namePatMems.length) {
            this.patternNames[i2] = namePatMems[i2].getString("UNINamePattern");
            ++i2;
        }
        this.createPatternMatcher();
    }

    public String[] getEqualNames() {
        return this.equalNames;
    }

    public String[] getPatternNames() {
        return this.patternNames;
    }

    public void setEqualNames(String[] strings) {
        this.equalNames = strings;
    }

    public void setPatternNames(String[] strings) {
        this.patternNames = strings;
        this.createPatternMatcher();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }
}

