/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filter.persistable;

import com.tssap.selena.model.extension.filter.persistable.IPersistableFilter;
import com.tssap.selena.model.extension.filter.persistable.PersistableFilterFactory;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PersistableFilterManager
implements IPersistableElement {
    private static final String MY_ELEMENT_FACTORY_ID = "com.tssap.selena.model.extension.filter.persistable.PersistableFilterManager.ElementFactory";
    private ArrayList filterList = new ArrayList();

    public void addFilter(IPersistableFilter filter) {
        if (filter == null || filter.getName() == null) {
            return;
        }
        IPersistableFilter containedFilter = this.getFilter(filter.getName());
        if (containedFilter != null) {
            this.removeFilter(containedFilter);
        }
        this.filterList.add(filter);
    }

    public void addFilters(IPersistableFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            this.addFilter(filters[i]);
            ++i;
        }
    }

    public void removeFilter(IPersistableFilter filter) {
        ((AbstractCollection)this.filterList).remove(filter);
    }

    public void removeFilters(IPersistableFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            this.removeFilter(filters[i]);
            ++i;
        }
    }

    public void removeAllFilters() {
        this.filterList.clear();
    }

    public IPersistableFilter[] getFilters() {
        return this.filterList.toArray(new IPersistableFilter[this.filterList.size()]);
    }

    public IPersistableFilter getFilter(String filterName) {
        IPersistableFilter ret = null;
        int i = 0;
        while (i < this.filterList.size()) {
            if (filterName.equals(((IPersistableFilter)this.filterList.get(i)).getName())) {
                ret = (IPersistableFilter)this.filterList.get(i);
            }
            ++i;
        }
        return ret;
    }

    public String getFactoryId() {
        return null;
    }

    public void saveState(IMemento memento) {
        int i = 0;
        while (i < this.filterList.size()) {
            IMemento filterMem = memento.createChild("PersitableFilter");
            ((IPersistableFilter)this.filterList.get(i)).saveState(filterMem);
            ++i;
        }
    }

    public void restoreState(IMemento memento) {
        IMemento[] filterMems = memento.getChildren("PersitableFilter");
        int i = 0;
        while (i < filterMems.length) {
            IPersistableFilter filter = PersistableFilterFactory.createFilter(filterMems[i]);
            if (filter != null) {
                this.addFilter(filter);
            }
            ++i;
        }
    }
}

