/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filter.persistable;

import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IFilterSet;
import com.tssap.selena.model.extension.filter.persistable.IFilterSelectionCallback;
import com.tssap.selena.model.extension.filter.persistable.IPersistableFilter;
import com.tssap.selena.model.extension.filter.persistable.PersistableFilterManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FilterSelectionDialog {
    private Shell shell;
    private String selectedFilterName;
    private PersistableFilterManager persFilterManager;
    private IFilterSet filterSet;

    public static IFilter selectFilter(Shell shell, IFilterSelectionCallback filterSelectionCallback, PersistableFilterManager manager) {
        Object selObj;
        IFilter ret = null;
        MyDialog diag = new MyDialog(shell, "Select a Filter", "Select Active Filter", filterSelectionCallback, manager);
        int pressed = diag.open();
        if (pressed == 0 && (selObj = diag.getCurrentSelection()) instanceof IFilter) {
            ret = (IFilter)selObj;
        }
        return ret;
    }

    public String getSelectedFilterName() {
        return this.selectedFilterName;
    }

    public static class FilterLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        public String getText(Object element) {
            String ret = null;
            ret = element instanceof IPersistableFilter ? ((IPersistableFilter)element).getName() : super.getText(element);
            return ret;
        }
    }

    static class MyFilterContentProvider
    implements IStructuredContentProvider {
        PersistableFilterManager filterManager;
        Object[] myElements;

        public MyFilterContentProvider(PersistableFilterManager manager) {
            this.filterManager = manager;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myElements = null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getElements();
        }

        private Object[] getElements() {
            if (this.myElements == null) {
                this.myElements = this.filterManager.getFilters();
            }
            return this.myElements;
        }
    }

    private static class MyDialog
    extends SelectionDialog {
        private static final int SIZING_SELECTION_WIDGET_WIDTH = 200;
        private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
        private PersistableFilterManager myFilterManager;
        private TableViewer myTableViewer;
        private Button editBut;
        private Button removeBut;
        private MyFilterContentProvider myContentProvider;
        private Object myCurrentSelection;
        private IFilterSelectionCallback myFilterSelectionCallback;

        public MyDialog(Shell parentShell, String title, String message, IFilterSelectionCallback filterSelectionCallback, PersistableFilterManager filterManager) {
            super(parentShell);
            super.setTitle(title);
            super.setMessage(message);
            this.myFilterManager = filterManager;
            this.myFilterSelectionCallback = filterSelectionCallback;
        }

        public Object getCurrentSelection() {
            return this.myCurrentSelection;
        }

        protected Control createDialogArea(Composite parent) {
            IGridLayoutPane pane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
            ISimplePane tablePane = pane.addSimplePane(true, true);
            GridData data = new GridData(1808);
            data.widthHint = 200;
            data.heightHint = 200;
            pane.getComposite().setLayoutData((Object)data);
            this.myTableViewer = new TableViewer(tablePane.getComposite(), 68356);
            this.myContentProvider = new MyFilterContentProvider(this.myFilterManager);
            this.myTableViewer.setContentProvider((IContentProvider)this.myContentProvider);
            this.myTableViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
            this.myTableViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    MyDialog.access$000(this.this$0, event);
                }
            });
            this.myTableViewer.setInput((Object)"");
            IGridLayoutPane buttonPane = pane.addGridLayoutPane(3, true);
            buttonPane.addPushButton("New").addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    MyDialog.access$100(this.this$0);
                }
            });
            this.editBut = buttonPane.addPushButton("Edit");
            this.editBut.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    MyDialog.access$200(this.this$0);
                }
            });
            this.editBut.setEnabled(false);
            this.removeBut = buttonPane.addPushButton("Remove");
            this.removeBut.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    MyDialog.access$300(this.this$0);
                }
            });
            this.removeBut.setEnabled(false);
            return pane.getComposite();
        }

        private void doSelectionChanged(SelectionChangedEvent event) {
            TableItem[] selItems = this.myTableViewer.getTable().getSelection();
            this.myCurrentSelection = selItems.length == 1 && selItems[0] != null && !selItems[0].isDisposed() ? selItems[0].getData() : null;
            this.editBut.setEnabled(this.myCurrentSelection != null);
            this.removeBut.setEnabled(this.myCurrentSelection != null);
        }

        private void handleNewPressed() {
            IPersistableFilter newFilter = this.myFilterSelectionCallback.createNewFilter();
            String newName = "New Filter";
            if (this.myFilterManager.getFilter(newName) != null) {
                String testName;
                int count = 0;
                while (this.myFilterManager.getFilter(testName = newName + ++count) != null) {
                }
                newName = testName;
            }
            newFilter.setName(newName);
            this.myFilterManager.addFilter(newFilter);
            this.myTableViewer.setInput((Object)"");
            this.myTableViewer.refresh();
            this.myTableViewer.setSelection((ISelection)new StructuredSelection((Object)newFilter));
        }

        private void edit(IPersistableFilter filter) {
            IPersistableFilter[] filters = this.myFilterManager.getFilters();
            ArrayList<String> reservedNames = new ArrayList<String>();
            int i = 0;
            while (i < filters.length) {
                if (!filters[i].getName().equals(filter.getName())) {
                    reservedNames.add(filters[i].getName());
                }
                ++i;
            }
            this.myFilterSelectionCallback.editFilter(reservedNames.toArray(new String[reservedNames.size()]), filter);
        }

        private void handleEditPressed() {
            IPersistableFilter selFilter = this.getSelectedFilter();
            this.edit(selFilter);
            this.myTableViewer.refresh();
        }

        private void handleRemovePressed() {
            IPersistableFilter selFilter = this.getSelectedFilter();
            this.myFilterManager.removeFilter(selFilter);
            this.setSelectionResult(new Object[0]);
            this.myTableViewer.setInput((Object)"");
            this.myTableViewer.refresh();
            this.myTableViewer.setSelection((ISelection)new StructuredSelection(new Object[0]));
        }

        private IPersistableFilter getSelectedFilter() {
            IPersistableFilter ret = null;
            Object res = this.getCurrentSelection();
            if (res instanceof IPersistableFilter) {
                ret = (IPersistableFilter)res;
            }
            return ret;
        }

        static /* synthetic */ void access$000(MyDialog x0, SelectionChangedEvent x1) {
            x0.doSelectionChanged(x1);
        }

        static /* synthetic */ void access$100(MyDialog x0) {
            x0.handleNewPressed();
        }

        static /* synthetic */ void access$200(MyDialog x0) {
            x0.handleEditPressed();
        }

        static /* synthetic */ void access$300(MyDialog x0) {
            x0.handleRemovePressed();
        }
    }
}

