/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filter.internal;

import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.selena.model.extension.filter.internal.AbstractFilterSet;

public class MutableFilterSet
extends AbstractFilterSet
implements IMutableFilterSet {
    MutableFilterSet(int type) {
        super(type);
    }

    public static IMutableFilterSet createFilterSet(int type) {
        return new MutableFilterSet(type);
    }

    public static IMutableFilterSet createFilterSet(int type, IFilter[] filters) {
        MutableFilterSet ret = new MutableFilterSet(type);
        ret.addFilters(filters);
        return ret;
    }

    public static IMutableFilterSet createFilterSet(int type, IFilter filter) {
        MutableFilterSet ret = new MutableFilterSet(type);
        ret.addFilter(filter);
        return ret;
    }

    public IFilter[] getFilters() {
        Object[] ret = new IFilter[this.getFilterVector().size()];
        this.getFilterVector().copyInto(ret);
        return ret;
    }

    public boolean addFilter(IFilter filter) {
        return this.getFilterVector().add(filter);
    }

    public int addFilters(IFilter[] filters) {
        int ret = 0;
        int i = 0;
        while (i < filters.length) {
            IFilter oneFilter = filters[i];
            if (this.addFilter(oneFilter)) {
                // empty if block
            }
            ++ret;
            ++i;
        }
        return ret;
    }

    public boolean removeFilter(IFilter filter) {
        return this.getFilterVector().removeElement(filter);
    }

    public int removeFilters(IFilter[] filters) {
        int ret = 0;
        int i = 0;
        while (i < filters.length) {
            IFilter oneFilter = filters[i];
            if (this.removeFilter(oneFilter)) {
                // empty if block
            }
            ++ret;
            ++i;
        }
        return ret;
    }

    public void removeAllFilters() {
        this.getFilterVector().removeAllElements();
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public void setType(int type) {
        this.type = type;
    }
}

