/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filter.internal;

import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Link;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IFilterSet;
import com.tssap.selena.model.extension.filter.internal.AbstractFilter;
import java.util.Vector;

abstract class AbstractFilterSet
extends AbstractFilter
implements IFilterSet {
    protected int type;
    private Vector filterVector;

    AbstractFilterSet(int type) {
        this.type = type;
    }

    public boolean isAvailable(Property property) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.isAvailable(property)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.isAvailable(property)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean isAvailable(PropertyMap propertyMap) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.isAvailable(propertyMap)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.isAvailable(propertyMap)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean participantAvailable(Link link, Element participant) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.participantAvailable(link, participant)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.participantAvailable(link, participant)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean participantAvailable(Link link) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.participantAvailable(link)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.participantAvailable(link)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean propertyAvailable(Reference reference, Property property) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.propertyAvailable((PropertyMap)reference, property)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.propertyAvailable((PropertyMap)reference, property)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean propertyAvailable(Reference reference) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.propertyAvailable((PropertyMap)reference)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.propertyAvailable((PropertyMap)reference)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean referenceAvailable(ReferenceCollection referenceCollection, Reference reference) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.referenceAvailable(referenceCollection, reference)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.referenceAvailable(referenceCollection, reference)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean referenceAvailable(ReferenceCollection referenceCollection) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.referenceAvailable(referenceCollection)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.referenceAvailable(referenceCollection)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean subpropertyAvailable(Property property, PropertyMap subproperty) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.subpropertyAvailable(property, subproperty)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.subpropertyAvailable(property, subproperty)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean subpropertyAvailable(Property property) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.subpropertyAvailable(property)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.subpropertyAvailable(property)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean childEntityAvailable(Container container, Entity child) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.childEntityAvailable(container, child)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.childEntityAvailable(container, child)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean childEntityAvailable(Container container) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.childEntityAvailable(container)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.childEntityAvailable(container)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean childrenAvailable(Container container, Entity child) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.childrenAvailable(container, child)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.childrenAvailable(container, child)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean childrenAvailable(Container container) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.childrenAvailable(container)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.childrenAvailable(container)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean entityAvailable(Reference reference, Entity entity) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.entityAvailable(reference, entity)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.entityAvailable(reference, entity)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean entityAvailable(Reference reference) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.entityAvailable(reference)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.entityAvailable(reference)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean isAvailable(ReferenceContainer referenceContainer) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.isAvailable(referenceContainer)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.isAvailable(referenceContainer)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean isAvailable(UniqueName uniqueName) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.isAvailable(uniqueName)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.isAvailable(uniqueName)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean modelAvailable(Element element, Model model) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.modelAvailable(element, model)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.modelAvailable(element, model)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean modelAvailable(Element element) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.modelAvailable(element)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.modelAvailable(element)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean parentAvailable(Element element, Entity parent) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.parentAvailable(element, parent)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.parentAvailable(element, parent)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean parentAvailable(Element element) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.parentAvailable(element)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.parentAvailable(element)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean parentUniqueNameAvailable(UniqueName uniqueName, UniqueName parentUniqueName) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.parentUniqueNameAvailable(uniqueName, parentUniqueName)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.parentUniqueNameAvailable(uniqueName, parentUniqueName)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean parentUniqueNameAvailable(UniqueName uniqueName) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.parentUniqueNameAvailable(uniqueName)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.parentUniqueNameAvailable(uniqueName)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean propertyAvailable(PropertyMap propertyMap, Property property) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.propertyAvailable(propertyMap, property)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.propertyAvailable(propertyMap, property)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean propertyAvailable(PropertyMap propertyMap) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.propertyAvailable(propertyMap)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.propertyAvailable(propertyMap)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean referenceCollectionAvailable(Container container, ReferenceCollection referenceCollection) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.referenceCollectionAvailable(container, referenceCollection)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.referenceCollectionAvailable(container, referenceCollection)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean referenceCollectionAvailable(Container container) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.referenceCollectionAvailable(container)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.referenceCollectionAvailable(container)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean referenceContainerAvailable(Reference reference, ReferenceContainer referenceContainer) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.referenceContainerAvailable(reference, referenceContainer)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.referenceContainerAvailable(reference, referenceContainer)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean referenceContainerAvailable(Reference reference) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.referenceContainerAvailable(reference)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.referenceContainerAvailable(reference)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean uniqueNameAvailable(Element element, UniqueName uniqueName) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.uniqueNameAvailable(element, uniqueName)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.uniqueNameAvailable(element, uniqueName)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public boolean uniqueNameAvailable(Element element) {
        boolean ored = this.getType() == 0;
        IFilter[] filters = this.getFilters();
        if (filters.length < 1) {
            return this.invertIfNeeded(!ored);
        }
        if (ored) {
            int i = 0;
            while (i < filters.length) {
                IFilter iFilter = filters[i];
                if (iFilter.uniqueNameAvailable(element)) {
                    return this.invertIfNeeded(true);
                }
                ++i;
            }
            return this.invertIfNeeded(false);
        }
        int i = 0;
        while (i < filters.length) {
            IFilter iFilter = filters[i];
            if (!iFilter.uniqueNameAvailable(element)) {
                return this.invertIfNeeded(false);
            }
            ++i;
        }
        return this.invertIfNeeded(true);
    }

    public int getType() {
        return this.type;
    }

    protected boolean invertIfNeeded(boolean uninverted) {
        boolean ret = uninverted;
        if (this.isInverted()) {
            ret = !uninverted;
        }
        return ret;
    }

    public IFilter[] getFilters() {
        IFilter[] ret = (IFilter[])this.getFilterVector().toArray();
        return ret;
    }

    protected Vector getFilterVector() {
        if (this.filterVector == null) {
            this.filterVector = new Vector();
        }
        return this.filterVector;
    }

    protected void setFilterVector(Vector filterVector) {
        this.filterVector = filterVector;
    }

    public boolean contains(IFilter filter) {
        boolean ret = false;
        IFilter[] filters = this.getFilters();
        int i = 0;
        while (i < filters.length && !ret) {
            IFilter iFilter = filters[i];
            if (iFilter.equals(filter)) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }
}

