/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filter.elements;

import com.tssap.selena.model.elements.Container;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import java.util.Vector;

public class FilterUtil {
    public static Entity[] getChildEntities(Container container) {
        return FilterUtil.getChildEntities(container, FilterFactory.createDefaultYesManFilter());
    }

    public static Entity[] getChildEntities(Container container, IFilter filter) {
        Entity[] ret = new Entity[]{};
        Vector<Entity> retVector = new Vector<Entity>();
        EntityEnumeration entityEnum = container.childEntities();
        while (entityEnum.hasMoreElements()) {
            Entity entity = (Entity)entityEnum.nextElement();
            boolean isChildEntity = FilterUtil.isChildEntity(container, entity, filter);
            if (!isChildEntity) continue;
            retVector.add(entity);
        }
        ret = retVector.toArray(ret);
        return ret;
    }

    public static boolean isChildEntity(Container container, Entity entity, IFilter filter) {
        boolean isAvailable = filter.isAvailable((PropertyMap)entity);
        boolean isChildrenAvailable = filter.childEntityAvailable(container);
        boolean isChildEntityAvailable = filter.childEntityAvailable(container, entity);
        boolean isChildEntity = isAvailable && isChildrenAvailable && isChildEntityAvailable;
        return isChildEntity;
    }

    public static Entity[] getChildren(Container container) {
        return FilterUtil.getChildren(container, FilterFactory.createDefaultYesManFilter());
    }

    public static Entity[] getChildren(Container container, IFilter filter) {
        Entity[] ret = new Entity[]{};
        Vector<Entity> retVector = new Vector<Entity>();
        EntityEnumeration entityEnum = container.children();
        while (entityEnum.hasMoreElements()) {
            Entity entity = (Entity)entityEnum.nextElement();
            boolean isChildren = FilterUtil.isChildren(container, entity, filter);
            if (!isChildren) continue;
            retVector.add(entity);
        }
        ret = retVector.toArray(ret);
        return ret;
    }

    public static boolean isChildren(Container container, Entity entity, IFilter filter) {
        boolean isAvailable = filter.isAvailable((PropertyMap)entity);
        boolean isChildrenAvailable = filter.childrenAvailable(container);
        boolean isChildAvailable = filter.childrenAvailable(container, entity);
        boolean isChildren = isAvailable && isChildrenAvailable && isChildAvailable;
        return isChildren;
    }

    public static ReferenceCollection[] getChildReferenceCollections(Container container) {
        return FilterUtil.getChildReferenceCollections(container, FilterFactory.createDefaultYesManFilter());
    }

    public static ReferenceCollection[] getChildReferenceCollections(Container container, IFilter filter) {
        ReferenceCollection[] ret = new ReferenceCollection[]{};
        Vector<ReferenceCollection> retVector = new Vector<ReferenceCollection>();
        ReferenceCollectionEnumeration referenceCollectionEnum = container.childReferenceCollections();
        while (referenceCollectionEnum.hasMoreElements()) {
            ReferenceCollection referenceCollection = (ReferenceCollection)referenceCollectionEnum.nextElement();
            boolean isChildReferenceCollection = FilterUtil.isChildReferenceCollection(container, referenceCollection, filter);
            if (!isChildReferenceCollection) continue;
            retVector.add(referenceCollection);
        }
        ret = retVector.toArray(ret);
        return ret;
    }

    public static boolean isChildReferenceCollection(Container container, ReferenceCollection referenceCollection, IFilter filter) {
        ReferenceCollection referenceContainer = referenceCollection;
        boolean isReferenceContainerAvailable = filter.isAvailable((ReferenceContainer)referenceContainer);
        ReferenceCollection entity = referenceCollection;
        boolean isEntityAvailable = filter.isAvailable((PropertyMap)entity);
        boolean isChildReferenceCollectionsAvailable = filter.referenceCollectionAvailable(container);
        boolean isChildReferenceCollectionAvailable = filter.referenceCollectionAvailable(container, referenceCollection);
        boolean isReferenceCollection = isReferenceContainerAvailable && isEntityAvailable && isChildReferenceCollectionsAvailable && isChildReferenceCollectionsAvailable;
        return isReferenceCollection;
    }

    public static Reference[] getReferences(ReferenceCollection referenceCollection) {
        return FilterUtil.getReferences(referenceCollection, FilterFactory.createDefaultYesManFilter());
    }

    public static Reference[] getReferences(ReferenceCollection referenceCollection, IFilter filter) {
        Reference[] ret = new Reference[]{};
        Vector<Reference> retVector = new Vector<Reference>();
        ReferenceEnumeration referenceEnum = referenceCollection.references();
        while (referenceEnum.hasMoreElements()) {
            Reference reference = (Reference)referenceEnum.nextElement();
            boolean isReference = FilterUtil.isReference(referenceCollection, reference, filter);
            if (!isReference) continue;
            retVector.add(reference);
        }
        ret = retVector.toArray(ret);
        return ret;
    }

    public static boolean isReference(ReferenceCollection referenceCollection, Reference reference, IFilter filter) {
        ReferenceCollection referenceContainer = referenceCollection;
        boolean isReferenceContainerAvailable = filter.isAvailable((ReferenceContainer)referenceContainer);
        Reference element = reference;
        boolean isElementAvailable = filter.isAvailable((PropertyMap)element);
        boolean isChildReferenceCollectionsAvailable = filter.referenceAvailable(referenceCollection);
        boolean isChildReferenceCollectionAvailable = filter.referenceAvailable(referenceCollection, reference);
        boolean isReference = isReferenceContainerAvailable && isElementAvailable && isChildReferenceCollectionsAvailable && isChildReferenceCollectionsAvailable;
        return isReference;
    }

    public static Entity getEntity(Reference reference) {
        return FilterUtil.getEntity(reference, FilterFactory.createDefaultYesManFilter());
    }

    public static Entity getEntity(Reference reference, IFilter filter) {
        Entity ret = null;
        Entity entity = reference.getEntity();
        boolean isEntity = FilterUtil.isEntity(reference, entity, filter);
        if (isEntity) {
            ret = entity;
        }
        return ret;
    }

    public static boolean isEntity(Reference reference, Entity entity, IFilter filter) {
        boolean isAvailable = filter.isAvailable((PropertyMap)entity);
        boolean isEntitiesAvailable = filter.entityAvailable(reference);
        boolean isEntityAvailable = filter.entityAvailable(reference, entity);
        boolean isEntity = isAvailable && isEntitiesAvailable && isEntityAvailable;
        return isEntity;
    }
}

