/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filter;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import java.util.Enumeration;
import java.util.Vector;

public class FilteredModelAccess {
    private IFilter filter;

    protected FilteredModelAccess() {
        this(null);
    }

    protected FilteredModelAccess(IFilter filter) {
        this.filter = filter == null ? FilterFactory.createDefaultYesManFilter() : filter;
    }

    public static FilteredModelAccess createFilteredModelAccess(IFilter filter) {
        FilteredModelAccess ret = new FilteredModelAccess(filter);
        return ret;
    }

    public Model createModel(UniqueName modelUin) {
        Model ret = null;
        Model model = ModelAccess.createModel((UniqueName)modelUin);
        if (model == null || this.getFilter().isAvailable((PropertyMap)model)) {
            // empty if block
        }
        ret = model;
        return ret;
    }

    public Model getModel(UniqueName modelUin) {
        Model ret = null;
        Model model = ModelAccess.getModel((UniqueName)modelUin);
        if (model != null && this.getFilter().isAvailable((PropertyMap)model)) {
            ret = model;
        }
        return ret;
    }

    public boolean hasModel(UniqueName modelUin) {
        boolean ret = false;
        if (this.getModel(modelUin) != null) {
            ret = true;
        }
        return ret;
    }

    public Enumeration models() {
        Enumeration models = ModelAccess.models();
        Vector<Model> vec = new Vector<Model>();
        while (models.hasMoreElements()) {
            Model oneModel = (Model)models.nextElement();
            if (oneModel == null || this.getFilter().isAvailable((PropertyMap)oneModel)) {
                // empty if block
            }
            vec.add(oneModel);
        }
        Enumeration ret = vec.elements();
        return ret;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }
}

