/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filefolder;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.datasource.DataSourceManagement;
import com.tssap.selena.model.extension.datasource.IDataSourceMapper;
import com.tssap.selena.model.extension.filefolder.EclipseResourceMapper;
import com.tssap.selena.model.extension.filefolder.FileAndFolderDeltaManager;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.UserDialog;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FileAndFolderManagement
extends DataSourceManagement {
    public static final String DOMAIN_STRING = "DataModel";
    public static final String SUBDOMAIN_STRING = "FileAndFolder";
    public static final String OBJECT_PROPERTY_NAME__DATA_SOURCE = "FileAndFolderDataSource";
    public static final String METACLASS_FILE_FOLDER = "FileAndFolder";
    private static FileAndFolderManagement singleInstance;
    private IDataSourceMapper dataSourceMapper;
    private static final TracerI TRACER;
    static /* synthetic */ Class class$com$tssap$selena$model$extension$filefolder$FileAndFolderManagement;

    private FileAndFolderManagement() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)FileAndFolderDeltaManager.getInstance(), 1);
    }

    public static FileAndFolderManagement getInstance() {
        if (singleInstance == null) {
            singleInstance = new FileAndFolderManagement();
        }
        return singleInstance;
    }

    public static TracerI getTracer() {
        return TRACER;
    }

    protected IDataSourceMapper getDataSourceMapper() {
        if (this.dataSourceMapper == null) {
            this.dataSourceMapper = new EclipseResourceMapper();
        }
        return this.dataSourceMapper;
    }

    public IResource getResource(Element element) {
        IResource ret = null;
        Object dataSource = this.getDataSource(element.getUniqueName());
        if (dataSource instanceof IResource) {
            ret = (IResource)dataSource;
        }
        return ret;
    }

    public void deleteUnderlyingResource(Element element, boolean force) {
        IResource resource = this.getResource(element);
        if (resource != null) {
            this.deleteResource(resource, force);
        }
    }

    private void deleteResource(IResource resource, boolean force) {
        if (!force) {
            force = UserDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Please confirm", (String)("Are you sure you want to delete " + resource.getName()));
        }
        if (force) {
            try {
                resource.delete(false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                UserDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error deleting", (String)e.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TRACER = TracingManager.getTracer((Class)(class$com$tssap$selena$model$extension$filefolder$FileAndFolderManagement == null ? (class$com$tssap$selena$model$extension$filefolder$FileAndFolderManagement = FileAndFolderManagement.class$("com.tssap.selena.model.extension.filefolder.FileAndFolderManagement")) : class$com$tssap$selena$model$extension$filefolder$FileAndFolderManagement));
    }
}

