/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filefolder;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.filefolder.AbstractFileAndFolderProvider;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class FileAndFolderChildrenProvider
extends AbstractFileAndFolderProvider
implements ChildrenProvider {
    private Model selenaModel;

    public UniqueNameEnumeration children(Entity parent) {
        IContainer container;
        UniqueNameEnumeration ret = null;
        UniqueName uNameParent = parent.getUniqueName();
        Object dataSource = this.getManagement().getDataSource(parent.getUniqueName());
        if (dataSource == null && SelenaElementUtil.isProjectModelUniqueName(uNameParent)) {
            String projectName = uNameParent.getName();
            dataSource = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (dataSource instanceof IProject) {
                if (!((IProject)dataSource).exists()) {
                    dataSource = null;
                }
            } else {
                dataSource = null;
            }
        }
        if (dataSource instanceof IContainer && (container = (IContainer)dataSource).exists()) {
            try {
                IResource[] children = container.members();
                Vector<UniqueName> vec = new Vector<UniqueName>();
                int i = 0;
                while (i < children.length) {
                    IResource childResource = children[i];
                    UniqueName uNameChild = this.getManagement().getUniqueName(childResource);
                    vec.add(uNameChild);
                    ++i;
                }
                Enumeration enumeration = Collections.enumeration(vec);
                ret = EnumerationConverter.toUniqueNameEnumeration(enumeration);
            }
            catch (CoreException e) {
                FileAndFolderManagement.getTracer().warning(this.getClass(), "children(Entity parent)", "Error creating children", (Throwable)e);
            }
        }
        return ret;
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        boolean ret = false;
        UniqueName uName = parent.getUniqueName();
        boolean parentIsModel = ModelAccess.hasModel((UniqueName)uName);
        if (parentIsModel) {
            ret = true;
        } else if (uName != null && this.getManagement().contains(uName)) {
            ret = true;
        }
        return ret;
    }
}

