/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.filefolder;

import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.datasource.IDataSourceMapper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class EclipseResourceMapper
implements IDataSourceMapper {
    public Object getDataSource(UniqueName uName) {
        IResource ret = null;
        if (uName != null) {
            if (uName.getDomain() == "DataModel" && uName.getSubDomain() == "FileAndFolder") {
                ret = ResourcesPlugin.getWorkspace().getRoot().findMember(uName.getLocation());
            } else if (uName.getDomain() == "model" && uName.getSubDomain() == "project") {
                ret = ResourcesPlugin.getWorkspace().getRoot().getProject(uName.getName());
            }
        }
        return ret;
    }

    public UniqueName getUniqueName(Object dataSource) {
        UniqueName ret = null;
        if (dataSource instanceof IProject) {
            ret = ModelAccess.createModelUniqueName((String)((IProject)dataSource).getName());
        } else if (dataSource instanceof IResource) {
            IResource resource = (IResource)dataSource;
            ret = ModelAccess.createUniqueName((String)"DataModel", (String)"FileAndFolder", (String)resource.getFullPath().toString(), (String)resource.getName(), null);
        }
        return ret;
    }
}

