/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.extension.action;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.action.IElementActionProvider;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.IActionContext;
import com.tssap.util.action.IActionProvider;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.IFallbackAction;
import com.tssap.util.action.IGenericAction;
import com.tssap.util.action.IGenericActionContainer;
import com.tssap.util.ui.action.ConvenientActionContainer;
import java.util.Enumeration;

public class SelenaActionCollector
implements IActionProvider {
    public IGenericActionContainer getMultiActions(IActionContext actionContext) {
        return this.getActions(actionContext, 1);
    }

    public IGenericActionContainer getSingleActions(IActionContext actionContext) {
        return this.getActions(actionContext, 0);
    }

    private IGenericActionContainer getActions(IActionContext actionContext, int actionType) {
        ConvenientActionContainer ret = new ConvenientActionContainer();
        Object object = actionContext.getActionObject();
        if (object instanceof Element) {
            Element[] context = this.castElementArray(actionContext.getContextObjects());
            Element element = (Element)object;
            Enumeration objEnum = element.objectPropertyValues("com.tssap.selena.model.extension.action.CONTEXT_ACTION_PROVIDER");
            while (objEnum.hasMoreElements()) {
                int i;
                Object obj = objEnum.nextElement();
                if (!(obj instanceof IElementActionProvider) || context == null) continue;
                IElementActionProvider actionProvider = (IElementActionProvider)obj;
                if (actionType == 0) {
                    IElementSingleAction[] singleActions = actionProvider.getSingleActions(element, context);
                    i = 0;
                    while (i < singleActions.length) {
                        ret.addAction((IGenericAction)new GenericElementActionWrapper(singleActions[i]));
                        ++i;
                    }
                    continue;
                }
                if (actionType != 1) continue;
                IElementMultiAction[] multiActions = actionProvider.getMultiActions(context);
                i = 0;
                while (i < multiActions.length) {
                    ret.addAction((IGenericAction)new GenericElementActionWrapper(multiActions[i]));
                    ++i;
                }
            }
        }
        return ret;
    }

    private Element[] castElementArray(Object[] objects) {
        Element[] ret = new Element[objects.length];
        int i = 0;
        while (i < objects.length && ret != null) {
            if (objects[i] instanceof Element) {
                ret[i] = (Element)objects[i];
            } else {
                ret = null;
            }
            ++i;
        }
        return ret;
    }

    private Element castElement(Object object) {
        Element ret = null;
        if (object instanceof Element) {
            ret = (Element)object;
        }
        return ret;
    }

    public class GenericElementActionWrapper
    implements IGenericAction {
        public static final int SINGLE_ACTION = 0;
        public static final int MULTI_ACTION = 1;
        private int type;
        private IElementSingleAction mySingleAction = null;
        private IElementMultiAction myMultiAction = null;

        public GenericElementActionWrapper(IElementSingleAction singleAction) {
            this.type = 0;
            this.mySingleAction = singleAction;
        }

        public GenericElementActionWrapper(IElementMultiAction multiAction) {
            this.type = 1;
            this.myMultiAction = multiAction;
        }

        public boolean isAvailable(IActionContext actionContext) {
            Element element = SelenaActionCollector.this.castElement(actionContext.getActionObject());
            Element[] context = SelenaActionCollector.this.castElementArray(actionContext.getContextObjects());
            if (element != null && context != null) {
                return this.isAvailable(element, context);
            }
            return false;
        }

        private boolean isAvailable(Element element, Element[] context) {
            boolean ret = false;
            switch (this.type) {
                case 0: {
                    ret = this.mySingleAction.isAvailable(element);
                    break;
                }
                case 1: {
                    ret = this.myMultiAction.isAvailable(context);
                }
            }
            return ret;
        }

        public boolean isEnabled(IActionContext actionContext) {
            Element element = SelenaActionCollector.this.castElement(actionContext.getActionObject());
            Element[] context = SelenaActionCollector.this.castElementArray(actionContext.getContextObjects());
            if (element != null && context != null) {
                return this.isEnabled(element, context);
            }
            return false;
        }

        private boolean isEnabled(Element element, Element[] context) {
            boolean ret = false;
            switch (this.type) {
                case 0: {
                    ret = this.mySingleAction.isEnabled(element);
                    break;
                }
                case 1: {
                    ret = this.myMultiAction.isEnabled(context);
                }
            }
            return ret;
        }

        public void run(IActionContext actionContext) {
            Element element = SelenaActionCollector.this.castElement(actionContext.getActionObject());
            Element[] context = SelenaActionCollector.this.castElementArray(actionContext.getContextObjects());
            if (element != null && context != null) {
                switch (this.type) {
                    case 0: {
                        this.mySingleAction.run(element);
                        break;
                    }
                    case 1: {
                        this.myMultiAction.run(context);
                    }
                }
            }
        }

        public ICategory getCategory() {
            ICategory ret = null;
            switch (this.type) {
                case 0: {
                    ret = this.mySingleAction.getCategory();
                    break;
                }
                case 1: {
                    ret = this.myMultiAction.getCategory();
                }
            }
            return ret;
        }

        public String toString() {
            String ret = super.toString();
            if (this.mySingleAction != null) {
                ret = ret + " -> " + this.mySingleAction.toString();
            }
            if (this.myMultiAction != null) {
                ret = ret + " -> " + this.myMultiAction.toString();
            }
            return ret;
        }

        public boolean isFallbackAction() {
            boolean ret = false;
            if (this.mySingleAction != null && this.mySingleAction instanceof IFallbackAction) {
                ret = true;
            } else if (this.myMultiAction != null && this.myMultiAction instanceof IFallbackAction) {
                ret = true;
            }
            return ret;
        }
    }
}

