/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.views;

import com.sap.dictionary.projectbrowser.actions.PBDeleteSimpletypeAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteStructureAction;
import com.sap.dictionary.projectbrowser.tree.ProjectBrowserTreeLabels;
import com.sap.ide.metamodel.core.actions.ReloadMetadataAction;
import com.sap.ide.metamodel.core.actions.contextmenu.I18NRepairAction;
import com.sap.ide.metamodel.core.actions.contextmenu.LanguageRepairAction;
import com.sap.ide.metamodel.core.actions.contextmenu.MMRefreshAction;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.services.MetamodelImage;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.TextPool;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.ecatt.provider.EcattTreeLabels;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.actions.PBDeleteProjectAction;
import com.sap.ide.webdynpro.projectbrowser.actions.PBDeletionAction;
import com.sap.ide.webdynpro.projectbrowser.actions.PBDeployParAction;
import com.sap.ide.webdynpro.projectbrowser.actions.PBGenerateParAction;
import com.sap.ide.webdynpro.projectbrowser.actions.check.PBRepairProjectAction;
import com.sap.ide.webdynpro.projectbrowser.actions.refactoring.PBCopyAction;
import com.sap.ide.webdynpro.projectbrowser.actions.refactoring.PBPasteAction;
import com.sap.ide.webdynpro.projectbrowser.filters.ConfigurationsFileFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.DictionaryFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.FolderFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.JavaFileFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.MimesFileFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.PropertiesFileFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.ProxyItemsFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.ReferencesFileFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.WebDynproActionFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.WebDynproFilter;
import com.sap.ide.webdynpro.projectbrowser.filters.WebDynproProjectFilter;
import com.sap.ide.webdynpro.projectbrowser.services.SelenaService;
import com.sap.ide.webdynpro.projectbrowser.services.ServicesProjectBrowser;
import com.sap.ide.webdynpro.projectbrowser.tree.PBDoubleClickListener;
import com.sap.ide.webdynpro.projectbrowser.tree.WebDynproSorter;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.sap.ide.ws.label.WsLabelProvider;
import com.tssap.dii.component.DCToolbox;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.selena.model.extension.ui.view.SimpleSelectionConverter;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.action.IActionFilter;
import com.tssap.util.action.path.ContextDependentPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.ILabelProviderContainer;
import com.tssap.util.ui.LabelProviderContainer;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import com.tssap.util.ui.viewer.sorter.IViewerSorterContainer;
import com.tssap.util.ui.viewer.sorter.ViewerSorterContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ui.actions.OpenProjectAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProjectBrowserView
extends ViewPart
implements IPartListener {
    protected static String FILTER_WD_PROJECT = "Web Dynpro Projects";
    protected static String FILTER_WD = "Web Dynpro";
    protected static String FILTER_DDIC = "Dictionary";
    protected static String FILTER_JAVA = "JavaFile";
    protected static String FILTER_SOURCE_FOLDER = "SourceFolder";
    protected static String FILTER_DC = "Development Component";
    protected static String FILTER_MIMES_FILE = "MimesFile";
    protected static String FILTER_CONFIGURATION_FILE = "ConfigurationFile";
    protected static String FILTER_PROPERTIES_FILE = "Properties File";
    protected static String FILTER_REFERENCES_FILE = "References File";
    protected static String FILTER_PROXY_ITEMS = "Proxy Items Filter";
    private static com.sap.ide.webdynpro.projectbrowser.services.TextPool mTPool = com.sap.ide.webdynpro.projectbrowser.services.TextPool.getInstance();
    private GenericDataModelFilteredTreeViewer mTreeViewer;
    private IMutableFilterSet mMutableFilterSet;
    private static ILabelProviderContainer mLabelProviderContainer;
    private Action copyAction;
    private Action pasteAction;
    private Action mBuildAction;
    private IWorkbenchPart mActivePart;
    private Entity mEditorEntity = null;
    private Element mSelectedElement = null;
    private boolean mShouldLinkWithEditor = false;
    private IToolBarManager mToolBarManager = null;
    private IViewerSorterContainer viewerSorterContainer;
    public static Properties properties;
    public static String PROP_LINK_WITH_EDITOR;
    public static String PROP_TREE_REVEAL_STATE;
    public static String PROP_PROJECT_NAME;
    public static String PROP_DOMAIN;
    public static String PROP_SUBDOMAIN;
    public static String PROP_LOCATION;
    public static String PROP_NAME;
    private static final String DEPLOY_COMMAND_ID = "com.sap.ide.webdynpro.projectbrowser.commands.deploy";
    private static final String CREATEARCHIVE_COMMAND_ID = "com.sap.ide.webdynpro.projectbrowser.commands.createarchive";
    private static final String RELOAD_COMMAND_ID = "com.sap.ide.webdynpro.projectbrowser.commands.reload";
    private static final String REPAIRPROJECT_COMMAND_ID = "com.sap.ide.webdynpro.projectbrowser.commands.repairproject";
    private static final String ORPHANED_COMMAND_ID = "com.sap.ide.webdynpro.projectbrowser.commands.orphanedtexts";
    private static final String RAWLANGUAGE_COMMAND_ID = "com.sap.ide.webdynpro.projectbrowser.commands.rawlanguage";
    private DeployAction mDeployAction;
    private CreateArchiveAction mCreateArchiveAction;
    private ReloadAction mReloadAction;
    private RepairProjectAction mRepairProjectAction;
    private RemoveOrphanedTextsAction mRemoveOrphanedTextsAction;
    private RawLanguageSupportAction mRawLanguageSupportAction;
    IAction mCloseAction;
    IAction mOpenAction;

    public ProjectBrowserView() {
        this.initFilterManager();
        ProjectBrowserView.initTreeLabelProvider();
        this.readProperties();
    }

    public void createPartControl(Composite parent) {
        GenericDataModelFilteredTreeViewer viewer = GenericDataModelFilteredTreeViewer.createFilteredTreeViewer((Composite)parent);
        this.getViewSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
        this.setTreeViewer(viewer);
        viewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)mLabelProviderContainer);
        viewer.setFilter((IFilter)this.mMutableFilterSet);
        viewer.setDissolveReferences(false);
        viewer.setSkipReferences(true);
        viewer.setOptimisticChildrenCheck(false);
        viewer.setSkipReferenceCollections(true);
        viewer.getTreeViewer().addDoubleClickListener((IDoubleClickListener)new PBDoubleClickListener());
        viewer.getTree().addKeyListener((KeyListener)new PBKeyListener());
        viewer.getTreeViewer().setSorter((ViewerSorter)this.getViewerSorterContainer());
        this.setDragDrop(viewer);
        this.setSystemMenuEntries(viewer);
        WebDynproActionFilter actionFilter = new WebDynproActionFilter();
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new ContextDependentPathProvider(false));
        DynamicContextMenu contextMenu = new DynamicContextMenu((IMenuFactory)menuFactory, (IActionFilter)actionFilter);
        this.getTreeViewer().setContextMenu((IContextMenu)contextMenu);
        SimpleSelectionConverter converter = new SimpleSelectionConverter((ISelectionProvider)viewer.getTreeViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)converter);
        this.createToolBar();
        this.getTreeViewer().getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionListener());
        String projectName = null;
        String domain = null;
        String subdomain = null;
        String location = null;
        String name = null;
        if (((Hashtable)properties).containsKey(PROP_PROJECT_NAME)) {
            projectName = properties.getProperty(PROP_PROJECT_NAME);
        }
        if (((Hashtable)properties).containsKey(PROP_DOMAIN)) {
            domain = properties.getProperty(PROP_DOMAIN);
        }
        if (((Hashtable)properties).containsKey(PROP_SUBDOMAIN)) {
            subdomain = properties.getProperty(PROP_SUBDOMAIN);
        }
        if (((Hashtable)properties).containsKey(PROP_LOCATION)) {
            location = properties.getProperty(PROP_LOCATION);
        }
        if (((Hashtable)properties).containsKey(PROP_NAME)) {
            name = properties.getProperty(PROP_NAME);
        }
        UniqueName uniqueName = null;
        if (projectName != null && domain != null && subdomain != null && location != null && name != null) {
            uniqueName = ModelAccess.createUniqueName((String)domain, (String)subdomain, (String)location, (String)name, null);
            UniqueName modelUIN = ModelAccess.createModelUniqueName((String)projectName);
            Model model = ModelAccess.getModel((UniqueName)modelUIN);
            if (uniqueName != null && model != null) {
                this.mEditorEntity = model.findEntity(uniqueName);
                this.revealTree();
            }
        }
    }

    public void setFocus() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setFocus();
        }
    }

    protected GenericDataModelFilteredTreeViewer getTreeViewer() {
        return this.mTreeViewer;
    }

    protected void setTreeViewer(GenericDataModelFilteredTreeViewer treeViewer) {
        this.mTreeViewer = treeViewer;
    }

    protected void initFilterManager() {
        this.mMutableFilterSet = FilterFactory.createOrFilterSet();
        WebDynproProjectFilter wdProjectFilter = new WebDynproProjectFilter();
        wdProjectFilter.setName(FILTER_WD_PROJECT);
        this.mMutableFilterSet.addFilter((IFilter)wdProjectFilter);
        ProxyItemsFilter prxItemsFilter = new ProxyItemsFilter();
        prxItemsFilter.setName(FILTER_PROXY_ITEMS);
        this.mMutableFilterSet.addFilter((IFilter)prxItemsFilter);
        WebDynproFilter wdFilter = new WebDynproFilter();
        wdFilter.setName(FILTER_WD);
        this.mMutableFilterSet.addFilter((IFilter)wdFilter);
        DictionaryFilter ddicFilter = new DictionaryFilter();
        ddicFilter.setName(FILTER_DDIC);
        this.mMutableFilterSet.addFilter((IFilter)ddicFilter);
        FolderFilter sourceFolderFilter = new FolderFilter();
        sourceFolderFilter.setName(FILTER_SOURCE_FOLDER);
        this.mMutableFilterSet.addFilter((IFilter)sourceFolderFilter);
        JavaFileFilter javaFileFilter = new JavaFileFilter();
        javaFileFilter.setName(FILTER_JAVA);
        this.mMutableFilterSet.addFilter((IFilter)javaFileFilter);
        IFilter logicalFilter = DCToolbox.getDCMetaDataFilter();
        logicalFilter.setName(FILTER_DC);
        this.mMutableFilterSet.addFilter(logicalFilter);
        MimesFileFilter fileFilter = new MimesFileFilter();
        fileFilter.setName(FILTER_MIMES_FILE);
        this.mMutableFilterSet.addFilter((IFilter)fileFilter);
        ConfigurationsFileFilter configurationFileFilter = new ConfigurationsFileFilter();
        configurationFileFilter.setName(FILTER_CONFIGURATION_FILE);
        this.mMutableFilterSet.addFilter((IFilter)configurationFileFilter);
        PropertiesFileFilter propertiesFileFilter = new PropertiesFileFilter();
        propertiesFileFilter.setName(FILTER_PROPERTIES_FILE);
        this.mMutableFilterSet.addFilter((IFilter)propertiesFileFilter);
        ReferencesFileFilter referencesFileFilter = new ReferencesFileFilter();
        referencesFileFilter.setName(FILTER_REFERENCES_FILE);
        this.mMutableFilterSet.addFilter((IFilter)referencesFileFilter);
    }

    private static void initTreeLabelProvider() {
        mLabelProviderContainer = new LabelProviderContainer();
        mLabelProviderContainer.addLabelProvider((ILabelProvider)new WsLabelProvider());
        mLabelProviderContainer.addLabelProvider((ILabelProvider)new com.sap.ide.webdynpro.projectbrowser.tree.ProjectBrowserTreeLabels());
        mLabelProviderContainer.addLabelProvider(DCToolbox.getDCMetaDataLabelProvider());
        mLabelProviderContainer.addLabelProvider((ILabelProvider)new EcattTreeLabels());
        mLabelProviderContainer.addLabelProvider((ILabelProvider)new ProjectBrowserTreeLabels());
    }

    private void setDragDrop(GenericDataModelFilteredTreeViewer viewer) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 3;
        DragSource source = new DragSource((Control)viewer.getTree(), operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ISelection sel;
                ISelection selection = ProjectBrowserView.this.mTreeViewer.getTreeViewer().getSelection();
                if (selection instanceof IStructuredSelection && (sel = ProjectBrowserView.this.mTreeViewer.getTreeViewer().getSelection()) instanceof StructuredSelection) {
                    Iterator it = ((StructuredSelection)sel).iterator();
                    while (it.hasNext()) {
                        Entity entity;
                        String subdomain;
                        Object obj = it.next();
                        if (!(obj instanceof Entity) || (subdomain = (entity = (Entity)obj).getUniqueName().getSubDomain()).equals("View")) continue;
                        event.doit = false;
                        return;
                    }
                }
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                ISelection sel;
                ISelection selection = ProjectBrowserView.this.mTreeViewer.getTreeViewer().getSelection();
                if (selection instanceof IStructuredSelection && (sel = ProjectBrowserView.this.mTreeViewer.getTreeViewer().getSelection()) instanceof StructuredSelection) {
                    Element[] elements = new Element[((StructuredSelection)sel).size()];
                    Iterator it = ((StructuredSelection)sel).iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        elements[i] = (Element)it.next();
                        ++i;
                    }
                    if (ServicesProjectBrowser.elementsBelongToValidProject(elements)) {
                        new PBCopyAction().run(elements);
                    }
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)viewer.getTree(), operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                super.dragOver(event);
                Object object = event.item.getData();
                if (object instanceof Entity) {
                    Entity entity = (Entity)object;
                    event.detail = entity.getUniqueName().getSubDomain().equals("Views") ? 1 : 0;
                }
            }

            public void drop(DropTargetEvent event) {
                Object object = event.item.getData();
                if (object instanceof Element) {
                    Element element = (Element)object;
                    if (ServicesProjectBrowser.elementBelongsToValidProject(element)) {
                        new PBPasteAction().run(element);
                    }
                    event.detail = 0;
                }
            }
        });
    }

    private void setSystemMenuEntries(GenericDataModelFilteredTreeViewer view) {
        final GenericDataModelFilteredTreeViewer viewer = view;
        this.mCloseAction = new Action(){
            static /* synthetic */ Class class$com$sap$ide$webdynpro$projectbrowser$views$ProjectBrowserView;

            public void run() {
                String projectName;
                Element element;
                ISelection sel = viewer.getTreeViewer().getSelection();
                if (sel instanceof StructuredSelection && (element = (Element)((StructuredSelection)sel).getFirstElement()) != null && (projectName = element.getModel().getUniqueName().getName()) != null && projectName.length() > 0) {
                    IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    try {
                        if (ServicesEclipse.closeProjectEditors((IProject)eclipseProject)) {
                            eclipseProject.close((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (CoreException e) {
                        ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$views$ProjectBrowserView == null ? (class$com$sap$ide$webdynpro$projectbrowser$views$ProjectBrowserView = 3.class$("com.sap.ide.webdynpro.projectbrowser.views.ProjectBrowserView")) : class$com$sap$ide$webdynpro$projectbrowser$views$ProjectBrowserView, "setSystemMenuEntries", "Could not close project", e, true);
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("Couldn't close Project. Reason: " + e.getMessage() + "."));
                    }
                }
                this.setEnabled(this.isEnabled());
                ProjectBrowserView.this.mOpenAction.setEnabled(ProjectBrowserView.this.mOpenAction.isEnabled());
            }

            public boolean isEnabled() {
                return this.hasOpenProjects();
            }

            private boolean hasOpenProjects() {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].isOpen()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("closeProject", this.mCloseAction);
        this.mOpenAction = new Action(){

            public void run() {
                ProjectBrowserView.this.mTreeViewer.getTreeViewer().setSelection(null);
                OpenProjectAction action = new OpenProjectAction((IWorkbenchSite)ProjectBrowserView.this.getSite());
                action.run();
                this.setEnabled(this.isEnabled());
                ProjectBrowserView.this.mCloseAction.setEnabled(ProjectBrowserView.this.mCloseAction.isEnabled());
            }

            public boolean isEnabled() {
                return this.hasCloseProjects();
            }

            private boolean hasCloseProjects() {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (!projects[i].isOpen()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("openProject", this.mOpenAction);
        this.copyAction = new Action(){

            public void run() {
                ISelection sel = viewer.getTreeViewer().getSelection();
                if (sel instanceof StructuredSelection) {
                    Element[] elements = new Element[((StructuredSelection)sel).size()];
                    Iterator it = ((StructuredSelection)sel).iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        elements[i] = (Element)it.next();
                        ++i;
                    }
                    if (ServicesProjectBrowser.elementsBelongToValidProject(elements)) {
                        new PBCopyAction().run(elements);
                    }
                }
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("copy", (IAction)this.copyAction);
        this.pasteAction = new Action(){

            public void run() {
                Element element;
                ISelection sel = viewer.getTreeViewer().getSelection();
                if (sel instanceof StructuredSelection && ServicesProjectBrowser.elementBelongsToValidProject(element = (Element)((StructuredSelection)sel).getFirstElement())) {
                    new PBPasteAction().run(element);
                }
            }
        };
        this.pasteAction.setEnabled(false);
        this.getViewSite().getActionBars().setGlobalActionHandler("paste", (IAction)this.pasteAction);
        this.initializeKeyBindingActions();
        IKeyBindingService keyBindingService = this.getViewSite().getKeyBindingService();
        this.registerKeyBindings(keyBindingService);
        viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ISelection sel = viewer.getTreeViewer().getSelection();
                if (sel instanceof StructuredSelection) {
                    if (((StructuredSelection)sel).size() == 1) {
                        Element element = (Element)((StructuredSelection)sel).getFirstElement();
                        if (ServicesProjectBrowser.elementBelongsToValidProject(element)) {
                            PBPasteAction pbPasteAction = new PBPasteAction();
                            ProjectBrowserView.this.pasteAction.setEnabled(pbPasteAction.isEnabled(element));
                        }
                    } else {
                        ProjectBrowserView.this.pasteAction.setEnabled(false);
                    }
                    Object[] objects = ((StructuredSelection)sel).toArray();
                    Element[] elements = new Element[objects.length];
                    int i = 0;
                    while (i < objects.length) {
                        if (objects[i] instanceof Element) {
                            elements[i] = (Element)objects[i];
                        }
                        ++i;
                    }
                    if (ServicesProjectBrowser.elementsBelongToValidProject(elements)) {
                        PBCopyAction pbCopyAction = new PBCopyAction();
                        ProjectBrowserView.this.copyAction.setEnabled(pbCopyAction.isEnabled(elements));
                    }
                } else {
                    ProjectBrowserView.this.copyAction.setEnabled(false);
                }
            }
        });
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == null) {
            return;
        }
        if (!(part instanceof IEditorPart)) {
            return;
        }
        DevelopmentObject developmentObject = ProjectBrowserView.getDevelopmentObjectFromEditor(part);
        this.mEditorEntity = SelenaService.getEntityFromDevelopmentObject(developmentObject);
        this.revealTree();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.mActivePart) {
            this.mActivePart = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.mActivePart = null;
    }

    public void partOpened(IWorkbenchPart part) {
        if (part == null) {
            return;
        }
        if (!(part instanceof IEditorPart)) {
            return;
        }
        DevelopmentObject developmentObject = ProjectBrowserView.getDevelopmentObjectFromEditor(part);
        if (this.mEditorEntity == null) {
            this.mEditorEntity = SelenaService.getEntityFromDevelopmentObject(developmentObject);
        }
    }

    private void createToolBar() {
        String value;
        RefreshAction refreshAction = new RefreshAction();
        CollapseAllAction collapseAllAction = new CollapseAllAction();
        ToggleLinkWithEditorAction toggleLinkWithEditorAction = new ToggleLinkWithEditorAction();
        if (((Hashtable)properties).containsKey(PROP_LINK_WITH_EDITOR) && (value = (String)((Hashtable)properties).get(PROP_LINK_WITH_EDITOR)).equals("true")) {
            toggleLinkWithEditorAction.setChecked(true);
            this.mShouldLinkWithEditor = true;
        }
        this.mToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.mToolBarManager.add((IAction)refreshAction);
        this.mToolBarManager.add((IContributionItem)new Separator());
        this.mToolBarManager.add((IAction)collapseAllAction);
        this.mToolBarManager.add((IAction)toggleLinkWithEditorAction);
    }

    private void revealTree() {
        if (this.mEditorEntity != null && this.mShouldLinkWithEditor) {
            this.getTreeViewer().getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.mEditorEntity), true);
        }
    }

    public void selectElement(Element element) {
        this.getTreeViewer().getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)element), true);
    }

    public static DevelopmentObject getDevelopmentObjectFromEditor(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        if (!(part instanceof IDevelopmentObjectEditor)) {
            return null;
        }
        return ((IDevelopmentObjectEditor)part).getDevelopmentObject();
    }

    private void readProperties() {
        try {
            File f = new File(ProjectBrowserPlugin.getDefault().getStateLocation() + "/prop.txt");
            if (f.exists()) {
                FileInputStream in = new FileInputStream(f);
                properties.load(in);
                in.close();
            }
        }
        catch (Exception e) {
            ProjectBrowserPlugin.internalError(((Object)((Object)this)).getClass(), "readProperties", "Failed loading properties", e, false);
        }
    }

    private void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(ProjectBrowserPlugin.getDefault().getStateLocation() + "/prop.txt");
            properties.store(out, "project_explorer");
            out.close();
        }
        catch (Exception e) {
            ProjectBrowserPlugin.internalError(((Object)((Object)this)).getClass(), "readProperties", "Failed saving properties", e, false);
        }
    }

    public void dispose() {
        if (this.mSelectedElement != null) {
            String projectName = this.mSelectedElement.getModel().getUniqueName().getName();
            UniqueName uin = this.mSelectedElement.getUniqueName();
            ((Hashtable)properties).put(PROP_PROJECT_NAME, projectName);
            ((Hashtable)properties).put(PROP_DOMAIN, uin.getDomain());
            ((Hashtable)properties).put(PROP_SUBDOMAIN, uin.getSubDomain());
            ((Hashtable)properties).put(PROP_LOCATION, uin.getLocation());
            ((Hashtable)properties).put(PROP_NAME, uin.getName());
        }
        this.saveProperties();
    }

    public IViewerSorterContainer getViewerSorterContainer() {
        if (this.viewerSorterContainer == null) {
            this.viewerSorterContainer = new ViewerSorterContainer();
            this.viewerSorterContainer.addViewerSorter((ViewerSorter)new WebDynproSorter());
        }
        return this.viewerSorterContainer;
    }

    private Model[] getTsModels(Element element) {
        Model tsModel = element.getModel();
        return new Model[]{tsModel};
    }

    private void initializeKeyBindingActions() {
        this.mDeployAction = new DeployAction();
        this.mDeployAction.setActionDefinitionId(DEPLOY_COMMAND_ID);
        this.mCreateArchiveAction = new CreateArchiveAction();
        this.mCreateArchiveAction.setActionDefinitionId(CREATEARCHIVE_COMMAND_ID);
        this.mReloadAction = new ReloadAction();
        this.mReloadAction.setActionDefinitionId(RELOAD_COMMAND_ID);
        this.mRepairProjectAction = new RepairProjectAction();
        this.mRepairProjectAction.setActionDefinitionId(REPAIRPROJECT_COMMAND_ID);
        this.mRemoveOrphanedTextsAction = new RemoveOrphanedTextsAction();
        this.mRemoveOrphanedTextsAction.setActionDefinitionId(ORPHANED_COMMAND_ID);
        this.mRawLanguageSupportAction = new RawLanguageSupportAction();
        this.mRawLanguageSupportAction.setActionDefinitionId(RAWLANGUAGE_COMMAND_ID);
    }

    private void registerKeyBindings(IKeyBindingService keyBindingService) {
        keyBindingService.setScopes(new String[]{"org.eclipse.ui.globalScope"});
        keyBindingService.registerAction((IAction)this.mDeployAction);
        keyBindingService.registerAction((IAction)this.mCreateArchiveAction);
        keyBindingService.registerAction((IAction)this.mReloadAction);
        keyBindingService.registerAction((IAction)this.mRepairProjectAction);
        keyBindingService.registerAction((IAction)this.mRemoveOrphanedTextsAction);
        keyBindingService.registerAction((IAction)this.mRawLanguageSupportAction);
    }

    static {
        properties = new Properties();
        PROP_LINK_WITH_EDITOR = "LinkWithEditor";
        PROP_TREE_REVEAL_STATE = "TreeRevealState";
        PROP_PROJECT_NAME = "PropertyProjectName";
        PROP_DOMAIN = "PropertyDomain";
        PROP_SUBDOMAIN = "PropertySubdomain";
        PROP_LOCATION = "PropertyLocation";
        PROP_NAME = "PropertyName";
    }

    private class RawLanguageSupportAction
    extends Action {
        private RawLanguageSupportAction() {
        }

        public void run() {
            new I18NRepairAction().run((Element[])ProjectBrowserView.this.getTsModels(ProjectBrowserView.this.mSelectedElement));
        }
    }

    private class RemoveOrphanedTextsAction
    extends Action {
        private RemoveOrphanedTextsAction() {
        }

        public void run() {
            new LanguageRepairAction().run((Element[])ProjectBrowserView.this.getTsModels(ProjectBrowserView.this.mSelectedElement));
        }
    }

    private class RepairProjectAction
    extends Action {
        private RepairProjectAction() {
        }

        public void run() {
            new PBRepairProjectAction().run((Element)ProjectBrowserView.this.getTsModels(ProjectBrowserView.this.mSelectedElement)[0]);
        }
    }

    private class CreateArchiveAction
    extends Action {
        private CreateArchiveAction() {
        }

        public void run() {
            new PBGenerateParAction().run((Element)ProjectBrowserView.this.getTsModels(ProjectBrowserView.this.mSelectedElement)[0]);
        }
    }

    private class ReloadAction
    extends Action {
        private ReloadAction() {
        }

        public void run() {
            new ReloadMetadataAction().run((Element[])ProjectBrowserView.this.getTsModels(ProjectBrowserView.this.mSelectedElement));
        }
    }

    private class DeployAction
    extends Action {
        private DeployAction() {
        }

        public void run() {
            new PBDeployParAction().run((Element[])ProjectBrowserView.this.getTsModels(ProjectBrowserView.this.mSelectedElement));
        }
    }

    private class TreeSelectionListener
    implements ISelectionChangedListener {
        private TreeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection structuredSelection;
            Object object;
            ISelection selection;
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (part instanceof ProjectBrowserView && (selection = event.getSelection()) instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Element) {
                ProjectBrowserView.this.mSelectedElement = (Element)object;
            }
        }
    }

    private class ToggleLinkWithEditorAction
    extends Action {
        private ToggleLinkWithEditorAction() {
        }

        public void run() {
            if (this.isChecked()) {
                ProjectBrowserView.this.mShouldLinkWithEditor = true;
                ProjectBrowserView.this.revealTree();
            } else {
                ProjectBrowserView.this.mShouldLinkWithEditor = false;
            }
            ((Hashtable)properties).put(PROP_LINK_WITH_EDITOR, new String(new Boolean(ProjectBrowserView.this.mShouldLinkWithEditor).toString()));
            ProjectBrowserView.this.mToolBarManager.update(true);
        }

        public int getStyle() {
            return 2;
        }

        public String getToolTipText() {
            return mTPool.getText(133);
        }

        public ImageDescriptor getImageDescriptor() {
            return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_LINK_WITH_EDITOR);
        }
    }

    private class CollapseAllAction
    extends Action {
        private CollapseAllAction() {
        }

        public void run() {
            ProjectBrowserView.this.getTreeViewer().getTreeViewer().collapseAll();
        }

        public String getToolTipText() {
            return mTPool.getText(132);
        }

        public ImageDescriptor getImageDescriptor() {
            return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_COLLAPSE_ALL);
        }
    }

    private class RefreshAction
    extends Action {
        private RefreshAction() {
        }

        public void run() {
            Model selenaModel;
            Entity[] entities;
            ISelection sel = ProjectBrowserView.this.getTreeViewer().getTreeViewer().getSelection();
            MMRefreshAction mmRefreshAction = new MMRefreshAction();
            if (!sel.isEmpty()) {
                if (sel instanceof StructuredSelection) {
                    StructuredSelection structuredSelection = (StructuredSelection)sel;
                    Model[] selenaModels = new Model[structuredSelection.size()];
                    Iterator it = structuredSelection.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        selenaModels[i] = ((Element)it.next()).getModel();
                        ++i;
                    }
                    if (ServicesProjectBrowser.elementsBelongToValidProject((Element[])selenaModels) && mmRefreshAction.isAvailable((Element[])selenaModels)) {
                        mmRefreshAction.run((Element[])selenaModels);
                    }
                }
            } else if (ProjectBrowserView.this.mEditorEntity != null && ServicesProjectBrowser.elementBelongsToValidProject((Element)ProjectBrowserView.this.mEditorEntity) && mmRefreshAction.isAvailable((Element[])(entities = new Entity[]{selenaModel = ProjectBrowserView.this.mEditorEntity.getModel()}))) {
                mmRefreshAction.run((Element[])entities);
            }
        }

        public String getToolTipText() {
            String refresh = TextPool.getInstance().getText(408);
            return refresh;
        }

        public ImageDescriptor getImageDescriptor() {
            return SapIdeUtilImages.getSapImageDescriptor((ISapImage)MetamodelImage.ICON_REFRESH_ECLIPSE);
        }
    }

    private class PBKeyListener
    extends KeyAdapter {
        private PBKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.character == '\u007f') {
                IStructuredSelection sel = ProjectBrowserView.this.getTreeViewer().getCurrentViewerContext().getStructuredSelection();
                Object[] selectedObjects = sel.toArray();
                int i = 0;
                while (i < selectedObjects.length) {
                    if (selectedObjects[i] instanceof Entity) {
                        String projectName;
                        Entity entity = (Entity)selectedObjects[i];
                        if (!ServicesProjectBrowser.elementBelongsToValidProject((Element)entity)) {
                            return;
                        }
                        if (SelenaElementUtil.isProjectModelUniqueName((UniqueName)entity.getUniqueName()) && ServicesEclipse.projectHasComponentNature((String)(projectName = entity.getModel().getUniqueName().getName()))) {
                            return;
                        }
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < selectedObjects.length) {
                    if (selectedObjects[i2] instanceof Entity) {
                        PBDeleteStructureAction deleteStructureAction;
                        Entity entity = (Entity)selectedObjects[i2];
                        Element[] elements = new Element[]{entity};
                        String domain = entity.getUniqueName().getDomain();
                        String subDomain = entity.getUniqueName().getSubDomain();
                        if (SelenaElementUtil.isProjectModelUniqueName((UniqueName)entity.getUniqueName())) {
                            PBDeleteProjectAction deleteProjectAction = new PBDeleteProjectAction();
                            deleteProjectAction.run((Element)entity);
                        } else if (domain.equals("WebDynpro")) {
                            PBDeletionAction deletionAction = new PBDeletionAction();
                            if (deletionAction.isAvailable((Element)entity)) {
                                deletionAction.run((Element)entity);
                            }
                        } else if (subDomain.equals("SimpleType")) {
                            PBDeleteSimpletypeAction deleteStAction = new PBDeleteSimpletypeAction();
                            if (deleteStAction.isAvailable(elements)) {
                                deleteStAction.run(elements);
                            }
                        } else if (subDomain.equals("Structure") && (deleteStructureAction = new PBDeleteStructureAction()).isAvailable(elements)) {
                            deleteStructureAction.run(elements);
                        }
                    }
                    ++i2;
                }
            }
        }
    }
}

