/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.services;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.services.GenerationPathManager;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.projectbrowser.services.ImageManager;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;

public class ServicesProjectBrowser {
    private static final String JAVA_EXTENSION = ".java";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String TXT_EXTENSION = ".txt";
    private static final String REFERENCES = "references";

    private static boolean hasWebDynproNature(Element element) {
        if (element == null) {
            return false;
        }
        Model model = element.getModel();
        if (model == null) {
            return false;
        }
        UniqueName uniqueName = model.getUniqueName();
        String projectName = uniqueName.getName();
        return ServicesEclipse.projectHasWebDynproNature((String)projectName);
    }

    public static boolean isValidWebDynproProject(Element element) {
        return ServicesProjectBrowser.isValidWebDynproProject(new Element[]{element});
    }

    public static boolean isValidWebDynproProject(Element[] elements) {
        boolean hasWdNature = false;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] == null) {
                return false;
            }
            if (elements[i].getModel() == null) {
                return false;
            }
            if (!SelenaElementUtil.isProjectModelUniqueName((UniqueName)elements[i].getModel().getUniqueName())) {
                return false;
            }
            if (!ServicesProjectBrowser.hasWebDynproNature(elements[i])) {
                return false;
            }
            hasWdNature = true;
            ++i;
        }
        return hasWdNature;
    }

    public static boolean elementBelongsToValidProject(Element element) {
        if (!(element instanceof Entity)) {
            return false;
        }
        Model selenaModel = ((Entity)element).getModel();
        if (selenaModel == null) {
            return false;
        }
        if (!SelenaElementUtil.isProjectModelUniqueName((UniqueName)selenaModel.getUniqueName())) {
            return false;
        }
        return ServicesProjectBrowser.isValidWebDynproProject(element);
    }

    public static boolean elementsBelongToValidProject(Element[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!ServicesProjectBrowser.elementBelongsToValidProject(elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isJavaFile(Element element) {
        return element.getUniqueName().getLocation().endsWith(JAVA_EXTENSION);
    }

    public static boolean isPropertiesFile(Element element) {
        return element.getUniqueName().getLocation().endsWith(PROPERTIES_EXTENSION);
    }

    public static boolean isReferencesFile(Element element) {
        return element.getUniqueName().getLocation().endsWith("references.txt");
    }

    public static boolean isRootFolder(Element element) {
        String parentName = element.getParent().getUniqueName().getName();
        String projectName = element.getModel().getUniqueName().getName();
        return parentName.equals(projectName);
    }

    public static boolean isSourceFolder(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject eclipseProject = workspaceRoot.getProject(projectName);
        String[] allValidRoots = GenerationPathManager.getValidSourcePaths((IProject)eclipseProject);
        String elementLocation = element.getUniqueName().getLocation();
        if (elementLocation.length() > 0) {
            elementLocation = elementLocation.substring(1);
        }
        int i = 0;
        while (i < allValidRoots.length) {
            if (allValidRoots[i].startsWith(elementLocation)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isInMimesFolder(Element element) {
        String mimesFolder;
        String elementLocation = element.getUniqueName().getLocation();
        return elementLocation.indexOf(mimesFolder = "src/mimes") != -1;
    }

    public static boolean isInPackagesFolder(Element element) {
        String elementLocation = element.getUniqueName().getLocation();
        String sourceFolder = "src";
        String packagesFolder = "packages";
        String completePackagesFolder = sourceFolder + "/" + packagesFolder;
        return elementLocation.indexOf(completePackagesFolder) != -1;
    }

    public static boolean isInConfigurationFolder(Element element) {
        String elementLocation = element.getUniqueName().getLocation();
        String sourceFolder = "src";
        String configurationFolder = "configuration";
        String completeConfigurationFolder = sourceFolder + "/" + configurationFolder;
        return elementLocation.indexOf(completeConfigurationFolder) != -1;
    }

    public static boolean isInSourceFolder(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject eclipseProject = workspaceRoot.getProject(projectName);
        String[] allValidRoots = GenerationPathManager.getValidSourcePaths((IProject)eclipseProject);
        String elementLocation = element.getUniqueName().getLocation();
        if (elementLocation.length() > 0) {
            elementLocation = elementLocation.substring(1);
        }
        String sourceFolder = "src";
        int i = 0;
        while (i < allValidRoots.length) {
            if (elementLocation.indexOf(allValidRoots[i]) != -1 || elementLocation.indexOf(sourceFolder) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Component findParentComponent(Element element) {
        if (element == null) {
            return null;
        }
        Component parentComponent = null;
        String projectName = element.getModel().getUniqueName().getName();
        if (projectName == null || projectName.length() <= 0) {
            return null;
        }
        UniqueName parentUin = element.getParent().getUniqueName();
        if (parentUin.getSubDomain().equals("Component")) {
            DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
            DevelopmentObject developmentObject = null;
            if (manager != null) {
                developmentObject = manager.getDevelopmentObject(parentUin);
            }
            if (developmentObject != null && developmentObject instanceof Component) {
                parentComponent = (Component)developmentObject;
            }
            if (parentComponent != null) {
                return parentComponent;
            }
        }
        return null;
    }

    public static ComponentInterfaceDefinition findParentComponentInterfaceDefinition(Element selenaElement) {
        if (selenaElement == null) {
            return null;
        }
        ComponentInterfaceDefinition parentCID = null;
        String projectName = selenaElement.getModel().getUniqueName().getName();
        if (projectName == null || projectName.length() <= 0) {
            return null;
        }
        UniqueName parentUin = selenaElement.getParent().getUniqueName();
        if (parentUin.getSubDomain().equals("ComponentInterfaceDefinition")) {
            DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
            DevelopmentObject developmentObject = null;
            if (manager != null) {
                developmentObject = manager.getDevelopmentObject(parentUin);
            }
            if (developmentObject != null && developmentObject instanceof ComponentInterfaceDefinition) {
                parentCID = (ComponentInterfaceDefinition)developmentObject;
            }
            if (parentCID != null) {
                return parentCID;
            }
        }
        return null;
    }

    public static WebDynproRoot findParentRoot(Element element) {
        WebDynproRoot webDynproRoot;
        if (element == null) {
            return null;
        }
        Object parentRoot = null;
        String projectName = element.getModel().getUniqueName().getName();
        if (projectName == null || projectName.length() <= 0) {
            return null;
        }
        UniqueName parentUin = element.getParent().getUniqueName();
        if (parentUin.getSubDomain().equals("WebDynpro") && (webDynproRoot = MetamodelServices.getWebDynproRoot((String)projectName)) != null) {
            return webDynproRoot;
        }
        return null;
    }

    public static boolean callRenameWizard(DevelopmentObject developmentObject) {
        int finished = 1;
        if (developmentObject instanceof View) {
            finished = com.sap.ide.webdynpro.service.viewdesigner.ServiceWithUI.renameView((View)((View)developmentObject));
        } else if (developmentObject instanceof Window) {
            finished = CreationWithUI.renameWindow((Window)((Window)developmentObject));
        } else if (developmentObject instanceof Component) {
            finished = CreationWithUI.renameComponent((Component)((Component)developmentObject));
        } else if (developmentObject instanceof Controller) {
            finished = com.sap.ide.webdynpro.service.controllereditor.ServiceWithUI.renameCustomController((Controller)((Controller)developmentObject));
        } else if (developmentObject instanceof ComponentInterfaceDefinition) {
            finished = CreationWithUI.renameComponentInterfaceDefinition((ComponentInterfaceDefinition)((ComponentInterfaceDefinition)developmentObject));
        } else if (developmentObject instanceof InterfaceView) {
            finished = CreationWithUI.renameInterfaceView((InterfaceView)((InterfaceView)developmentObject));
        } else if (developmentObject instanceof ModelClass) {
            finished = ServiceWithUI.renameModelClass((ModelClass)((ModelClass)developmentObject));
        }
        return finished == 0;
    }

    public static IProject getEclipseProject(Element element) {
        if (element == null) {
            return null;
        }
        String projectName = element.getModel().getUniqueName().getName();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return workspaceRoot.getProject(projectName);
    }

    public static Image getImage(Element element) {
        if (element == null) {
            return null;
        }
        UniqueName uniqueName = element.getUniqueName();
        return ImageManager.getInstance().getCorrespondingImage(uniqueName);
    }

    public static boolean askUserToEditOutsideDiagramView() {
        TextPool textPool = TextPool.getInstance();
        MessageDialog dialog = UIHelper.createMessageDialogToDecide((String)textPool.getText(500), (String)textPool.getText(501), (int)4, (int)1);
        return dialog.open() == 0;
    }

    public static void openWindowDiagram(Element element) {
        while (element != null && !element.getUniqueName().getSubDomain().equals("Window")) {
            element = element.getParent();
        }
        if (element != null) {
            Utils.openDiagram((Element)element);
        }
    }
}

