/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.services;

import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.MessagePool;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.projectbrowser.actions.PBEditWindowAction;
import com.sap.ide.webdynpro.projectbrowser.actions.PBOpenDataViewAction;
import com.sap.ide.webdynpro.tsmodel.application.provider.ComponentUsageConfigurationControllerNodeProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.ComponentUsageInterfaceControllerNodeProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import java.util.HashMap;

public class SelenaService {
    public static Entity getEntityFromDevelopmentObject(DevelopmentObject developmentObject) {
        if (developmentObject == null) {
            return null;
        }
        UniqueName entityUIN = null;
        String projectName = developmentObject.getMetamodel().getName();
        UniqueName modelUIN = ModelAccess.createModelUniqueName((String)projectName);
        Model model = ModelAccess.getModel((UniqueName)modelUIN);
        if (developmentObject instanceof Controller) {
            AbstractView aView;
            Controller controller = (Controller)developmentObject;
            if (controller.getType().equals(ControllerTypeEnum.VIEW)) {
                AbstractView aView2 = controller.getView();
                if (aView2 instanceof View) {
                    View view = (View)aView2;
                    entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)view, (String)"View");
                }
            } else if (controller.getType().equals(ControllerTypeEnum.CUSTOM)) {
                entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)controller, (String)"CustomController");
            } else if (controller.getType().equals(ControllerTypeEnum.COMPONENT)) {
                entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)controller, (String)"ComponentController");
            } else if (controller.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
                DevelopmentObject parentObject = controller.getParent();
                if (parentObject instanceof ComponentInterfaceDefinition) {
                    ComponentInterfaceDefinition parentCompInt = (ComponentInterfaceDefinition)parentObject;
                    entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)controller, (String)"CIDConfigurationController");
                } else if (parentObject instanceof ComponentInterface) {
                    ComponentInterface parentCompInt = (ComponentInterface)parentObject;
                    entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)controller, (String)"ConfigurationController");
                }
            } else if (controller.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
                DevelopmentObject parentObject = controller.getParent();
                if (parentObject instanceof ComponentInterfaceDefinition) {
                    entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)controller, (String)"CIDInterfaceController");
                } else if (parentObject instanceof ComponentInterface) {
                    entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)controller, (String)"InterfaceController");
                }
            } else if (controller.getType().equals(ControllerTypeEnum.INTERFACE_VIEW) && (aView = controller.getView()) instanceof InterfaceView) {
                InterfaceView interfaceView = (InterfaceView)aView;
                DevelopmentObject parentObject = interfaceView.getParent();
                if (parentObject instanceof ComponentInterfaceDefinition) {
                    entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)interfaceView, (String)"InterfaceViewDefinition");
                } else if (parentObject instanceof ComponentInterface) {
                    entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)interfaceView, (String)"InterfaceView");
                }
            }
        } else if (developmentObject instanceof ComponentControllerUsage) {
            ComponentControllerUsage componentControllerUsage = (ComponentControllerUsage)developmentObject;
            ComponentUsage componentUsage = componentControllerUsage.getComponentUsage();
            ComponentInterface usedComponentInterface = componentUsage.getUsedComponent();
            Controller usedController = componentControllerUsage.getUsedComponentController();
            if (usedController.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
                Controller usedCfgController = usedComponentInterface.getConfigurationController();
                entityUIN = ComponentUsageConfigurationControllerNodeProvider.createComponentUsageConfigurationControllerUniqueName((ComponentUsage)componentUsage, (Controller)usedCfgController);
            } else if (usedController.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
                Controller interfaceController = usedComponentInterface.getInterfaceController();
                entityUIN = ComponentUsageInterfaceControllerNodeProvider.createComponentUsageInterfaceControllerUniqueName((ComponentUsage)componentUsage, (Controller)interfaceController);
            }
        } else if (developmentObject instanceof Application) {
            Application application = (Application)developmentObject;
            entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)application, (String)"Application");
        } else if (developmentObject instanceof ModelClass) {
            ModelClass modelClass = (ModelClass)developmentObject;
            entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)modelClass, (String)"ModelClass");
        } else if (developmentObject instanceof MessagePool) {
            MessagePool messagePool = (MessagePool)developmentObject;
            entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)messagePool, (String)"MessagePool");
        } else if (developmentObject instanceof Component) {
            Component component = (Component)developmentObject;
            entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)component, (String)"Component");
        } else if (developmentObject instanceof Window) {
            Window window = (Window)developmentObject;
            entityUIN = com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager.createUniqueName((DevelopmentObject)window, (String)"Window");
        } else if (developmentObject instanceof DtSimpleType) {
            DtSimpleType st = (DtSimpleType)developmentObject;
            String logDicName = null;
            logDicName = st.hasLogicalDictionary() ? st.getLogicalDictionary().getName() : "Local Dictionary";
            entityUIN = DataSourceManager.createUniqueName((DevelopmentObject)st, (String)"SimpleType", (String)logDicName);
        } else if (developmentObject instanceof DtGeneralStructure) {
            DtGeneralStructure dtStructure = (DtGeneralStructure)developmentObject;
            String logDicName = null;
            logDicName = dtStructure.hasLogicalDictionary() ? dtStructure.getLogicalDictionary().getName() : "Local Dictionary";
            entityUIN = DataSourceManager.createUniqueName((DevelopmentObject)dtStructure, (String)"Structure", (String)logDicName);
        } else {
            return null;
        }
        return model.findEntity(entityUIN);
    }

    public static boolean closeSelenaDiagram(Entity entity) {
        if (entity == null) {
            return false;
        }
        ReferenceCollection referenceCollection = Utils.getDiagram((Element)entity);
        com.tssap.selena.model.view.View view = GdePlugin.getDefault().getView(referenceCollection);
        if (view == null) {
            return false;
        }
        view.dispose();
        return true;
    }

    public static HashMap closeAllSelenaDiagrams(Component component) {
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
        Boolean closedDataModeler = SelenaService.closeDataModeler(component);
        map.put(component, closedDataModeler);
        Window[] windows = component.getWindows();
        int i = 0;
        while (i < windows.length) {
            Boolean closedNavModeler = SelenaService.closeNavigationModeler(windows[i]);
            map.put(windows[i], closedNavModeler);
            ++i;
        }
        return map;
    }

    public static Boolean closeDataModeler(Component component) {
        Entity componentEntity = SelenaService.getEntityFromDevelopmentObject((DevelopmentObject)component);
        return new Boolean(SelenaService.closeSelenaDiagram(componentEntity));
    }

    public static Boolean closeNavigationModeler(Window window) {
        Entity windowEntity = SelenaService.getEntityFromDevelopmentObject((DevelopmentObject)window);
        return new Boolean(SelenaService.closeSelenaDiagram(windowEntity));
    }

    public static void openNavigationModeler(Window window) {
        Entity windowEntity = SelenaService.getEntityFromDevelopmentObject((DevelopmentObject)window);
        new PBEditWindowAction().run(new Element[]{windowEntity});
    }

    public static void openDataModeler(Component component) {
        Entity componentEntity = SelenaService.getEntityFromDevelopmentObject((DevelopmentObject)component);
        new PBOpenDataViewAction().run(new Element[]{componentEntity});
    }

    public static void openAllSelenaDiagrams(Component component) {
        SelenaService.openDataModeler(component);
        Window[] windows = component.getWindows();
        int i = 0;
        while (i < windows.length) {
            SelenaService.openNavigationModeler(windows[i]);
            ++i;
        }
    }
}

