/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.launch;

import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.launch.AbstractLaunchConfigTab;
import com.sap.ide.webdynpro.projectbrowser.launch.LaunchService;
import com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.dialog.selection.SelectWDApplicationDialog;
import com.sap.ide.webdynpro.ui.dialog.selection.SelectWDProjectDialog;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.sap.ide.webdynpro.ui.service.DialogService;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WDLaunchTab
extends AbstractLaunchConfigTab
implements IJavaLaunchConfigurationConstants {
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String CREATE_ARCHIVE = mTPool.getText(303);
    private Label mProjectLabel;
    private Text mProjectField;
    private Button mProjectButton;
    private Label mApplicationLabel;
    private Text mApplicationField;
    private Button mApplicationButton;
    private Button mSelectDeployCheckBox;
    private String mSelectedProject;
    private String mSelectedApplicationName;
    private Application mSelectedApplication;
    private String mSelectedRunMode;

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        root.setLayout((Layout)gridLayout);
        GridData rootGridData = new GridData(1808);
        rootGridData.widthHint = 400;
        rootGridData.heightHint = 400;
        root.setLayoutData((Object)rootGridData);
        this.setControl((Control)root);
        IGridLayoutPane dialogPane = PaneFactory.createGridLayoutPane((Composite)root, (int)2);
        GridData paneGridData = new GridData(1808);
        dialogPane.setLayoutData((Object)paneGridData);
        this.mProjectLabel = dialogPane.addTextLabel(LaunchService.PROJECT);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.mProjectLabel.setLayoutData((Object)gd);
        IGridLayoutData gridLayoutData = dialogPane.createGridLayoutData(4, 4, true, false);
        this.mProjectField = dialogPane.addTextField("", false, gridLayoutData);
        this.mProjectField.setEditable(false);
        this.mProjectField.addModifyListener((ModifyListener)new ProjectModifyListener());
        GridData projectGridData = new GridData(768);
        projectGridData.widthHint = 200;
        this.mProjectField.setLayoutData((Object)projectGridData);
        this.mProjectButton = dialogPane.addPushButton(LaunchService.BROWSE);
        this.mProjectButton.addSelectionListener((SelectionListener)new BrowseProjectListener());
        this.mApplicationLabel = dialogPane.addTextLabel(LaunchService.WDAPPLICATION);
        GridData gdApp = new GridData();
        gd.horizontalSpan = 2;
        this.mApplicationLabel.setLayoutData((Object)gdApp);
        dialogPane.addPlaceholder();
        gridLayoutData = dialogPane.createGridLayoutData(4, 4, true, false);
        this.mApplicationField = dialogPane.addTextField("", false, gridLayoutData);
        this.mApplicationField.setEditable(false);
        this.mApplicationField.addModifyListener((ModifyListener)new ApplicationModifyListener());
        GridData appGridData = new GridData(768);
        appGridData.widthHint = 200;
        this.mApplicationField.setLayoutData((Object)appGridData);
        this.mApplicationButton = dialogPane.addPushButton(LaunchService.BROWSE);
        this.mApplicationButton.addSelectionListener((SelectionListener)new BrowseApplicationListener());
        gridLayoutData = dialogPane.createGridLayoutData(4, 4, true, false);
        this.mSelectDeployCheckBox = dialogPane.addCheckBox(CREATE_ARCHIVE, false, gridLayoutData);
        this.mSelectDeployCheckBox.addSelectionListener((SelectionListener)new RunModeSelectionListener());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy pConfig) {
        String projectName = null;
        Element selenaElement = this.getElement();
        if (selenaElement != null && (projectName = selenaElement.getModel().getUniqueName().getName()) != null) {
            pConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
        }
        if (projectName == null) {
            return;
        }
        Application[] applications = this.getProjectApplications(projectName);
        if (applications != null && applications.length > 0) {
            WDLaunchConfigurationDelegate.setApplicationName(pConfig, applications[0].getName());
            WDLaunchConfigurationDelegate.setApplicationPackage(pConfig, applications[0].getPackage());
        }
        WDLaunchConfigurationDelegate.setRunMode(pConfig, "RUN_ONLY");
        pConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String projectName;
        try {
            projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(((Object)((Object)this)).getClass(), "initializeFrom", "Could not load attribute 'ProjectName' from StartConfiguration", e, false);
            projectName = "";
        }
        this.mProjectField.setText(projectName);
        String appName = WDLaunchConfigurationDelegate.getApplicationName(configuration);
        if (appName != null) {
            this.mApplicationField.setText(appName);
        } else {
            this.mApplicationField.setText("");
        }
        String runMode = WDLaunchConfigurationDelegate.getRunMode(configuration);
        if (runMode != null) {
            if (runMode.equals("RUN_ONLY")) {
                this.mSelectDeployCheckBox.setSelection(false);
                this.mSelectedRunMode = "RUN_ONLY";
            } else if (runMode.equals("RUN_WITH_DEPLOYMENT")) {
                this.mSelectDeployCheckBox.setSelection(true);
                this.mSelectedRunMode = "RUN_WITH_DEPLOYMENT";
            }
        } else {
            this.mSelectDeployCheckBox.setSelection(true);
            this.mSelectedRunMode = "RUN_WITH_DEPLOYMENT";
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy pConfig) {
        pConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.mProjectField.getText());
        WDLaunchConfigurationDelegate.setProjectName(pConfig, this.mProjectField.getText());
        if (this.mSelectedApplication != null) {
            WDLaunchConfigurationDelegate.setApplicationName(pConfig, this.mSelectedApplication.getName());
            WDLaunchConfigurationDelegate.setApplicationPackage(pConfig, this.mSelectedApplication.getPackage());
        }
        WDLaunchConfigurationDelegate.setRunMode(pConfig, this.mSelectedRunMode);
    }

    public String getName() {
        return mTPool.getText(300);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = this.mProjectField.getText().trim();
        IStatus projectStatus = LaunchService.isValidProject(projectName);
        if (projectStatus.getSeverity() == 4) {
            this.setErrorMessage(projectStatus.getMessage());
            return false;
        }
        String applicationName = WDLaunchConfigurationDelegate.getApplicationName(configuration);
        String applicationPackage = WDLaunchConfigurationDelegate.getApplicationPackage(configuration);
        if (applicationName == null || applicationPackage == null) {
            return false;
        }
        if (applicationName.length() > 0) {
            if (projectName != null) {
                DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
                if (manager != null) {
                    WebDynproRoot root = manager.getWebDynproRoot();
                    if (root != null) {
                        boolean hasApplication = root.hasApplication(applicationPackage, applicationName);
                        if (!hasApplication) {
                            this.setErrorMessage(LaunchService.INVALID_APPLICATION);
                            return false;
                        }
                    } else {
                        ProjectBrowserPlugin.internalError(((Object)((Object)this)).getClass(), "isValid", "WebDynproRoot not found", null, true);
                    }
                } else {
                    ProjectBrowserPlugin.internalError(((Object)((Object)this)).getClass(), "isValid", "DatSourceManager not found", null, true);
                }
            }
        } else {
            this.setErrorMessage(LaunchService.NO_APPLICATION);
            return false;
        }
        return true;
    }

    public Image getImage() {
        return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_APPLICATION);
    }

    private Application[] getProjectApplications(String projectName) {
        if (projectName != null && projectName.length() > 0) {
            Application[] applications = null;
            try {
                WebDynproRoot root;
                DataSourceManager manager;
                if (ServicesEclipse.projectHasWebDynproNature((String)projectName) && (manager = DataSourceManager.getDataSourceManager((String)projectName)) != null && (root = manager.getWebDynproRoot()) != null) {
                    applications = root.getApplications();
                }
            }
            catch (LoadException e) {
                ProjectBrowserPlugin.internalError(((Object)((Object)this)).getClass(), "getProjectApplications", "Error: failed loading applications", e, false);
            }
            if (applications != null) {
                return applications;
            }
        }
        return new Application[0];
    }

    private class RunModeSelectionListener
    extends SelectionAdapter {
        private RunModeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button.getSelection()) {
                WDLaunchTab.this.mSelectedRunMode = "RUN_WITH_DEPLOYMENT";
            } else {
                WDLaunchTab.this.mSelectedRunMode = "RUN_ONLY";
            }
            WDLaunchTab.super.updateLaunchConfigurationDialog();
        }
    }

    class BrowseApplicationListener
    extends SelectionAdapter {
        BrowseApplicationListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Application[] applications = WDLaunchTab.this.getProjectApplications(WDLaunchTab.this.mProjectField.getText());
            SelectWDApplicationDialog dialog = DialogService.displaySelectApplicationDialog((Application[])applications);
            Application selectedApplication = dialog.getApplication();
            if (selectedApplication != null) {
                WDLaunchTab.this.mSelectedApplication = selectedApplication;
                WDLaunchTab.this.mApplicationField.setText(selectedApplication.getName());
                WDLaunchTab.this.mSelectedApplicationName = selectedApplication.getName();
                WDLaunchTab.super.updateLaunchConfigurationDialog();
            } else {
                WDLaunchTab.this.mSelectedApplication = null;
                WDLaunchTab.this.mApplicationField.setText("");
            }
        }
    }

    class BrowseProjectListener
    extends SelectionAdapter {
        BrowseProjectListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SelectWDProjectDialog dialog = DialogService.displaySelectProjectDialog();
            IJavaProject javaProject = dialog.getResult();
            if (javaProject != null) {
                WDLaunchTab.this.mProjectField.setText(javaProject.getElementName());
                WDLaunchTab.this.mSelectedProject = javaProject.getElementName();
                WDLaunchTab.super.updateLaunchConfigurationDialog();
            } else {
                WDLaunchTab.this.mProjectField.setText("");
            }
            WDLaunchTab.this.mApplicationField.setText("");
            WDLaunchTab.this.mSelectedApplication = null;
        }
    }

    class ApplicationModifyListener
    implements ModifyListener {
        ApplicationModifyListener() {
        }

        public void modifyText(ModifyEvent evt) {
            WDLaunchTab.this.mSelectedApplicationName = WDLaunchTab.this.mApplicationField.getText();
            WDLaunchTab.super.updateLaunchConfigurationDialog();
        }
    }

    class ProjectModifyListener
    implements ModifyListener {
        ProjectModifyListener() {
        }

        public void modifyText(ModifyEvent evt) {
            WDLaunchTab.this.mSelectedProject = WDLaunchTab.this.mProjectField.getText();
            WDLaunchTab.super.updateLaunchConfigurationDialog();
        }
    }
}

