/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.launch;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.actions.PBDeployAndRunApplicationAction;
import com.sap.ide.webdynpro.projectbrowser.actions.PBRunApplicationAction;
import com.sap.ide.webdynpro.projectbrowser.launch.LaunchService;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;

public class WDLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    protected static final String ATTR_APPLICATION_NAME = "APPLICATION_NAME";
    protected static final String ATTR_APPLICATION_PACKAGE = "APPLICATION_PACKAGE";
    protected static final String ATTR_PROJECT_NAME = "PROJECT_NAME";
    protected static final String ATTR_RUN_MODE = "RUN_MODE";
    protected static final String RUN_ONLY = "RUN_ONLY";
    protected static final String RUN_WITH_DEPLOYMENT = "RUN_WITH_DEPLOYMENT";
    private TextPool mTPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Entity applicationEntity;
        String projName = WDLaunchConfigurationDelegate.getProjectName(configuration);
        String appName = WDLaunchConfigurationDelegate.getApplicationName(configuration);
        String appPackage = WDLaunchConfigurationDelegate.getApplicationPackage(configuration);
        String runMode = WDLaunchConfigurationDelegate.getRunMode(configuration);
        IStatus projectStatus = LaunchService.isValidProject(projName);
        if (projectStatus.getSeverity() == 4) {
            LaunchService.displayAsyncMessage(projectStatus);
            return;
        }
        if (appName == null || appName.length() == 0 || appPackage == null || appPackage.length() == 0 || runMode == null || runMode.length() == 0) {
            return;
        }
        Application application = null;
        WebDynproRoot root = null;
        DataSourceManager manager = null;
        if (ServicesEclipse.projectHasWebDynproNature((String)projName)) {
            manager = DataSourceManager.getDataSourceManager((String)projName);
        }
        if (manager != null) {
            root = manager.getWebDynproRoot();
        }
        try {
            if (root != null) {
                application = root.getApplication(appPackage, appName);
            }
        }
        catch (LoadException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = WDLaunchConfigurationDelegate.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "launch", "Could not load WDApplication", e, true);
        }
        if (application == null) {
            return;
        }
        UniqueName applicationUIN = DataSourceManager.createUniqueName((DevelopmentObject)application, (String)"Application");
        UniqueName uname = ModelAccess.createModelUniqueName((String)projName);
        Model model = ModelAccess.getModel((UniqueName)uname);
        if (model != null && (applicationEntity = model.findEntity(applicationUIN)) != null) {
            if (runMode.equals(RUN_ONLY)) {
                new PBRunApplicationAction().run((Element)applicationEntity);
            } else if (runMode.equals(RUN_WITH_DEPLOYMENT)) {
                new PBDeployAndRunApplicationAction().run((Element)applicationEntity);
            }
        }
    }

    public static void setApplicationName(ILaunchConfigurationWorkingCopy config, String applicationName) {
        config.setAttribute(ATTR_APPLICATION_NAME, applicationName);
    }

    public static String getApplicationName(ILaunchConfiguration configuration) {
        try {
            String applicationName = configuration.getAttribute(ATTR_APPLICATION_NAME, "");
            if (0 == applicationName.length()) {
                return null;
            }
            return applicationName;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = WDLaunchConfigurationDelegate.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getApplicationName", "Error: failed getting attribute 'ATTR_APPLICATION_NAME'", e, false);
            return null;
        }
    }

    public static void setApplicationPackage(ILaunchConfigurationWorkingCopy config, String applicationPackage) {
        config.setAttribute(ATTR_APPLICATION_PACKAGE, applicationPackage);
    }

    public static String getApplicationPackage(ILaunchConfiguration configuration) {
        try {
            String applicationPackage = configuration.getAttribute(ATTR_APPLICATION_PACKAGE, "");
            if (applicationPackage.length() == 0) {
                return null;
            }
            return applicationPackage;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = WDLaunchConfigurationDelegate.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getApplicationPackage", "Error: failed getting attribute 'ATTR_APPLICATION_PACKAGE'", e, false);
            return null;
        }
    }

    public static void setProjectName(ILaunchConfigurationWorkingCopy config, String projectName) {
        config.setAttribute(ATTR_PROJECT_NAME, projectName);
    }

    public static String getProjectName(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute(ATTR_PROJECT_NAME, "");
            if (0 == projectName.length()) {
                return null;
            }
            return projectName;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = WDLaunchConfigurationDelegate.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getProjectName", "Error: failed getting attribute 'ATTR_PROJECT_NAME'", e, false);
            return null;
        }
    }

    public static void setRunMode(ILaunchConfigurationWorkingCopy config, String runMode) {
        config.setAttribute(ATTR_RUN_MODE, runMode);
    }

    public static String getRunMode(ILaunchConfiguration configuration) {
        try {
            String runMode = configuration.getAttribute(ATTR_RUN_MODE, "");
            if (runMode.length() <= 0) {
                return null;
            }
            return runMode;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = WDLaunchConfigurationDelegate.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getRunMode", "Error: failed getting attribute 'ATTR_RUN_MODE'", e, false);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

