/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.launch;

import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LaunchService {
    private static TextPool mTPool = TextPool.getInstance();
    private static CoreTextPool mCPool = CoreTextPool.getInstance();
    protected static final String ATTR_APPLICATION_NAME = "APPLICATION_NAME";
    protected static final String ATTR_APPLICATION_PACKAGE = "APPLICATION_PACKAGE";
    protected static final String ATTR_PROJECT_NAME = "PROJECT_NAME";
    protected static final String ATTR_RUN_MODE = "RUN_MODE";
    protected static final String ATTR_DEBUG_SERVER = "DEBUG_SERVER";
    protected static final String ATTR_RUN_PARAMETER = "RUN_PARAMETER";
    protected static final String RUN_ONLY = "RUN_ONLY";
    protected static final String RUN_WITH_DEPLOYMENT = "RUN_WITH_DEPLOYMENT";
    protected static final String pluginID = ProjectBrowserPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    protected static final String BROWSE = mCPool.getText(208);
    protected static final String PROJECT = mCPool.getText(213);
    protected static final String WDAPPLICATION = mTPool.getText(302);
    protected static final String INVALID_PROJECT = mTPool.getText(400);
    protected static final String NO_PROJECT = mTPool.getText(401);
    protected static final String INVALID_APPLICATION = mTPool.getText(403);
    protected static final String NO_APPLICATION = mTPool.getText(404);
    static /* synthetic */ Class class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate;

    public static void setApplicationName(ILaunchConfigurationWorkingCopy config, String applicationName) {
        config.setAttribute(ATTR_APPLICATION_NAME, applicationName);
    }

    public static String getApplicationName(ILaunchConfiguration configuration) {
        try {
            String applicationName = configuration.getAttribute(ATTR_APPLICATION_NAME, "");
            if (0 == applicationName.length()) {
                return null;
            }
            return applicationName;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = LaunchService.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getApplicationName", "Error: failed getting attribute 'ATTR_APPLICATION_NAME'", e, false);
            return null;
        }
    }

    public static void setApplicationPackage(ILaunchConfigurationWorkingCopy config, String applicationPackage) {
        config.setAttribute(ATTR_APPLICATION_PACKAGE, applicationPackage);
    }

    public static String getApplicationPackage(ILaunchConfiguration configuration) {
        try {
            String applicationPackage = configuration.getAttribute(ATTR_APPLICATION_PACKAGE, "");
            if (applicationPackage.length() == 0) {
                return null;
            }
            return applicationPackage;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = LaunchService.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getApplicationPackage", "Error: failed getting attribute 'ATTR_APPLICATION_PACKAGE'", e, false);
            return null;
        }
    }

    public static void setProjectName(ILaunchConfigurationWorkingCopy config, String projectName) {
        config.setAttribute(ATTR_PROJECT_NAME, projectName);
    }

    public static String getProjectName(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute(ATTR_PROJECT_NAME, "");
            if (0 == projectName.length()) {
                return null;
            }
            return projectName;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = LaunchService.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getProjectName", "Error: failed getting attribute 'ATTR_PROJECT_NAME'", e, false);
            return null;
        }
    }

    public static void setRunMode(ILaunchConfigurationWorkingCopy config, String runMode) {
        config.setAttribute(ATTR_RUN_MODE, runMode);
    }

    public static String getRunMode(ILaunchConfiguration configuration) {
        try {
            String runMode = configuration.getAttribute(ATTR_RUN_MODE, "");
            if (runMode.length() <= 0) {
                return null;
            }
            return runMode;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = LaunchService.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getRunMode", "Error: failed getting attribute 'ATTR_RUN_MODE'", e, false);
            return null;
        }
    }

    public static void setDebugServer(ILaunchConfigurationWorkingCopy config, String debugServer) {
        config.setAttribute(ATTR_DEBUG_SERVER, debugServer);
    }

    public static String getDebugServer(ILaunchConfiguration configuration) {
        try {
            String debugServer = configuration.getAttribute(ATTR_DEBUG_SERVER, "");
            if (debugServer.length() <= 0) {
                return null;
            }
            return debugServer;
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate == null ? (class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate = LaunchService.class$("com.sap.ide.webdynpro.projectbrowser.launch.WDLaunchConfigurationDelegate")) : class$com$sap$ide$webdynpro$projectbrowser$launch$WDLaunchConfigurationDelegate, "getDebugServer", "Error: failed getting attribute 'ATTR_DEBUG_SERVER'", e, false);
            return null;
        }
    }

    public static IStatus isValidProject(String projectName) {
        if (projectName == null || projectName.length() <= 0) {
            return new Status(4, pluginID, 4, NO_PROJECT, null);
        }
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (eclipseProject == null || !eclipseProject.exists()) {
            return new Status(4, pluginID, 4, INVALID_PROJECT, null);
        }
        if (!eclipseProject.isOpen()) {
            String message = mTPool.getText(402, projectName);
            return new Status(4, pluginID, 4, message, null);
        }
        return new Status(0, pluginID, 0, "", null);
    }

    public static void displayAsyncMessage(IStatus status) {
        final String message = status.getMessage();
        Display.getDefault().syncExec(new Runnable(){
            String launch = LaunchService.access$000().getText(300) + " " + LaunchService.access$000().getText(302);

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)this.launch, (String)message);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ TextPool access$000() {
        return mTPool;
    }
}

