/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions.refactoring;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.projectbrowser.services.ServicesProjectBrowser;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import org.eclipse.swt.graphics.Image;

public class PBRenameAction
implements IElementSingleAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private Element mElement = null;

    public PBRenameAction(Element element) {
        this.mElement = element;
    }

    public ICategory getCategory() {
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainMetamodelCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)ServicesProjectBrowser.getImage(this.mElement));
    }

    public boolean isAvailable(Element element) {
        this.mElement = element;
        if (!(element instanceof Entity)) {
            return false;
        }
        return this.isElementValidForRename(element);
    }

    public boolean isEnabled(Element element) {
        UniqueName parentUin = element.getUniqueName();
        String subDomain = parentUin.getSubDomain();
        if (subDomain.equals("ModelClass")) {
            Model tsModel = element.getModel();
            if (tsModel == null) {
                return false;
            }
            if (!SelenaElementUtil.isProjectModelUniqueName((UniqueName)tsModel.getUniqueName())) {
                return false;
            }
            String projectName = tsModel.getUniqueName().getName();
            DataSourceManager dataSourceManager = DataSourceManager.getDataSourceManager((String)projectName);
            DevelopmentObject developmentObject = dataSourceManager.getDevelopmentObject(parentUin);
            if (developmentObject instanceof ModelClass) {
                return MetamodelServices.canRenameModelClass((ModelClass)((ModelClass)developmentObject));
            }
        }
        return this.isAvailable(element);
    }

    public void run(Element element) {
        if (!(element instanceof Entity)) {
            return;
        }
        String projectName = element.getModel().getUniqueName().getName();
        if (projectName == null || projectName.length() < 0) {
            return;
        }
        if (!this.isElementValidForRename(element)) {
            return;
        }
        UniqueName parentUin = element.getUniqueName();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(parentUin);
        boolean finished = ServicesProjectBrowser.callRenameWizard(developmentObject);
        if (finished && developmentObject.isMDO()) {
            MetamodelManager.saveAllMetaData((Metamodel)developmentObject.getMetamodel());
        }
    }

    private boolean isElementValidForRename(Element element) {
        UniqueName parentUin = element.getUniqueName();
        String subDomain = parentUin.getSubDomain();
        boolean isValid = subDomain.equals("View") || subDomain.equals("Window") || subDomain.equals("Component") || subDomain.equals("CustomController") || subDomain.equals("ComponentInterfaceDefinition") || subDomain.equals("InterfaceViewDefinition") || subDomain.equals("ModelClass");
        return isValid;
    }

    static {
        INFO = NAME = mText.getText(130);
        DESCRIPTION = mText.getText(227);
    }
}

