/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions.refactoring;

import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.webdynpro.projectbrowser.services.ServicesProjectBrowser;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteManager;
import com.sap.ide.webdynpro.service.core.paste.MDOPasteResult;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.swt.graphics.Image;

public class PBPasteAction
implements IElementSingleAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final String NAME;
    private static final String INFO;
    private static final Image IMAGE;
    private static final String DESCRIPTION;
    private static final ICategory CATEGORY;

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        if (!(element instanceof Entity)) {
            return false;
        }
        UniqueName uniqueName = element.getUniqueName();
        boolean available = false;
        if (uniqueName.getSubDomain().equals("Views") || uniqueName.getSubDomain().equals("CustomControllers") || uniqueName.getSubDomain().equals("Windows") || uniqueName.getSubDomain().equals("Components") || uniqueName.getSubDomain().equals("InterfaceViewDefinitions") || uniqueName.getSubDomain().equals("ComponentInterfaceDefinitions") || uniqueName.getSubDomain().equals("Applications")) {
            available = true;
        }
        return available;
    }

    public boolean isEnabled(Element element) {
        if (!(element instanceof Entity)) {
            return false;
        }
        String newProjectName = element.getModel().getUniqueName().getName();
        if (newProjectName == null || newProjectName.length() <= 0) {
            return false;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel((String)newProjectName);
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        DevelopmentObjectKey[] keys = clipboard.getContent();
        if (element.getUniqueName().getSubDomain().equals("Views")) {
            Component newParentComponent = ServicesProjectBrowser.findParentComponent(element);
            if (newParentComponent == null) {
                return false;
            }
            if (clipboard.isPasteAllowed((MetamodelObject)newParentComponent) && keys[0].getMDOType() == WebDynproMDOEnum.VIEW) {
                return true;
            }
        } else if (element.getUniqueName().getSubDomain().equals("CustomControllers")) {
            Component newParentComponent = ServicesProjectBrowser.findParentComponent(element);
            if (newParentComponent == null) {
                return false;
            }
            if (clipboard.isPasteAllowed((MetamodelObject)newParentComponent) && keys[0].getMDOType() == WebDynproMDOEnum.CONTROLLER) {
                return true;
            }
        } else if (element.getUniqueName().getSubDomain().equals("Components")) {
            WebDynproRoot newParentRoot = ServicesProjectBrowser.findParentRoot(element);
            if (newParentRoot == null) {
                return false;
            }
            if (clipboard.isPasteAllowed((MetamodelObject)newParentRoot) && keys[0].getMDOType() == WebDynproMDOEnum.COMPONENT) {
                return true;
            }
        } else if (element.getUniqueName().getSubDomain().equals("ComponentInterfaceDefinitions")) {
            WebDynproRoot newParentRoot = ServicesProjectBrowser.findParentRoot(element);
            if (newParentRoot == null) {
                return false;
            }
            if (clipboard.isPasteAllowed((MetamodelObject)newParentRoot) && keys[0].getMDOType() == WebDynproMDOEnum.COMPONENTINTERFACEDEFINITION) {
                return true;
            }
        } else if (element.getUniqueName().getSubDomain().equals("InterfaceViewDefinitions")) {
            ComponentInterfaceDefinition newParentCID = ServicesProjectBrowser.findParentComponentInterfaceDefinition(element);
            if (newParentCID == null) {
                return false;
            }
            if (clipboard.isPasteAllowed((MetamodelObject)newParentCID) && keys[0].getMDOType() == WebDynproMDOEnum.INTERFACEVIEW) {
                return true;
            }
        } else if (element.getUniqueName().getSubDomain().equals("Applications")) {
            WebDynproRoot newParentRoot = ServicesProjectBrowser.findParentRoot(element);
            if (newParentRoot == null) {
                return false;
            }
            if (clipboard.isPasteAllowed((MetamodelObject)newParentRoot) && keys[0].getMDOType() == WebDynproMDOEnum.APPLICATION) {
                return true;
            }
        }
        return false;
    }

    public void run(Element element) {
        if (!(element instanceof Entity)) {
            return;
        }
        String projectName = element.getModel().getUniqueName().getName();
        if (projectName == null || projectName.length() <= 0) {
            return;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        if (element.getUniqueName().getSubDomain().equals("Views") || element.getUniqueName().getSubDomain().equals("CustomControllers")) {
            Component parentComponent = ServicesProjectBrowser.findParentComponent(element);
            if (parentComponent == null) {
                return;
            }
            MDOPasteManager manager = new MDOPasteManager();
            manager.paste(clipboard, (MetamodelObject)parentComponent);
            this.saveIfNecessary(manager, metamodel);
        } else if (element.getUniqueName().getSubDomain().equals("Components") || element.getUniqueName().getSubDomain().equals("ComponentInterfaceDefinitions") || element.getUniqueName().getSubDomain().equals("Applications")) {
            UniqueName parentUin = element.getParent().getUniqueName();
            if (!parentUin.getSubDomain().equals("WebDynpro")) {
                return;
            }
            WebDynproRoot webDynproRoot = MetamodelServices.getWebDynproRoot((String)projectName);
            if (webDynproRoot == null) {
                return;
            }
            MDOPasteManager manager = new MDOPasteManager();
            manager.paste(clipboard, (MetamodelObject)webDynproRoot);
            this.saveIfNecessary(manager, metamodel);
        } else if (element.getUniqueName().getSubDomain().equals("InterfaceViewDefinitions")) {
            ComponentInterfaceDefinition newParentCID = ServicesProjectBrowser.findParentComponentInterfaceDefinition(element);
            if (newParentCID == null) {
                return;
            }
            MDOPasteManager manager = new MDOPasteManager();
            manager.paste(clipboard, (MetamodelObject)newParentCID);
            this.saveIfNecessary(manager, metamodel);
        }
    }

    private void saveIfNecessary(MDOPasteManager manager, Metamodel metamodel) {
        MDOPasteResult result = manager.getPasteResult();
        if (result != null && result.pasteSucceeded() && result.getCreatedMDOs().length > 0) {
            MetamodelManager.saveAllMetaData((Metamodel)metamodel);
        }
    }

    static {
        INFO = NAME = mText.getText(124);
        IMAGE = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DDIC_PASTE);
        DESCRIPTION = mText.getText(221);
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainMetamodelCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    }
}

