/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions.dc;

import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PublicPartFileOutputProvider;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.ModifyPublicPartAction;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.services.ServicesProjectBrowser;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.graphics.Image;

public class PBAddToPublicPartAction
extends ModifyPublicPartAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private Element mElement = null;
    private HashMap mPPModels = new HashMap();

    public PBAddToPublicPartAction(Element element) {
        this.mElement = element;
    }

    public ICategory getCategory() {
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainMetamodelCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)ServicesProjectBrowser.getImage(this.mElement));
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        this.mElement = element;
        this.clearPPModels();
        String subDomain = element.getUniqueName().getSubDomain();
        return subDomain.equals("Component") || subDomain.equals("Model") || subDomain.equals("ComponentInterfaceDefinition");
    }

    public boolean isEnabled(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        return ServicesEclipse.projectHasComponentNature((String)projectName);
    }

    public void run(Element element) {
        String objectName = "";
        String objectPackage = "";
        String projectName = element.getModel().getUniqueName().getName();
        DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
        DevelopmentObject developmentObject = manager.getDevelopmentObject(element.getUniqueName());
        if (developmentObject == null) {
            return;
        }
        IProject eclipseProject = this.getDCProject(element);
        if (eclipseProject == null) {
            return;
        }
        IPPModel mPPModel = this.getPPModel(eclipseProject);
        if (mPPModel == null) {
            return;
        }
        Entity entity = ComponentFactory.createEntity();
        objectName = developmentObject.getName();
        if (developmentObject.isMDO()) {
            objectPackage = ((MainDevelopmentObject)developmentObject).getPackage();
            objectPackage = objectPackage.replace('.', '/');
        }
        IPPModel.EntityType entityType = null;
        String subDomain = element.getUniqueName().getSubDomain();
        if (subDomain.equals("Component")) {
            entityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT;
        } else if (subDomain.equals("Model")) {
            entityType = IPPModel.EntityType.COMMON_MODEL;
        } else if (subDomain.equals("ComponentInterfaceDefinition")) {
            entityType = IPPModel.EntityType.WEB_DYNPRO_COMPONENT_INTERFACE_DEFINITION;
        }
        String type = entityType.toString();
        if (entityType.getSubTyps().length <= 0) {
            return;
        }
        String subType = entityType.getSubTyps()[0].toString();
        entity.setName(objectName);
        entity.setCaption(objectName);
        entity.setDescription(objectName);
        entity.setPackageName(objectPackage);
        entity.setType(type);
        entity.setSubType(subType);
        mPPModel.addEntity(entity);
        IFile thePPFile = this.getPPFile(eclipseProject, mPPModel);
        PublicPartFileOutputProvider outPutProvider = new PublicPartFileOutputProvider(thePPFile);
        try {
            mPPModel.writeModelTo((PPOutputProvider)outPutProvider);
        }
        catch (Exception e) {
            System.out.println("Exception in writeModelTo");
            ProjectBrowserPlugin.internalError(((Object)((Object)this)).getClass(), "run", "Exception ocurred writing Model to output provider", e, false);
        }
        MetamodelManager mmManager = MetamodelManager.getMetamodelManager((String)eclipseProject.getName());
        mmManager.refreshTSModel();
    }

    public IProject getDCProject(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject eclipseProject = workspaceRoot.getProject(projectName);
        return eclipseProject;
    }

    private synchronized IPPModel getPPModel(IProject aProject) {
        IPPModel aPPModel = (IPPModel)this.mPPModels.get(aProject.getFullPath());
        if (aPPModel == null) {
            aPPModel = super.getPPModel(aProject, null);
            this.mPPModels.put(aProject.getFullPath(), aPPModel);
        }
        return aPPModel;
    }

    private synchronized void clearPPModels() {
        this.mPPModels.clear();
    }

    static {
        INFO = NAME = mText.getText(127);
        DESCRIPTION = mText.getText(218);
    }
}

