/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions.check;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.webdynpro.checklayer.RepairResult;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.usage.ComponentUsageRepair;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.checklayer.RepairResultManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class PBRepairComponentUsageAction
implements IElementSingleAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final CoreTextPool mCText = CoreTextPool.getInstance();
    private static final String COMPONENT_USAGE = mCText.getText(129);
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final Image IMAGE;
    private static final ICategory CATEGORY;

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        return element.getUniqueName().getDomain().equals("WebDynpro") && element.getUniqueName().getSubDomain().equals("ComponentUsage");
    }

    public boolean isEnabled(Element element) {
        return this.isAvailable(element);
    }

    public void run(Element element) {
        if (element == null) {
            return;
        }
        final Element selenaElement = element;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (selenaElement instanceof Entity) {
                    Entity entity = (Entity)selenaElement;
                    UniqueName entityUIN = entity.getUniqueName();
                    if (!entityUIN.getDomain().equals("WebDynpro")) {
                        return;
                    }
                    String projectName = entity.getModel().getUniqueName().getName();
                    DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(entity.getUniqueName());
                    if (developmentObject == null) {
                        ProjectBrowserPlugin.internalError(this.getClass(), "runInternal", "developmentObject == null", null, false);
                        return;
                    }
                    if (developmentObject instanceof ComponentUsage) {
                        try {
                            ComponentUsage componentUsage = (ComponentUsage)developmentObject;
                            String repairInfo = CoreTextPool.getInstance().getText(409);
                            if (UIHelper.askUserToRepair((String)componentUsage.getName(), (String)COMPONENT_USAGE, (String)repairInfo)) {
                                MMRepositoryObject[] repositoryObjects = ComponentUsageRepair.getRepositoryObjectsAffectedByComponentReparation((ComponentUsage)componentUsage);
                                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                                    return;
                                }
                                RepairResult repairResult = new RepairResult();
                                ComponentUsageRepair.repair((ComponentUsage)componentUsage, (RepairResult)repairResult);
                                RepairResultManager.showRepairResults((RepairResult)repairResult);
                            }
                        }
                        catch (Throwable e) {
                            ProjectBrowserPlugin.internalError(this.getClass(), "runInternal", "Exception occured", e, false);
                        }
                    } else {
                        ProjectBrowserPlugin.internalError(this.getClass(), "run", "object is not a ComponentUsage: " + developmentObject.toString(), null, false);
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(this.getClass(), "run", "run failed", e, false);
        }
    }

    static {
        INFO = NAME = mText.getText(122);
        DESCRIPTION = mText.getText(218, COMPONENT_USAGE);
        IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_REPAIR);
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainMetamodelCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    }
}

