/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.webdynpro.ui.UIPlugin;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.sap.ide.webdynpro.ui.service.ServicesUI;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.swt.graphics.Image;

public class PBInternalNodeInfoAction
implements IElementSingleAction {
    private final String NAME = "Internal node info";
    private final String INFO = "Internal node info";
    private final String DESCRIPTION = "For debugging purpose. Displays information about UniqueName and metaclass.";
    private final Image IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_INFO);
    private final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainDefaultCategory(), (String)"For debugging purpose. Displays information about UniqueName and metaclass.", (String)"Internal node info", (String)"Internal node info", (Image)this.IMAGE);

    public PBInternalNodeInfoAction() {
    }

    public PBInternalNodeInfoAction(String text) {
    }

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    public boolean isAvailable(Element element) {
        return UIPlugin.getDefault().getPreferenceStore().getBoolean("diagnostic");
    }

    public boolean isEnabled(Element element) {
        return true;
    }

    public void run(Element element) {
        String domain = null;
        String subdomain = null;
        String location = null;
        String name = null;
        String metaclass = null;
        String message = null;
        if (element instanceof Entity) {
            Entity entity = (Entity)element;
            UniqueName uniqueName = entity.getUniqueName();
            domain = uniqueName.getDomain();
            subdomain = uniqueName.getSubDomain();
            location = uniqueName.getLocation();
            name = uniqueName.getName();
            metaclass = entity.getPropertyValue("$metaclass");
            message = "Domain\t\t: " + domain + "\n" + "Subdomain\t: " + subdomain + "\n" + "Location\t: " + location + "\n" + "Name\t\t: " + name + "\n" + "Metaclass\t: " + metaclass;
        } else {
            message = "Not a tssap-entity: \n" + element.getUniqueName().toString();
        }
        ServicesUI.displayTextDialog((String)"Internal node info", (String)message);
    }
}

