/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.ServiceWithUI;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class PBEditConfigurationControllerMappingAction
implements IElementMultiAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final CoreTextPool mCText = CoreTextPool.getInstance();
    private static final String CID_CONFIG_CONTROLLER = mCText.getText(131);
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final Image IMAGE;
    private static final ICategory CATEGORY;
    private Element mElement = null;

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String subdomain = elements[i].getUniqueName().getSubDomain();
                if (!subdomain.equals("ComponentUsageConfigurationController")) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        return this.isAvailable(elements);
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            this.mElement = elements[i];
            this.run();
            ++i;
        }
    }

    private void run() {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (PBEditConfigurationControllerMappingAction.this.mElement instanceof Entity) {
                    Entity entity = (Entity)PBEditConfigurationControllerMappingAction.this.mElement;
                    Entity componentUsageEntity = entity.getParent();
                    if (componentUsageEntity == null) {
                        ProjectBrowserPlugin.internalError(this.getClass(), "runInternal", "componentUsageEntity == null", null, false);
                        return;
                    }
                    String projectName = entity.getModel().getUniqueName().getName();
                    DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(componentUsageEntity.getUniqueName());
                    if (developmentObject == null) {
                        ProjectBrowserPlugin.internalError(this.getClass(), "runInternal", "developmentObject == null", null, false);
                        return;
                    }
                    if (developmentObject instanceof ComponentUsage) {
                        try {
                            ServiceWithUI.editComponentControllerUsageForConfigurationController((ComponentUsage)((ComponentUsage)developmentObject));
                        }
                        catch (Throwable e) {
                            ProjectBrowserPlugin.internalError(this.getClass(), "runInternal", "Exception occured", e, false);
                        }
                    } else {
                        ProjectBrowserPlugin.internalError(this.getClass(), "run", "object is not a ComponentUsage: " + developmentObject.toString(), null, false);
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.internalError(this.getClass(), "run", "run failed", e, false);
        }
    }

    static {
        INFO = NAME = mText.getText(115);
        DESCRIPTION = mText.getText(209, CID_CONFIG_CONTROLLER);
        IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT_CONFIGURATION_CONTROLLER);
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainMetamodelCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    }
}

