/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.actions.PBBaseAction;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Element;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class PBDevelopmentObjectAction
extends PBBaseAction {
    protected boolean mUseRunnable = false;

    public PBDevelopmentObjectAction(String[] allowedSubdomains) {
        super(allowedSubdomains);
    }

    public void run(Element element) {
        if (this.mUseRunnable) {
            final Element lElement = element;
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    PBDevelopmentObjectAction.this.runInternal(lElement);
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(runnable, null);
            }
            catch (CoreException e) {
                ProjectBrowserPlugin.internalError(this.getClass(), "run", "run failed", e, false);
            }
        } else {
            this.runInternal(element);
        }
    }

    private void runInternal(Element element) {
        if (element == null) {
            return;
        }
        String projectName = element.getModel().getUniqueName().getName();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(element.getUniqueName());
        if (developmentObject == null) {
            ProjectBrowserPlugin.internalError(this.getClass(), "runInternal", "developmentObject == null", null, false);
            return;
        }
        try {
            this.run(developmentObject);
        }
        catch (Throwable e) {
            ProjectBrowserPlugin.internalError(this.getClass(), "runInternal", "Exception occured", e, false);
        }
    }

    public abstract void run(DevelopmentObject var1);
}

